#!/usr/bin/env node

const readline = require('readline');

class Calculator {
  add(a, b) {
    return a + b;
  }

  subtract(a, b) {
    return a - b;
  }

  multiply(a, b) {
    return a * b;
  }

  divide(a, b) {
    if (b === 0) {
      throw new Error('Division by zero');
    }
    return a / b;
  }

  evaluate(expression) {
    // Simple expression evaluator
    expression = expression.replace(/\s+/g, '');

    // Handle basic operations
    if (expression.includes('+')) {
      const parts = expression.split('+');
      return this.add(parseFloat(parts[0]), parseFloat(parts[1]));
    } else if (expression.includes('-') && expression.indexOf('-') > 0) {
      const parts = expression.split('-');
      return this.subtract(parseFloat(parts[0]), parseFloat(parts[1]));
    } else if (expression.includes('*')) {
      const parts = expression.split('*');
      return this.multiply(parseFloat(parts[0]), parseFloat(parts[1]));
    } else if (expression.includes('/')) {
      const parts = expression.split('/');
      return this.divide(parseFloat(parts[0]), parseFloat(parts[1]));
    }

    return parseFloat(expression);
  }
}

async function runCalculator() {
  const calc = new Calculator();
  const rl = readline.createInterface({
    input: process.stdin,
    output: process.stdout
  });

  console.log('\n=== CLI Calculator ===');
  console.log('Enter expressions like: 5+3, 10-2, 4*6, 20/4');
  console.log('Type "quit" or "exit" to close\n');

  const askQuestion = (query) => {
    return new Promise(resolve => rl.question(query, resolve));
  };

  let running = true;
  while (running) {
    const input = await askQuestion('> ');

    if (input.toLowerCase() === 'quit' || input.toLowerCase() === 'exit') {
      running = false;
      console.log('Goodbye!');
    } else {
      try {
        const result = calc.evaluate(input);
        console.log(`= ${result}\n`);
      } catch (error) {
        console.log(`Error: ${error.message}\n`);
      }
    }
  }

  rl.close();
}

if (require.main === module) {
  runCalculator().catch(console.error);
}

module.exports = Calculator;
