#!/usr/bin/env node

const Calculator = require('./calculator.js');

function runTests() {
  const calc = new Calculator();
  let passed = 0;
  let failed = 0;

  console.log('\n=== Running Calculator Tests ===\n');

  // Test addition
  try {
    const result = calc.add(5, 3);
    if (result === 8) {
      console.log('✓ Addition test passed: 5 + 3 = 8');
      passed++;
    } else {
      console.log(`✗ Addition test failed: expected 8, got ${result}`);
      failed++;
    }
  } catch (e) {
    console.log(`✗ Addition test error: ${e.message}`);
    failed++;
  }

  // Test subtraction
  try {
    const result = calc.subtract(10, 4);
    if (result === 6) {
      console.log('✓ Subtraction test passed: 10 - 4 = 6');
      passed++;
    } else {
      console.log(`✗ Subtraction test failed: expected 6, got ${result}`);
      failed++;
    }
  } catch (e) {
    console.log(`✗ Subtraction test error: ${e.message}`);
    failed++;
  }

  // Test multiplication
  try {
    const result = calc.multiply(6, 7);
    if (result === 42) {
      console.log('✓ Multiplication test passed: 6 * 7 = 42');
      passed++;
    } else {
      console.log(`✗ Multiplication test failed: expected 42, got ${result}`);
      failed++;
    }
  } catch (e) {
    console.log(`✗ Multiplication test error: ${e.message}`);
    failed++;
  }

  // Test division
  try {
    const result = calc.divide(20, 5);
    if (result === 4) {
      console.log('✓ Division test passed: 20 / 5 = 4');
      passed++;
    } else {
      console.log(`✗ Division test failed: expected 4, got ${result}`);
      failed++;
    }
  } catch (e) {
    console.log(`✗ Division test error: ${e.message}`);
    failed++;
  }

  // Test division by zero
  try {
    calc.divide(10, 0);
    console.log('✗ Division by zero test failed: should throw error');
    failed++;
  } catch (e) {
    if (e.message === 'Division by zero') {
      console.log('✓ Division by zero test passed: error caught');
      passed++;
    } else {
      console.log(`✗ Division by zero test failed: wrong error message`);
      failed++;
    }
  }

  // Test evaluate
  try {
    const result = calc.evaluate('15+25');
    if (result === 40) {
      console.log('✓ Evaluate test passed: 15+25 = 40');
      passed++;
    } else {
      console.log(`✗ Evaluate test failed: expected 40, got ${result}`);
      failed++;
    }
  } catch (e) {
    console.log(`✗ Evaluate test error: ${e.message}`);
    failed++;
  }

  console.log(`\n=== Test Results ===`);
  console.log(`Passed: ${passed}`);
  console.log(`Failed: ${failed}`);
  console.log(`Total: ${passed + failed}\n`);

  process.exit(failed > 0 ? 1 : 0);
}

if (require.main === module) {
  runTests();
}
