/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.sso.client;

import com.perforce.sso.client.ServiceTicketGenerator;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.varia.NullAppender;

public class KerbClient {
    private static Logger logger = null;
    private static final String NO_LOG = "NONE";
    private static final String LOG_APPEND = "true";

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            System.out.println("Required logging argument missing");
            System.exit(1);
        }
        try {
            Object object;
            String string = stringArray[0];
            String string2 = stringArray[1];
            if (string.equals(NO_LOG)) {
                BasicConfigurator.configure(new NullAppender());
            } else {
                object = new FileAppender(new PatternLayout("%m%n"), string, string2.equals(LOG_APPEND));
                BasicConfigurator.configure((Appender)object);
            }
            logger = Logger.getLogger(KerbClient.class.getName());
            if (stringArray.length != 6) {
                logger.error("Invalid command line: got " + stringArray.length + " arguments");
                System.out.println("Invalid command line: got " + stringArray.length + " arguments");
                System.exit(1);
            }
            object = KerbClient.requiredArg(stringArray[2], "Realm");
            String string3 = KerbClient.requiredArg(stringArray[3], "Domain controller");
            String string4 = KerbClient.requiredArg(stringArray[4], "Login configuration file");
            String string5 = KerbClient.requiredArg(stringArray[5], "Perforce service name");
            System.setProperty("java.security.krb5.realm", (String)object);
            System.setProperty("java.security.krb5.kdc", string3);
            System.setProperty("java.security.auth.login.config", string4);
            logger.debug("Set Kerberos properties");
            LoginContext loginContext = new LoginContext("SignedOnUserLoginContext");
            loginContext.login();
            logger.info("Authenticated as current user");
            Subject subject = loginContext.getSubject();
            byte[] byArray = Subject.doAs(subject, new ServiceTicketGenerator(subject, string5));
            logger.info("Got encoded service ticket");
            Base64 base64 = new Base64();
            String string6 = base64.encodeAsString(byArray);
            logger.debug("Service ticket: " + string6);
            System.out.println(string6);
            logger.debug("Wrote ticket");
            System.exit(0);
        }
        catch (Exception exception) {
            if (null != logger) {
                logger.error(exception.getMessage(), exception);
                System.out.println(exception.getMessage());
            } else {
                System.out.println("Unexpected error, probably while starting logging system: " + exception.getMessage());
            }
            System.exit(1);
        }
    }

    private static String requiredArg(String string, String string2) {
        if (null == string || string.length() < 1) {
            logger.error(string2 + " is required argument to this program");
            System.out.println(string2 + " is required argument to this program");
            System.exit(1);
        }
        return string;
    }
}

