/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.sso.client;

import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import org.apache.log4j.Logger;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

final class ServiceTicketGenerator
implements PrivilegedExceptionAction<byte[]> {
    private final Subject subject;
    private final String svcName;
    private final Logger logger;

    public ServiceTicketGenerator(Subject subject, String string) {
        this.subject = subject;
        this.svcName = string;
        this.logger = Logger.getLogger(ServiceTicketGenerator.class.getName());
    }

    @Override
    public byte[] run() throws Exception {
        try {
            Oid oid = new Oid("1.2.840.113554.1.2.2");
            GSSManager gSSManager = GSSManager.getInstance();
            String string = this.subject.getPrincipals().iterator().next().getName();
            this.logger.info("Authenticating as: " + string);
            GSSName gSSName = gSSManager.createName(string, GSSName.NT_USER_NAME);
            GSSName gSSName2 = gSSManager.createName(this.svcName, null);
            GSSCredential gSSCredential = gSSManager.createCredential(gSSName, 28800, oid, 1);
            this.logger.debug("Created client credentials");
            GSSContext gSSContext = gSSManager.createContext(gSSName2, oid, gSSCredential, 0);
            this.logger.debug("Created service context");
            byte[] byArray = gSSContext.initSecContext(new byte[0], 0, 0);
            this.logger.info("Created service ticket");
            gSSContext.dispose();
            return byArray;
        }
        catch (Exception exception) {
            throw new PrivilegedActionException(exception);
        }
    }
}

