//
//  AppDelegate.m
//  Perforce
//
//  Created by Adam Czubernat on 07.05.2013.
//  Copyright (c) 2013 Perforce Software, Inc. All rights reserved.
//

#import "AppDelegate.h"
#import "MainWindowController.h"

@interface AppDelegate () {
	MainWindowController *windowController;
	NSString *launchURL;
}
- (void)handleURLEvent:(NSAppleEventDescriptor *)event withReplyEvent:(NSAppleEventDescriptor *)replyEvent;
@end

@implementation AppDelegate

- (void)applicationWillFinishLaunching:(NSNotification *)notification {
	// Set URL handler
	NSAppleEventManager *appleEventManager = [NSAppleEventManager sharedAppleEventManager];
	[appleEventManager setEventHandler:self andSelector:@selector(handleURLEvent:withReplyEvent:)
						 forEventClass:kInternetEventClass andEventID:kAEGetURL];
}

- (void)applicationDidFinishLaunching:(NSNotification *)aNotification {
	
	// Load default values
	[NSUserDefaults loadDefaultsWithName:@"UserDefaults"];
	
	// Set the exception handler
	PSDebugInstallCrashHandler();
	
	PSLogStore(@"AppVersion", @"04-03");
	
	if (!windowController)
		windowController = [[MainWindowController alloc] init];

	[windowController showWindow:self];
	
	if (launchURL) {
		[windowController loadURL:launchURL];
		launchURL = nil;
	}
}

//- (BOOL)applicationShouldTerminateAfterLastWindowClosed:(NSApplication *)sender {
//	return YES;
//}

- (BOOL)applicationShouldHandleReopen:(NSApplication *)sender hasVisibleWindows:(BOOL)windows {
	if (!windows) {
//		windowController = [[MainWindowController alloc] init];
//		[windowController showWindow:self];
		[windowController showWindow:self];
	}
	
	return NO; // Don't perform default tasks
}

#pragma mark - URL Event handler

- (void)handleURLEvent:(NSAppleEventDescriptor *)event withReplyEvent:(NSAppleEventDescriptor *)replyEvent {
	NSString *url = [[event paramDescriptorForKeyword:keyDirectObject] stringValue];
	PSLog(@"Opening external URL:\n%@", url);
	
	if (!windowController)
		launchURL = url;
	[windowController loadURL:url];
}

@end
