//
//  P4Reachability.m
//  Perforce
//
//  Created by Adam Czubernat on 16/01/2014.
//  Copyright (c) 2014 Perforce Software, Inc. All rights reserved.
//

#import "P4Reachability.h"

#import <SystemConfiguration/SystemConfiguration.h>
#import <netinet/in.h>
#import <netdb.h>
#import <sys/socket.h>
#import <sys/types.h>
#import <arpa/inet.h>
#import <netinet/in.h>
#import <unistd.h>

static SCNetworkReachabilityRef reachability;

NSString * const P4ReachabilityNotification = @"P4ReachabilityNotification";

void reachabilityCallback(SCNetworkReachabilityRef target, SCNetworkReachabilityFlags flags, void* info);

@interface P4Reachability ()
+ (SCNetworkReachabilityRef)currentReachability;
@end

@implementation P4Reachability

+ (BOOL)isConnected {
	
    [self currentReachability];
    
    // Recover reachability flags
	SCNetworkReachabilityFlags flags;
    
    BOOL didRetrieveFlags = SCNetworkReachabilityGetFlags(reachability, &flags);
	
	if (!didRetrieveFlags)
		[NSException raise:PSDomain format:@"Could not get reachability flags"];
	
	if ((flags & kSCNetworkFlagsReachable) &&
		!(flags & kSCNetworkFlagsConnectionRequired))
        return YES;
    
    return NO;
}

+ (SCNetworkReachabilityRef)currentReachability {
    
    if (reachability)
        return reachability;
    
    // Create zero address
	struct sockaddr_in zeroAddress;
	bzero(&zeroAddress, sizeof(zeroAddress));
	zeroAddress.sin_len = sizeof(zeroAddress);
	zeroAddress.sin_family = AF_INET;
	
	reachability = SCNetworkReachabilityCreateWithAddress(NULL, (struct sockaddr *)&zeroAddress);
    
    return reachability;
}

+ (void)startNotifier {
    [self currentReachability];
	if (SCNetworkReachabilitySetCallback(reachability, reachabilityCallback, NULL))
        SCNetworkReachabilityScheduleWithRunLoop(reachability, CFRunLoopGetMain(), kCFRunLoopDefaultMode);
}

+ (void)stopNotifier {
	if (reachability)
		SCNetworkReachabilityUnscheduleFromRunLoop(reachability, CFRunLoopGetMain(), kCFRunLoopDefaultMode);
}

@end

void reachabilityCallback(SCNetworkReachabilityRef target, SCNetworkReachabilityFlags flags, void *info) {
	@autoreleasepool {
        [[NSNotificationCenter defaultCenter]
		 postNotificationName:P4ReachabilityNotification object:nil];
    }
}
