//
//  NSTableView+Additions.h
//  Perforce
//
//  Created by Adam Czubernat on 19/12/2013.
//  Copyright (c) 2013 Perforce Software, Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@interface NSTableView (Additions)

- (void)reloadDataForRowsInRange:(NSRange)range;
- (void)reloadDataForRowsFromIndex:(NSInteger)firstIndex toIndex:(NSInteger)lastIndex;
- (void)insertRowsInRange:(NSRange)range withAnimation:(NSTableViewAnimationOptions)animationOptions;
- (void)insertRowsFromIndex:(NSInteger)firstIndex toIndex:(NSInteger)lastIndex withAnimation:(NSTableViewAnimationOptions)animationOptions;
- (void)removeRowsInRange:(NSRange)range withAnimation:(NSTableViewAnimationOptions)animationOptions;
- (void)removeRowsFromIndex:(NSInteger)firstIndex toIndex:(NSInteger)lastIndex withAnimation:(NSTableViewAnimationOptions)animationOptions;
- (void)updateRowsHeightInRange:(NSRange)range;
- (void)updateRowsHeightFromIndex:(NSInteger)firstIndex toIndex:(NSInteger)lastIndex;

@end
