//
//  NSUserDefaults+Additions.h
//  Perforce
//
//  Created by Adam Czubernat on 13.06.2013.
//  Copyright (c) 2013 Perforce Software, Inc. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface NSUserDefaults (Additions)

+ (void)loadDefaultsWithName:(NSString *)name;
+ (void)loadDefaultsWithDictionary:(NSDictionary *)dictionary;

+ (void)removeAllDefaults;

+ (NSString *)stringForKey:(NSString *)defaultName;
+ (void)setString:(NSString *)value forKey:(NSString *)defaultName;

+ (NSColor *)colorForKey:(NSString *)defaultName;

+ (NSInteger)integerForKey:(NSString *)defaultName;
+ (CGFloat)floatForKey:(NSString *)defaultName;
+ (BOOL)boolForKey:(NSString *)defaultName;


@end
