//
//  PSTimer.m
//  Perforce
//
//  Created by Adam Czubernat on 02/10/2013.
//  Copyright (c) 2013 Perforce Software, Inc. All rights reserved.
//

#import "PSTimer.h"
#import <objc/message.h>

@interface PSTimer ()
@property (nonatomic, retain) NSTimer *timer;
@property (nonatomic, weak) id target;
@property (nonatomic, assign) SEL selector;
- (void)action;
@end

@implementation PSTimer
@synthesize timer, target, selector;

#pragma mark - Public

+ (PSTimer *)scheduledTimerWithTimeInterval:(NSTimeInterval)interval target:(id)target selector:(SEL)selector userInfo:(id)info repeats:(BOOL)repeats {
	PSTimer *timer = [[PSTimer alloc] init];
	timer.target = target;
	timer.selector = selector;
	timer.timer = [NSTimer
				   scheduledTimerWithTimeInterval:interval
				   target:timer
				   selector:@selector(action)
				   userInfo:info
				   repeats:repeats];
	return timer;
}

- (id)initWithFireDate:(NSDate *)date interval:(NSTimeInterval)interval target:(id)aTarget selector:(SEL)aSelector userInfo:(id)info repeats:(BOOL)repeats {
	self = [super init];
	if (self) {
		target = aTarget;
		selector = aSelector;
		timer = [[NSTimer alloc]
				 initWithFireDate:date
				 interval:interval
				 target:self
				 selector:@selector(action)
				 userInfo:info
				 repeats:repeats];
	}
	return self;
}

- (void)invalidate {
	[timer invalidate];
	timer = nil;
}

#pragma mark - Private

- (void)action {
	objc_msgSend(target, selector);
}

@end
