//
//  P4WorkspaceDefaults.h
//  Perforce
//
//  Created by Adam Czubernat on 13/12/2013.
//  Copyright (c) 2013 Perforce Software, Inc. All rights reserved.
//

#import "PSDefaults.h"

extern NSString * const P4WorkspaceDefaultsChangedNotification;
extern NSString * const P4WorkspaceDefaultsTagFilterNotification;

@interface P4WorkspaceDefaults : PSDefaults

+ (P4WorkspaceDefaults *)sharedInstance;
+ (void)setWorkspace:(NSString *)workspace;

@property (nonatomic, retain) NSArray *favoriteFolders;
@property (nonatomic, retain) NSArray *favoriteTags;

@property (nonatomic, retain) NSDictionary *favoriteNames;
@property (nonatomic, retain) NSArray *filteredTags;

@property (nonatomic, assign) BOOL iconView;

- (void)addFavoriteFolder:(NSString *)folder;
- (void)removeFavoriteFolder:(NSString *)folder;
- (void)renameFavoriteFolder:(NSString *)folder name:(NSString *)name;

- (void)removeFavoriteTag:(NSString *)tag;
- (void)setFilteredTag:(NSString *)tag;

@end
