//
//  P4WorkspaceDefaults.m
//  Perforce
//
//  Created by Adam Czubernat on 13/12/2013.
//  Copyright (c) 2013 Perforce Software, Inc. All rights reserved.
//

#import "P4WorkspaceDefaults.h"

NSString * const P4WorkspaceDefaultsChangedNotification = @"P4WorkspaceDefaultsChangedNotification";
NSString * const P4WorkspaceDefaultsTagFilterNotification = @"P4WorkspaceDefaultsTagFilterNotification";

static P4WorkspaceDefaults *sharedInstance;

@interface P4WorkspaceDefaults () {
	NSString *workspace;
}
- (id)initWithWorkspace:(NSString *)workspace;
@end

@implementation P4WorkspaceDefaults
@synthesize favoriteFolders, favoriteTags, favoriteNames, filteredTags;
@synthesize iconView;

+ (P4WorkspaceDefaults *)sharedInstance {
	return sharedInstance;
}

+ (void)setWorkspace:(NSString *)workspace {
	if (workspace)
		sharedInstance = [[P4WorkspaceDefaults alloc] initWithWorkspace:workspace];
	else
		sharedInstance = nil;
}

- (id)initWithWorkspace:(NSString *)aWorkspace {
	workspace = aWorkspace;
	return self = [super init];
}

- (NSString *)keyPath {
	return [NSString stringWithFormat:@"Workspaces.%@", workspace];
}

- (void)addFavoriteFolder:(NSString *)folder {
	NSMutableArray *mutableFolders = [NSMutableArray arrayWithArray:favoriteFolders];
	[mutableFolders addObject:folder];
	self.favoriteFolders = mutableFolders;
	
	[[NSNotificationCenter defaultCenter]
	 postNotificationName:P4WorkspaceDefaultsChangedNotification
	 object:folder];
}

- (void)removeFavoriteFolder:(NSString *)folder {
	NSMutableArray *mutableFolders = [NSMutableArray arrayWithArray:favoriteFolders];
	[mutableFolders removeObject:folder];
	self.favoriteFolders = mutableFolders;
	
	if (favoriteNames) {
		NSMutableDictionary *names = [NSMutableDictionary dictionaryWithDictionary:favoriteNames];
		[names removeObjectForKey:folder];
		self.favoriteNames = names;
	}
	
	[[NSNotificationCenter defaultCenter]
	 postNotificationName:P4WorkspaceDefaultsChangedNotification
	 object:folder];
}

- (void)renameFavoriteFolder:(NSString *)folder name:(NSString *)name {
	NSMutableDictionary *mutableNames = [NSMutableDictionary dictionaryWithDictionary:favoriteNames];
	[mutableNames setObject:name forKey:folder];
	self.favoriteNames = mutableNames;
}

- (void)removeFavoriteTag:(NSString *)tag {
	NSMutableArray *mutableTags = [NSMutableArray arrayWithArray:favoriteTags];
	[mutableTags removeObject:tag];
	self.favoriteTags = mutableTags;
	
	if ([filteredTags containsObject:tag]) {
		[self setFilteredTag:tag];
	}
}

- (void)setFilteredTag:(NSString *)tag {
	NSMutableArray *filtered = [NSMutableArray arrayWithArray:filteredTags];
	if ([filtered containsObject:tag])
		[filtered removeObject:tag];
	else
		[filtered addObject:tag];
	self.filteredTags = filtered;
	
	[[NSNotificationCenter defaultCenter]
	 postNotificationName:P4WorkspaceDefaultsTagFilterNotification
	 object:tag];
}

@end
