//
//  PSFileEvents.h
//  Perforce
//
//  Created by Adam Czubernat on 03.07.2013.
//  Copyright (c) 2013 Perforce Software, Inc. All rights reserved.
//

#import <Foundation/Foundation.h>

@class PSFileEvents;
@protocol PSFileEventsDelegate <NSObject>
- (void)fileEvents:(PSFileEvents *)events created:(NSArray *)paths;
- (void)fileEvents:(PSFileEvents *)events removed:(NSArray *)paths;
- (void)fileEvents:(PSFileEvents *)events moved:(NSArray *)paths to:(NSArray *)newPaths;
- (void)fileEvents:(PSFileEvents *)events renamed:(NSArray *)paths to:(NSArray *)newPaths;
- (void)fileEvents:(PSFileEvents *)events modified:(NSArray *)paths;
@end


@interface PSFileEvents : NSObject

@property (nonatomic, unsafe_unretained) id <PSFileEventsDelegate> delegate;
@property (nonatomic, copy) NSString *root;

- (id)initWithRoot:(NSString *)root;
- (id)initWithRoot:(NSString *)root ignoreSelf:(BOOL)ignore; // Ignore events from current process

- (void)flush; // Flush events buffer manually

@end
