//
//  PSButton.m
//  Perforce
//
//  Created by Adam Czubernat on 13.06.2013.
//  Copyright (c) 2013 Perforce Software, Inc. All rights reserved.
//

#import "PSButton.h"

@implementation PSButton

- (void)awakeFromNib {
	NSTrackingAreaOptions trackingOptions = (NSTrackingActiveInKeyWindow |
											 NSTrackingMouseEnteredAndExited |
											 NSTrackingAssumeInside |
											 NSTrackingInVisibleRect);
    NSTrackingArea *trackingArea = [[NSTrackingArea alloc]
									initWithRect:NSZeroRect
									options:trackingOptions
									owner:self userInfo:nil];
    [self addTrackingArea:trackingArea];
}

- (void)mouseEntered:(NSEvent *)theEvent {
	if ([self isEnabled])
		[self setAlphaValue:0.8f];
}

- (void)mouseExited:(NSEvent *)theEvent {
	[self setAlphaValue:1.0f];
}

@end
