//
//  PSCollectionView.m
//  Perforce
//
//  Created by Adam Czubernat on 12.07.2013.
//  Copyright (c) 2013 Perforce Software, Inc. All rights reserved.
//

#import "PSCollectionView.h"

@interface PSCollectionView () {
	NSInteger _clickedIndex;
}
@end

@implementation PSCollectionView

- (void)keyDown:(NSEvent *)event {
	
	unichar keyChar = [[event charactersIgnoringModifiers] characterAtIndex:0];
	NSUInteger flags = [event modifierFlags] & NSDeviceIndependentModifierFlagsMask;
	
	if (keyChar == NSDeleteCharacter && flags == NSCommandKeyMask) {
		// Send delete notification
		if ([self.delegate respondsToSelector:@selector(collectionViewDidReceiveCommandDeleteKey:)])
			[(id)self.delegate collectionViewDidReceiveCommandDeleteKey:self];
	} else if (keyChar == ' ' && flags == 0) {
		// Send space bar notification
		if ([self.delegate respondsToSelector:@selector(collectionViewDidReceiveSpacebarKey:)])
			[(id)self.delegate collectionViewDidReceiveSpacebarKey:self];
//	} else if (keyChar == NSUpArrowFunctionKey || keyChar == NSDownArrowFunctionKey) {
//		// Relay Up and Down arrow keys from other views (QuickLook)
//		NSView *tableView = [self browserTableViewForColumn:self.selectedColumn];
//		[tableView keyDown:event];
	} else {
		[super keyDown:event];
	}
}

- (NSMenu *)menuForEvent:(NSEvent *)event {
	
	NSPoint location = [self convertPoint:event.locationInWindow fromView:nil];
	_clickedIndex = [self indexOfItemAtPoint:location];
	
	return [super menuForEvent:event];
}

#pragma mark - Public

- (NSInteger)indexOfItemAtPoint:(NSPoint)point {
	NSSize size = [self frameForItemAtIndex:0].size;
	if (!size.width || !size.height)
		return NSNotFound;	
	NSInteger numberOfCols =  self.frame.size.width / size.width;
	NSInteger col = (int)point.x / (int)size.width;
	if (col < numberOfCols) {
		NSInteger row = (int)point.y / (int)size.height;
		NSInteger index = col + row * numberOfCols;
		if (index < self.content.count)
			return index;
	}
	return NSNotFound;
}

- (NSInteger)clickedIndex {
	return _clickedIndex;
}

@end
