//
//  PSCustomScrollView.m
//  Perforce
//
//  Created by Adam Czubernat on 02/01/2014.
//  Copyright (c) 2014 Perforce Software, Inc. All rights reserved.
//

#import "PSCustomScrollView.h"

@implementation PSCustomScrollView
@synthesize scrollDisabled, scrollHorizontalOnly, scrollVerticalOnly;

- (void)scrollWheel:(NSEvent *)theEvent {
	if (scrollDisabled)
		[[self nextResponder] scrollWheel:theEvent];
	else {
		if (scrollVerticalOnly ?
			theEvent.deltaX && !theEvent.deltaY :
			scrollHorizontalOnly ?
			!theEvent.deltaX && theEvent.deltaY : NO)
			[[self nextResponder] scrollWheel:theEvent];
		[super scrollWheel:theEvent];
	}
}

@end
