//
//  PSSplitView.m
//  Perforce
//
//  Created by Adam Czubernat on 17.06.2013.
//  Copyright (c) 2013 Perforce Software, Inc. All rights reserved.
//

#import "PSSplitView.h"

@implementation PSSplitView
@synthesize dividerWidth, hidesDivider, drawingBlock;

- (void)awakeFromNib {
	dividerWidth = 1.0f;
}

- (void)drawDividerInRect:(NSRect)rect {
	if (hidesDivider)
		return;
	
	// Custom drawing block
    if (drawingBlock)
		drawingBlock(self, rect);
	else
		[super drawDividerInRect:rect];
}

- (CGFloat)dividerThickness {
	return dividerWidth;
}

- (void)insertFirstSubview:(NSView *)subview animated:(BOOL)animated {

	NSMutableArray *subviews = [self.subviews mutableCopy];
	[subviews insertObject:subview atIndex:0];
	[self setSubviews:subviews];
	
	CGRect subviewRect = [subview frame];
	CGRect rect = subviewRect;
	rect.size.height = 0.0f;
	[subview setFrame:rect];
	
	[NSView animateWithDuration:0.1f animations:^{
		[[subview animator] setFrame:subviewRect];
	} completion:^{
		[subview setFrame:subviewRect];
	}];
}

- (void)removeFirstSubviewAnimated:(BOOL)animated {

	NSView *subview = [self.subviews objectAtIndex:0];
	CGRect subviewRect = [subview frame];
	CGRect rect = subviewRect;
	rect.size.height = 0.0f;
	
	[NSView animateWithDuration:0.1f animations:^{
		[[subview animator] setFrame:rect];
	} completion:^{
		[subview removeFromSuperview];
		[subview setFrame:subviewRect];
	}];
}

@end
