//
//  PSTableView.m
//  Perforce
//
//  Created by Adam Czubernat on 17/12/2013.
//  Copyright (c) 2013 Perforce Software, Inc. All rights reserved.
//

#import "PSTableView.h"

@implementation PSTableView

- (void)draggingSession:(NSDraggingSession *)session endedAtPoint:(NSPoint)screenPoint operation:(NSDragOperation)operation {
	CGRect rect = [[self superview] convertRect:self.frame toView:nil];
	rect = [self.window convertRectToScreen:rect];
	if (!CGRectContainsPoint(rect, screenPoint))
		NSShowAnimationEffect(NSAnimationEffectPoof, screenPoint, CGSizeZero, nil, nil, NULL);
	[super draggingSession:session endedAtPoint:screenPoint operation:operation];
}

- (void)draggingSession:(NSDraggingSession *)session movedToPoint:(NSPoint)screenPoint {
	CGRect rect = [[self superview] convertRect:self.frame toView:nil];
	rect = [self.window convertRectToScreen:rect];
	
	BOOL inside = CGRectContainsPoint(rect, screenPoint);		
	[inside ? [NSCursor arrowCursor] : [NSCursor disappearingItemCursor] set];
	[session setAnimatesToStartingPositionsOnCancelOrFail:inside];
}

@end
