//
//  LoadingPanelController.m
//  Perforce
//
//  Created by Adam Czubernat on 12.07.2013.
//  Copyright (c) 2013 Perforce Software, Inc. All rights reserved.
//

#import "LoadingPanelController.h"

@interface LoadingPanelController () {
	
	CGFloat progress;
	NSString *title;
	NSProgressIndicatorStyle style;
	BOOL indeterminate;
	
	NSView *loadingView;
	__weak IBOutlet NSView *barLoadingView;
	__weak IBOutlet NSView *circularLoadingView;
	
	NSProgressIndicator *indicator;
	__weak IBOutlet NSProgressIndicator *barLoadingIndicator;
	__weak IBOutlet NSProgressIndicator *circularLoadingIndicator;
	
	NSTextField *titleLabel;
	__weak IBOutlet NSTextField *barLoadingTitleLabel;
	__weak IBOutlet NSTextField *circularLoadingTitleLabel;
}
@end

@implementation LoadingPanelController

#pragma mark - Public

- (id)initWithStyle:(NSProgressIndicatorStyle)aStyle {
	if (self = [super init]) {
		style = aStyle;
		indeterminate = YES;
	}
	return self;
}

- (void)setProgress:(CGFloat)aProgress {
	[indicator setIndeterminate:NO];
	progress = aProgress;
	[indicator setDoubleValue:progress * 100.0];
}

- (CGFloat)progress {
	return progress;
}

- (void)setTitle:(NSString *)aTitle {
	title = aTitle;
	titleLabel.stringValue = title;
}

- (NSString *)title {
	return titleLabel.stringValue;
}

- (void)setIndeterminate:(BOOL)anIndeterminate {
	indeterminate = anIndeterminate;
	[indicator setIndeterminate:indeterminate];
}

- (BOOL)indeterminate {
	return indeterminate;
}

#pragma mark - Override

- (void)windowDidLoad {
	[super windowDidLoad];
		
	if (style == NSProgressIndicatorBarStyle) {
		loadingView = barLoadingView;
		indicator = barLoadingIndicator;
		titleLabel = barLoadingTitleLabel;
	} else {
		loadingView = circularLoadingView;
		indicator = circularLoadingIndicator;
		titleLabel = circularLoadingTitleLabel;
	}
	
	titleLabel.stringValue = title;
	[indicator setDoubleValue:progress * 100.0];
	[self setPresentedView:loadingView];
	
	[indicator setIndeterminate:indeterminate];
	[indicator startAnimation:nil];
}

@end
