//
//  LoginPanelController.h
//  Perforce
//
//  Created by Adam Czubernat on 13.05.2013.
//  Copyright (c) 2013 Perforce Software, Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "PanelController.h"

@protocol LoginPanelControllerDelegate <NSObject>
- (void)loginPanelDidLogin;
- (void)loginPanelDidLoginWithWorkspace:(NSString *)workspace;
- (void)loginPanelDidRelogin;
- (void)loginPanelDidCancel;
@end

@interface LoginPanelController : PanelController

+ (LoginPanelController *)connectionPanel;
+ (LoginPanelController *)loginPanel;
+ (LoginPanelController *)reloginPanel;

@property (nonatomic, unsafe_unretained) id <LoginPanelControllerDelegate> delegate;
@property (nonatomic, assign) BOOL allowsAutomaticLogin;
@property (nonatomic, assign) BOOL allowsSSOLogin;

@end
