//
//  PSDefines.h
//  Perforce
//
//  Created by Adam Czubernat on 07.05.2013.
//  Copyright (c) 2013 Perforce Software, Inc. All rights reserved.
//

#import <Foundation/Foundation.h>
#ifdef __cplusplus
extern "C" {
#endif
	
/* Defines */

#define PS_LOGGING
#define PS_DEPRECATED __attribute__ ((deprecated))
#define PS_ABSTRACT_METHOD { _Pragma("clang diagnostic push") _Pragma("clang diagnostic ignored \"-Wreturn-type\"") [NSException raise:PSDomain format:@"Abstract instance method %@. Please override.", NSStringFromSelector(_cmd)]; return; _Pragma("clang diagnostic pop") }
#define PS_NOT_IMPLEMENTED { _Pragma("clang diagnostic push") _Pragma("clang diagnostic ignored \"-Wreturn-type\"") printf("####\n[%s] - %s - Not Implemented \n####\n", [[[NSString stringWithUTF8String:__FILE__] lastPathComponent] UTF8String], [NSStringFromSelector(_cmd) UTF8String]); return; _Pragma("clang diagnostic pop") }
#define PS_FORMAT(F,A) __attribute__((format(__NSString__, F, A)))
	
/* Constants and globals */

extern NSString * const PSException;
extern NSString * const PSDomain;
extern dispatch_queue_t PSDispatchGlobalQueue;

typedef double PSTimeStamp;

/* Functions */
	
// GCD Async method in background thread on shared queue
extern void PSDispatchInBackgroundThread(dispatch_block_t block);
// GCD Sync method in main thread
extern void PSDispatchInMainThread(dispatch_block_t block);
// GCD Async method in main thread invoked after specified interval
extern void PSDispatchAfter(NSTimeInterval interval, dispatch_block_t block);

// Timing
extern PSTimeStamp PSTimeStampMake(void); // Get current time
extern NSTimeInterval PSTimeInterval(PSTimeStamp timestamp); // Get interval from timestamp to current time 

// Obj-C Runtime
extern NSDictionary * PSRuntimeIvarsForClass(Class classObject);
extern void * PSRuntimeAddressOfInstanceVariable(id object, char * variableName);

// Instance counting
extern NSInteger PSInstanceCount(Class classObject);
extern void PSInstanceCreated(Class classObject);
extern void PSInstanceDeallocated(Class classObject);
extern void PSInstanceLog(void);

// Logging
extern void PSLog(NSString *format, ...) PS_FORMAT(1,2);
extern void PSLogStore(NSString *key, NSString *format, ...) PS_FORMAT(2,3);

// Advanced Logging
extern NSString * const PSDebugLogNotification;
extern NSArray * PSDebugLogDump(void);
extern void PSDebugLogSave(void);
extern void PSDebugLogClear(void);

// Crash handling
extern void PSDebugInstallCrashHandler(void);
	
/* Macros */

// Alternative to NSLog
#define PSLogm(format, ...) printf("- {%s:[%d] - %s} %s\n", \
	[[[NSString stringWithUTF8String:__FILE__] lastPathComponent] UTF8String], \
	__LINE__, \
	[NSStringFromSelector(_cmd) UTF8String], \
	[[NSString stringWithFormat:(format), ##__VA_ARGS__] UTF8String])

#define PSLogf(format, ...) printf("- {%s:[%d]} %s\n", \
	__FUNCTION__, \
	__LINE__, \
	[[NSString stringWithFormat:(format), ##__VA_ARGS__] UTF8String])

// Production undefs
//#define PSLog(format, ...) ;
//#define PSLogf(format, ...) ;
	
#ifdef __cplusplus
}
#endif
