//
//  NSMenu+Additions.m
//  Perforce
//
//  Created by Adam Czubernat on 30/10/2013.
//  Copyright (c) 2013 Perforce Software, Inc. All rights reserved.
//

#import "NSMenu+Additions.h"
#import "P4Item.h"
#import "BrowserViewController.h"

@implementation NSMenu (Additions)

- (void)setItem:(P4Item *)item delegate:(id)delegate {
	[self removeAllItems];
	if (!item)
		return;
	
	[self setAutoenablesItems:NO];
	
	[self addItemWithTitle:item.name action:nil keyEquivalent:@""];
	[[self itemAtIndex:0] setEnabled:NO];
	
	[self addItem:[NSMenuItem separatorItem]];
	
	for (P4ItemAction *action in item.actions) {
		
		SEL selector = action.selector;
		if ([self itemAtIndex:[self numberOfItems]-1] !=
			[NSMenuItem separatorItem]) {
			if (selector == @selector(markAsRead) ||
				selector == @selector(markAllAsRead) ||
				selector == @selector(showInFinder) ||
				selector == @selector(revertIfUnchanged) ||
				selector == @selector(deleteItem) ||
				selector == @selector(createDirectory) ||
				selector == @selector(unmapFromWorkspace) ||
				selector == @selector(unshelve))
				[self addItem:[NSMenuItem separatorItem]];
		}
		
		action.delegate = delegate;
		NSMenuItem *menuItem = [[NSMenuItem alloc] init];
		[menuItem setTitle:action.name];
		[menuItem setTarget:action];
		[menuItem setRepresentedObject:action]; // Strong
		[menuItem setAction:@selector(performAction)];
		[menuItem setEnabled:!action.disabled];
		[self addItem:menuItem];

//		// Back separators
//		if (selector == @selector(...))
//			[self addItem:[NSMenuItem separatorItem]];
	}
}

- (void)setItems:(NSArray *)items delegate:(id)controller {
	[self removeAllItems];
	if (!items.count)
		return;
	
	[self setAutoenablesItems:NO];
	
	[self addItemWithTitle:@"Multiple Files" action:nil keyEquivalent:@""];
	[[self itemAtIndex:0] setEnabled:NO];
	
	[self addItem:[NSMenuItem separatorItem]];

	for (P4ItemAction *action in [[items lastObject] actionsForItems:items]) {
		action.delegate = controller;
		NSMenuItem *menuItem = [[NSMenuItem alloc] init];
		[menuItem setTitle:action.name];
		[menuItem setTarget:action];
		[menuItem setRepresentedObject:action]; // Strong
		[menuItem setAction:@selector(performAction)];
		[menuItem setEnabled:YES];
		[self addItem:menuItem];
	}
}


@end
