//
//  NSString+Additions.h
//  Perforce
//
//  Created by Adam Czubernat on 16.05.2013.
//  Copyright (c) 2013 Perforce Software, Inc. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface NSString (Additions)

- (NSString *)stringByRemovingPrefix:(NSString *)prefix;
- (NSString *)stringByRemovingSuffix:(NSString *)suffix;

- (NSArray *)arrayOfArguments;
- (CGSize)sizeWithFont:(NSFont *)font;

- (NSString *)stringByDeletingPath; // Removes last component without altering whole path
- (NSString *)stringByAppendingPath:(NSString *)path; // Append path components without altering whole path
- (NSString *)directoryPath; // Append trailing slash if needed
- (BOOL)hasParentDirectory:(NSString *)parentPath;

- (BOOL)isEmptyString;

@end
