//
//  NSView+Additions.m
//  Perforce
//
//  Created by Adam Czubernat on 28.05.2013.
//  Copyright (c) 2013 Perforce Software, Inc. All rights reserved.
//

#import "NSView+Additions.h"


@implementation NSView (Additions)

+ (void)animateWithDuration:(NSTimeInterval)duration animations:(void (^)(void))animations {
	[self animateWithDuration:duration animations:animations completion:nil];
}

+ (void)animateWithDuration:(NSTimeInterval)duration animations:(void (^)(void))animations completion:(void (^)(void))completion {
	[NSAnimationContext runAnimationGroup:^(NSAnimationContext *context) {
		context.duration = duration;
		animations();
	} completionHandler:completion];
}

- (void)setAutoresizing:(NSViewAutoresizing)mask {
	
	mask ^= NSViewAutoresizingLeftEdge | NSViewAutoresizingRightEdge;

	if (!(mask & (NSViewMinYMargin | NSViewMaxYMargin)))
		mask |= (NSViewMinYMargin | NSViewMaxYMargin);
	if (!(mask & (NSViewMinXMargin | NSViewMaxXMargin)))
		mask |= (NSViewMinXMargin | NSViewMaxXMargin);
	
	self.autoresizingMask = mask;
}

- (void)printSubviews {	
	[self printSubviewsLevel:NSIntegerMax];
}

- (void)printSubviewsLevel:(NSInteger)maxLevel {
	__block void (^__weak block)(NSView *, NSString *, NSInteger);
	void (^weak)(NSView *, NSString *, NSInteger);
	block = weak = ^(NSView *view, NSString *indent, NSInteger level) {
		
		NSString *string = [NSString stringWithFormat:@"%@(%@) %@%@",
							indent,
							NSStringFromClass([view class]),
							NSStringFromRect([view frame]),
							view.isHidden ? @" #hidden#" : @""];
		
		NSString *title = nil;
		if ([view isKindOfClass:[NSTextField class]])
			title = [(NSTextField *)view stringValue];
		else if ([view isKindOfClass:[NSButton class]])
			title = [(NSButton *)view title];
		if (title)
			string = [string stringByAppendingFormat:@" = \"%@\"", title];

		printf("%s\n", string.UTF8String);
		
		if (level < maxLevel)
			for (NSView *subview in view.subviews)
				block(subview, [indent stringByAppendingString:@" |\t"], level+1);
		else if (view.subviews.count)
			printf("%s", [[NSString stringWithFormat:@"%@ |\t...\n", indent] UTF8String]);
	};
	
	block(self, @"", 0);
}

@end
