//
//  IconViewItem.h
//  Perforce
//
//  Created by Adam Czubernat on 07.06.2013.
//  Copyright (c) 2013 Perforce Software, Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@protocol IconViewItemDelegate <NSObject>
- (void)iconViewItemSelected:(id)iconViewItem;
- (void)iconViewItemOpened:(id)iconViewItem;
- (void)iconViewItemDidEndEditing:(id)iconViewItem;
@end

@interface IconViewItem : NSCollectionViewItem

@property (nonatomic, unsafe_unretained) IBOutlet id <IconViewItemDelegate> delegate;
@property (nonatomic, readonly) PSView *iconView;
@property (nonatomic, readonly) NSString *title;

- (void)beginEditing;
- (void)abortEditing;

@end
