//
//  PSCoverFlow.h
//  CoverFlow
//
//  Created by Adam Czubernat on 23.12.2013.
//  Copyright (c) 2013 Perforce Software, Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@protocol PSCoverFlowDelegate <NSObject>
- (NSInteger)numberOfImagesInCoverFlow:(id)coverFlow;
- (NSImage *)coverFlow:(id)coverFlow imageForIndex:(NSInteger)index;
- (void)coverFlow:(id)coverFlow didSelectIndex:(NSInteger)index;
@end

@interface PSCoverFlow : NSView

@property (nonatomic, unsafe_unretained) IBOutlet id <PSCoverFlowDelegate> delegate;

- (void)reload;
- (void)reloadImagesInRange:(NSRange)range;

- (NSInteger)selectedIndex;
- (void)setSelectedIndex:(NSInteger)index;

@end
