//
//  PSGradientView.m
//  Perforce
//
//  Created by Adam Czubernat on 27.12.2013.
//  Copyright (c) 2013 Perforce Software, Inc. All rights reserved.
//

#import "PSGradientView.h"

@interface PSGradientView () {
	CAGradientLayer *gradient;
}
- (void)setColors;
@end

@implementation PSGradientView;
@synthesize horizontal, startColor, endColor, startPoint, endPoint;

- (id)initWithFrame:(NSRect)frame {
    self = [super initWithFrame:frame];
    if (self) {
       	gradient = [CAGradientLayer layer];
		self.layer = gradient;
		self.wantsLayer = YES;
    }
    return self;
}

- (void)setColors {
	CGColorRef startRef = CGColorCreateFromColor(startColor);
	CGColorRef endRef = CGColorCreateFromColor(endColor);
	if (startRef && endRef)
		gradient.colors = @[ (__bridge id)startRef, (__bridge id)endRef ];
	CGColorRelease(startRef);
	CGColorRelease(endRef);
}

- (void)setHorizontal:(BOOL)set {
	horizontal = set;
	gradient.startPoint = horizontal ? (CGPoint) { 0.0f, 0.5f } : (CGPoint) { 0.5f, 0.0f };
	gradient.endPoint = horizontal ? (CGPoint) { 1.0f, 0.5f } : (CGPoint) { 0.5f, 1.0f };
}

- (void)setStartColor:(NSColor *)color {
	startColor = color;
	[self setColors];
}

- (void)setEndColor:(NSColor *)color {
	endColor = color;
	[self setColors];
}

- (void)setStartPoint:(CGPoint)point {
	startPoint = point;
	gradient.startPoint = startPoint;
}

- (void)setEndPoint:(CGPoint)point {
	endPoint = point;
	gradient.endPoint = endPoint;
}

@end
