//
//  PSScrollView.m
//  Perforce
//
//  Created by Adam Czubernat on 24.06.2013.
//  Copyright (c) 2013 Perforce Software, Inc. All rights reserved.
//

#import "PSScrollView.h"
#import "PSClipView.h"

@implementation PSScrollView {
	PSClipView *clipView;
}
@synthesize reverseScrolling;

- (void)setFrame:(NSRect)frameRect {
	
	if (reverseScrolling) {
		[super setFrame:frameRect];
		return;
	}
	
	// Swap clip view
	if (!clipView) {
		NSClipView *superClipView = [super contentView];
		NSView *documentView = superClipView.documentView;
		clipView = [[PSClipView alloc] initWithFrame:superClipView.frame];
		clipView.documentView = documentView;
		clipView.copiesOnScroll = superClipView.copiesOnScroll;
		clipView.drawsBackground = superClipView.drawsBackground;
		clipView.backgroundColor = superClipView.backgroundColor;
		
		[self setContentView:clipView];
		superClipView = [super contentView];
		[superClipView setBoundsOrigin:(CGPoint) {
			0.0f, superClipView.frame.size.height - documentView.frame.size.height
		}];
	}
	
	CGRect bounds = [clipView bounds];
	CGFloat delta = frameRect.size.height - self.frame.size.height;
	[super setFrame:frameRect];
	
	[clipView setBoundsOrigin:(CGPoint) { 0.0f, bounds.origin.y + delta}];
	[self reflectScrolledClipView:clipView];
}

- (void)scrollWheel:(NSEvent *)theEvent {
	
	if (theEvent.deltaX && !theEvent.deltaY)
		[[self nextResponder] scrollWheel:theEvent];
	[super scrollWheel:theEvent];
}

@end
