//
//  PanelController.h
//  Perforce
//
//  Created by Adam Czubernat on 11.07.2013.
//  Copyright (c) 2013 Perforce Software, Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@interface PanelController : NSWindowController {
	NSView *presentedView;
}

@property (nonatomic, readonly) NSWindow *parentWindow;

- (void)presentWithWindow:(NSWindow *)window;
- (void)dismiss;

- (void)setPresentedView:(NSView *)view;
- (void)setPresentedView:(NSView *)view animated:(BOOL)animated;

- (void)dismissAfter:(NSTimeInterval)delay;

- (void)presentExclusiveWithWindow:(NSWindow *)window;

@end
