//
//  SyncPanelController.m
//  Perforce
//
//  Created by Adam Czubernat on 15.07.2013.
//  Copyright (c) 2013 Perforce Software, Inc. All rights reserved.
//

#import "SyncPanelController.h"
#import "P4Workspace.h"

@interface SyncPanelController () {
	
	__weak IBOutlet NSView *loadingView;
	__weak IBOutlet NSView *successView;
	
	__weak IBOutlet NSProgressIndicator *indicator;
	__weak IBOutlet NSTextField *progressLabel;

	__weak IBOutlet NSTextField *successLabel;
}
- (void)synchronize;
- (void)syncStartedNotification:(NSNotification *)notification;
- (void)syncFinishedNotification:(NSNotification *)notification;

- (IBAction)cancelButtonPressed:(id)sender;
- (IBAction)hideButtonPressed:(id)sender;
@end

@implementation SyncPanelController

- (void)windowDidLoad {
    [super windowDidLoad];
	
	[[NSNotificationCenter defaultCenter]
	 addObserver:self
	 selector:@selector(syncStartedNotification:)
	 name:P4SyncStartedNotification
	 object:nil];
	
	[[NSNotificationCenter defaultCenter]
	 addObserver:self
	 selector:@selector(syncFinishedNotification:)
	 name:P4SyncFinishedNotification
	 object:nil];
	
	if ([[P4Workspace sharedInstance] isSynchronizing])
		progressLabel.stringValue = ([P4Workspace sharedInstance].syncDescription ?:
									 @"Synchronizing files...");
	else
		[self synchronize];

	[self setPresentedView:loadingView];	
	[indicator startAnimation:nil];
}

- (void)dealloc {
	[[NSNotificationCenter defaultCenter] removeObserver:self];
}

#pragma mark - Private

- (void)synchronize {
	progressLabel.stringValue = @"Synchronizing files...";
	PSLog(@"Manual sync");
	[[P4Workspace sharedInstance]
	 syncWorkspace:nil
	 response:nil];
}

- (void)syncStartedNotification:(NSNotification *)notification {
	
}

- (void)syncFinishedNotification:(NSNotification *)notification {
	
	[indicator stopAnimation:nil];
	P4Operation *operation = notification.object;
	
	NSArray *upToDate = [operation errorsWithCode:P4ErrorFileUpToDate];
	[operation ignoreErrors:upToDate];
	
	if (operation.errors) {
		
		if (![operation errorsWithCode:P4ErrorSessionExpired])
			[[NSAlert alertWithError:operation.error]
			 beginSheetModalForWindow:self.window.parentWindow
			 modalDelegate:nil
			 didEndSelector:nil
			 contextInfo:NULL];
		
		[self dismiss];
		
	} else {
		
		if (upToDate)
			successLabel.stringValue = @"Files are up-to-date";
		
		[self setPresentedView:successView animated:YES];
		
		PSLog(@"SyncPanel finished %@", operation.response ?: @"");
		
		[self dismissAfter:2.0f];
	}
}


#pragma mark - Actions

- (IBAction)cancelButtonPressed:(id)sender PS_NOT_IMPLEMENTED

- (IBAction)hideButtonPressed:(id)sender {
	[self dismiss];
}

@end
