//
//  P4Connection.h
//  Perforce
//
//  Created by Adam Czubernat on 04/10/2013.
//  Copyright (c) 2013 Perforce Software, Inc. All rights reserved.
//

#import <Foundation/Foundation.h>

@class P4Operation, P4Connection;

typedef enum {
	P4ErrorPathNotUnderRoot		= 4135,
	P4ErrorMustReferToClient	= 6244,
	P4ErrorChangeDeleted		= 6349,
	P4ErrorAlreadyOpened		= 6431,
	P4ErrorAddExistingFile		= 6438,	// sev 1 sys 6 sub 294
	P4ErrorMoveToExistingFile	= 6633,
	P4ErrorEditMovedFile		= 6637,
	P4ErrorOpenedLaterRevision	= 6493,
	P4ErrorMustResolve			= 6495,
	P4ErrorMustSyncResolve		= 6441,
	P4ErrorMustSubmitResolve	= 6765,
	P4ErrorOpenedBy				= 6443, // sev 1 sys 6 sub 299
	P4ErrorAddExisting			= 6444,
	P4ErrorSyncFileOpened		= 6491,
	P4ErrorFileNotInView		= 6511,
	P4ErrorNoSuchFile			= 6519,
	P4ErrorFileNotOnClient		= 6520,
	P4ErrorFileNotOpened		= 6526,
	P4ErrorFileUpToDate			= 6532,
	P4ErrorShelveExclusive		= 6574,
	P4ErrorDestinationNotInView	= 6621,
	P4ErrorReconcile			= 6827,
	P4ErrorInvalidPassword		= 7189,
	P4ErrorNoFilesToSubmit		= 7214,
	P4ErrorSessionExpired		= 7480,
} P4Error;

extern NSString * const P4SessionExpiredNotification;

typedef void (^P4ReceiveBlock_t)(P4Operation *operation);
typedef void (^P4ResponseBlock_t)(P4Operation *operation, NSArray *response);


@interface P4Operation : NSOperation
@property (nonatomic, readonly) NSArray *response;
@property (nonatomic, readonly) NSArray *errors;

@property (nonatomic, readonly) CGFloat progress;
@property (nonatomic, readonly) NSString *progressDescription;
@property (nonatomic, readonly) long completed;
@property (nonatomic, readonly) long total;
@property (nonatomic, readonly) NSString *units;

- (NSError *)error; // Combines all errors into single error
- (NSArray *)errorsWithCode:(P4Error)errorCode;
- (void)ignoreErrors:(NSArray *)errors;
- (void)ignoreErrorsWithCode:(P4Error)errorCode;
@end

@interface P4ConnectOperation : P4Operation
@property (nonatomic, retain) NSString *host;
@property (nonatomic, retain) NSString *username;
@end

@interface P4CommandOperation : P4Operation
@property (nonatomic, retain) NSString *command;
@property (nonatomic, retain) NSArray *arguments;
@property (nonatomic, retain) NSString *prompt;
@property (nonatomic, retain) NSDictionary *input;
@end

@interface P4ThreadOperation : P4Operation
@property (nonatomic, copy) void (^block)(P4ThreadOperation *operation);
- (void)addError:(NSError *)error;
@end


@interface P4Connection : NSObject

- (id)initWithName:(NSString *)name;
- (id)initWithConnection:(P4Connection *)connection name:(NSString *)name; // Clone connection

- (void)connectWithHost:(NSString *)host username:(NSString *)username response:(P4ResponseBlock_t)responseBlock;
- (BOOL)isConnected;
- (void)disconnect;

- (void)setWorkspace:(NSString *)workspace root:(NSString *)path;
- (NSString *)ticket;
- (void)setTicket:(NSString *)ticket;


- (P4Operation *)run:(NSString *)command response:(P4ResponseBlock_t)responseBlock;
- (P4Operation *)run:(NSString *)command arguments:(NSArray *)args response:(P4ResponseBlock_t)responseBlock;
- (P4Operation *)run:(NSString *)command arguments:(NSArray *)args prompt:(NSString *)prompt input:(NSDictionary *)input receive:(P4ReceiveBlock_t)receiveBlock response:(P4ResponseBlock_t)responseBlock;
- (void)runOperation:(NSOperation *)operation;
- (void)runBlock:(void (^)(P4ThreadOperation *operation))block;

- (NSString *)name;

- (NSArray *)operations;
- (void)cancelAllOperations;
- (void)setNextOperation:(NSOperation *)operation;
- (void)waitUntilAllOperationsAreFinished;

- (void)setSuspended:(BOOL)flag;
- (BOOL)isSuspended;

@end
