//
//  P4NetworkOperation.h
//  Perforce
//
//  Created by Adam Czubernat on 08/01/2014.
//  Copyright (c) 2014 Perforce Software, Inc. All rights reserved.
//

#import "P4Connection.h"

@class P4NetworkOperation;
typedef void (^P4NetworkBlock_t)(P4NetworkOperation *operation);

@interface P4NetworkOperation : NSOperation {
	NSURLConnection *connection;
	NSURLRequest *request;
	NSData *data;
	NSHTTPURLResponse *HTTPResponse;
	CGFloat progress;
	long completed;
	long length;
}

+ (P4NetworkOperation *)operation;
+ (P4NetworkOperation *)operationWithRequest:(NSURLRequest *)urlRequest receive:(P4NetworkBlock_t)block completion:(P4NetworkBlock_t)block;
+ (P4NetworkOperation *)operationWithUrl:(NSString *)url HTTPMethod:(NSString *)method HTTPHeaders:(NSDictionary *)headers HTTPBody:(NSData *)body receive:(P4NetworkBlock_t)block completion:(P4NetworkBlock_t)block;

@property (nonatomic, assign) BOOL success;
@property (nonatomic, retain) NSError *error;

- (NSData *)data;

- (NSString *)MIMEType;
- (NSDictionary *)HTTPHeaders;
- (NSInteger)HTTPStatus;
- (NSDate *)HTTPDate; // RFC 1123 Date received
- (NSURLResponse *)HTTPResponse;

- (CGFloat)progress;
- (long)completed; // Received content length
- (long)length; // Expected content length

- (NSURLRequest *)request;
- (void)setRequest:(NSURLRequest *)request receive:(P4NetworkBlock_t)block completion:(P4NetworkBlock_t)block;

//- (NSString *)responseString;
//- (void)setOutputFile:(NSString *)path;
@end
