//
//  NSColor+Additions.m
//  Perforce
//
//  Created by Adam Czubernat on 07.06.2013.
//  Copyright (c) 2013 Perforce Software, Inc. All rights reserved.
//

#import "NSColor+Additions.h"

CGColorRef CGColorCreateFromColor(NSColor *color) {
	NSInteger numberOfComponents = [color numberOfComponents];
    CGFloat components[numberOfComponents];
    CGColorSpaceRef colorSpace = [[color colorSpace] CGColorSpace];
    [color getComponents:(CGFloat *)&components];
    return CGColorCreate(colorSpace, components);
}

@implementation NSColor (Additions)

+ (NSColor *)colorWithHexString:(NSString *)hexString {
	
	if (!hexString.length)
		return nil;
	
	unsigned int hexInt;
	unsigned int r, g, b = -1; // -1 for error indicating
	
	NSString *regex = @"^[A-Fa-f0-9]{6}$|^[A-Fa-f0-9]{3}$|^([A-Fa-f0-9])\\1{4}$";
	
	// Remove white chars from both ends
	hexString = [hexString stringByTrimmingCharactersInSet:
				 [NSCharacterSet whitespaceAndNewlineCharacterSet]];
	if (hexString.length > 0 && [hexString characterAtIndex:0] == '#')
		hexString = [hexString substringFromIndex:1];
	
	NSScanner *scanner = [NSScanner scannerWithString:hexString];
	
	if ([scanner scanHexInt:&hexInt] &&
		[hexString rangeOfString:regex options:NSRegularExpressionSearch].location != NSNotFound ) {
		
		switch (hexString.length) {
			case 6: // #RRGGBB
				r = (hexInt >> 16) & 0xFF;
				g = (hexInt >> 8) & 0xFF;
				b = hexInt & 0xFF;
				break;
			case 3: // #RGB
				r = ((hexInt >> 8) & 0xF) * 0x11;
				g = ((hexInt >> 4) & 0xF) * 0x11;
				b = (hexInt & 0xF) * 0x11;
				break;
			case 5: // #CCCCC
				r = g = b = (hexInt & 0xF) * 0x11;
				break;
		}
	}
	
	if (b == -1)
		[NSException raise:@"Invalid HEX color format" format:@"Color value %@ "
		 "is invalid. Supported values (#)RGB (#)RRGGBB (#)CCCCC", hexString];
	else
		return [NSColor colorWithDeviceRed:r/255.0f green:g/255.0f blue:b/255.0f alpha:1.0f];
	
	return nil;
}

@end
