//
//  NSError+Additions.m
//  Perforce
//
//  Created by Adam Czubernat on 14.05.2013.
//  Copyright (c) 2013 Perforce Software, Inc. All rights reserved.
//

#import "NSError+Additions.h"

@implementation NSError (Additions)

+ (NSError *)errorWithFormat:(NSString *)format, ... {
	va_list args;
	va_start(args, format);
	NSString *string = [[NSString alloc] initWithFormat:format arguments:args];
	va_end(args);
	return [NSError errorWithDomain:PSDomain code:0 userInfo:@{
		 NSLocalizedDescriptionKey : string ? : [NSNull null] }];
}

- (NSError *)errorByAppendingError:(NSError *)error {
	NSString *description = [self.userInfo objectForKey:NSLocalizedDescriptionKey];
	NSArray *errors = [self.userInfo objectForKey:NSDetailedErrorsKey] ? : @[ self ];
	errors = [errors arrayByAddingObject:error];
	
	description = [description stringByAppendingFormat:
				   @"\n%@", error.localizedDescription];
	
	return [NSError errorWithDomain:PSDomain code:0 userInfo:@{
				NSLocalizedDescriptionKey : description,
				NSDetailedErrorsKey : errors,
			}];
}

@end
