//
//  NSString+Additions.m
//  Perforce
//
//  Created by Adam Czubernat on 16.05.2013.
//  Copyright (c) 2013 Perforce Software, Inc. All rights reserved.
//

#import "NSString+Additions.h"

@implementation NSString (Additions)

- (NSString *)stringByRemovingPrefix:(NSString *)prefix {
	return ([self hasPrefix:prefix] ?
			[self substringFromIndex:prefix.length] :
			self);
}

- (NSString *)stringByRemovingSuffix:(NSString *)suffix {
	return ([self hasSuffix:suffix] ?
			[self substringToIndex:self.length - suffix.length] :
			self);
}

- (NSArray *)arrayOfArguments {

	CFStringRef string = (__bridge CFStringRef)self;
	CFIndex length = CFStringGetLength(string);
	
	NSMutableArray *array = [NSMutableArray arrayWithCapacity:length];

	unichar quoteChar;
	CFIndex bufferLength = 0;
	unichar *buffer = malloc(sizeof(unichar) * length);
	BOOL inQuote = NO;

	for (CFIndex i=0; i<length; i++) {
		unichar c = CFStringGetCharacterAtIndex(string, i);
		if (!inQuote && (c==0x0020 || c==0x0009 || c==0x000A || c==0x000D || c==0x0085)) {
			if (bufferLength) {
				CFStringRef argument = CFStringCreateWithCharacters(NULL, buffer, bufferLength);
				[array addObject:CFBridgingRelease(argument)];
				bufferLength = 0;
			}
			continue;
		}
		
		if ((c=='\'' || c=='"') && (!inQuote || c==quoteChar)) {
			inQuote = !inQuote;
			quoteChar = c;
			continue;
		}
		
		buffer[bufferLength++] = c;
	}
	
	if (bufferLength) {
		CFStringRef argument = CFStringCreateWithCharacters(NULL, buffer, bufferLength);
		[array addObject:CFBridgingRelease(argument)];
	}
	
	free(buffer);	
	
	return array;
}

- (CGSize)sizeWithFont:(NSFont *)font {
	return [self sizeWithAttributes:@{ NSFontAttributeName : font }];
}

- (NSString *)stringByDeletingPath {
	NSRange range = { 0, self.length-1 };
	range = [self rangeOfString:@"/" options:NSBackwardsSearch range:range];
	NSUInteger loc = range.location;
	if (loc != NSNotFound)
		return [self substringToIndex:loc+1];
	return self;
}

- (NSString *)stringByAppendingPath:(NSString *)path {
	return ([self hasSuffix:@"/"] ?
			[self stringByAppendingString:path] :
			[self stringByAppendingFormat:@"/%@", path]);
}

- (NSString *)directoryPath {
	return [self hasSuffix:@"/"] ? self : [self stringByAppendingString:@"/"];
}

- (BOOL)hasParentDirectory:(NSString *)parentPath {
	
	NSString *prefix = [NSString stringWithFormat:@"%@/",
						parentPath.stringByStandardizingPath];
	return [self.stringByStandardizingPath hasPrefix:prefix];
}

- (BOOL)isEmptyString {
	NSCharacterSet *set = [NSCharacterSet whitespaceAndNewlineCharacterSet];
	return [self stringByTrimmingCharactersInSet:set].length == 0;
}

@end
