//
//  NSTableView+Additions.m
//  Perforce
//
//  Created by Adam Czubernat on 19/12/2013.
//  Copyright (c) 2013 Perforce Software, Inc. All rights reserved.
//

#import "NSTableView+Additions.h"

NSIndexSet * NSIndexSetMake(NSInteger firstIndex, NSInteger lastIndex);

@implementation NSTableView (Additions)

- (void)reloadDataForRowsInRange:(NSRange)range {
	[self reloadDataForRowIndexes:[NSIndexSet indexSetWithIndexesInRange:range]
					columnIndexes:NSIndexSetMake(0, [self numberOfColumns]-1)];
}

- (void)reloadDataForRowsFromIndex:(NSInteger)firstIndex toIndex:(NSInteger)lastIndex {
	[self reloadDataForRowIndexes:NSIndexSetMake(firstIndex, lastIndex)
					columnIndexes:NSIndexSetMake(0, [self numberOfColumns]-1)];
}

- (void)insertRowsInRange:(NSRange)range withAnimation:(NSTableViewAnimationOptions)animationOptions {
	[self insertRowsAtIndexes:[NSIndexSet indexSetWithIndexesInRange:range]
				withAnimation:animationOptions];
}

- (void)insertRowsFromIndex:(NSInteger)firstIndex toIndex:(NSInteger)lastIndex withAnimation:(NSTableViewAnimationOptions)animationOptions {
	[self insertRowsAtIndexes:NSIndexSetMake(firstIndex, lastIndex)
				withAnimation:animationOptions];
}

- (void)removeRowsInRange:(NSRange)range withAnimation:(NSTableViewAnimationOptions)animationOptions {
	[self removeRowsAtIndexes:[NSIndexSet indexSetWithIndexesInRange:range]
				withAnimation:animationOptions];
}

- (void)removeRowsFromIndex:(NSInteger)firstIndex toIndex:(NSInteger)lastIndex withAnimation:(NSTableViewAnimationOptions)animationOptions {
	[self removeRowsAtIndexes:NSIndexSetMake(firstIndex, lastIndex)
				withAnimation:animationOptions];
}

- (void)updateRowsHeightInRange:(NSRange)range {
	[self noteHeightOfRowsWithIndexesChanged:[NSIndexSet indexSetWithIndexesInRange:range]];
}

- (void)updateRowsHeightFromIndex:(NSInteger)firstIndex toIndex:(NSInteger)lastIndex {
	[self noteHeightOfRowsWithIndexesChanged:NSIndexSetMake(firstIndex, lastIndex)];
}

@end


NSIndexSet * NSIndexSetMake(NSInteger firstIndex, NSInteger lastIndex) {
	if (firstIndex < lastIndex)
		return [NSIndexSet indexSetWithIndexesInRange:(NSRange) {
			firstIndex, lastIndex-firstIndex+1
		}];
	return [NSIndexSet indexSetWithIndex:firstIndex];
}