//
//  NSView+Additions.h
//  Perforce
//
//  Created by Adam Czubernat on 28.05.2013.
//  Copyright (c) 2013 Perforce Software, Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>

typedef enum {
	NSViewAutoresizingLeftEdge		= 1 << 0,
	NSViewAutoresizingWidth			= 1 << 1,
	NSViewAutoresizingRightEdge		= 1 << 2,
	NSViewAutoresizingTopEdge		= 1 << 3,
	NSViewAutoresizingHeight		= 1 << 4,
	NSViewAutoresizingBottomEdge	= 1 << 5,
	NSViewAutoresizingHorizontal	= 7,
	NSViewAutoresizingVertical		= 56,
} NSViewAutoresizing;

@interface NSView (Additions)

+ (void)animateWithDuration:(NSTimeInterval)duration animations:(void (^)(void))animations;
+ (void)animateWithDuration:(NSTimeInterval)duration animations:(void (^)(void))animations completion:(void (^)(void))completion;

- (void)setAutoresizing:(NSViewAutoresizing)mask;

- (void)printSubviews;
- (void)printSubviewsLevel:(NSInteger)level;

@end
