//
//  BrowserViewController.h
//  Perforce
//
//  Created by Adam Czubernat on 07.06.2013.
//  Copyright (c) 2013 Perforce Software, Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "P4Item.h"

@protocol BrowserViewDelegate <NSObject>
- (void)browserView:(id)browser didChangeWorkingItem:(P4Item *)item;
- (void)browserView:(id)browser didChangeSelectedItem:(P4Item *)item;
- (void)browserView:(id)browser didChangeSearchQuery:(NSString *)query;
@end

@interface BrowserViewController : NSViewController <P4ItemDelegate> {
	P4Item *rootItem;
	__unsafe_unretained P4Item *workingItem;
	BOOL isLoading;
	BOOL isReloading;
	NSArray *filteredTags;
}

@property (nonatomic, unsafe_unretained) id <BrowserViewDelegate> delegate;
@property (nonatomic, readonly) NSView *searchBar;

- (P4Item *)rootItem;
- (P4Item *)workingItem;
- (NSArray *)selectedItems;						// Override

- (void)setRootItem:(P4Item *)rootItem;			// Override
- (void)setWorkingItem:(P4Item *)workingItem;	// Override
- (void)setSelectedItems:(NSArray *)selectedItems;
- (void)setSelectedIndexes:(NSIndexSet *)indexes; // Override

- (void)loadPath:(NSString *)path;
- (void)search:(NSString *)query;
- (void)reload;
- (void)refresh; // Override

- (void)willLoadPath:(NSString *)path;	// Override
- (void)showVersions:(P4Item *)item;	// Override
- (void)editItemName:(P4Item *)item;	// Override

// Protected
- (void)selectionChanged:(P4Item *)selectedItem;
- (void)renameItem:(P4Item *)item name:(NSString *)newName;
- (BOOL)insertFiles:(NSArray *)paths intoItem:(P4Item *)item copy:(BOOL)copy;
- (BOOL)hasFilteredTagsForItem:(P4Item *)item;
- (void)failWithError:(NSError *)error;

// P4Item Delegate
- (void)itemDidLoad:(id)item;
- (void)itemDidInvalidate:(id)item;
- (void)item:(id)item didFailWithError:(NSError *)error;

@end
