//
//  SidebarViewController.h
//  Perforce
//
//  Created by Adam Czubernat on 16/12/2013.
//  Copyright (c) 2013 Perforce Software, Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "TagsView.h"

extern NSString * const P4PasteboardTypeTag;

extern NSString * const P4PasteboardTypeFavoriteFolder;
extern NSString * const P4PasteboardTypeFavoriteTag;

@protocol SidebarViewControllerDelegate  <NSObject>
- (void)sidebarDidSelectPath:(NSString *)path;
@end

@interface SidebarViewController : NSViewController
@property (nonatomic, unsafe_unretained) id <SidebarViewControllerDelegate> delegate;

- (void)reload;
- (void)setWorkingPath:(NSString *)path;

@end
