//
//  TagsView.h
//  Perforce
//
//  Created by Adam Czubernat on 28/11/2013.
//  Copyright (c) 2013 Perforce Software, Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "P4Item.h"

extern NSString * const P4PasteboardTypeTag;

@interface TagsView : NSView

- (void)setItem:(P4Item *)item;
- (void)setTags:(NSArray *)tags;

- (void)setAllowsAdding:(BOOL)allow;
- (void)setAllowsRemoving:(BOOL)allow;

- (NSSize)spacing;
- (void)setSpacing:(NSSize)spacing;

- (NSEdgeInsets)contentInsets;
- (void)setContentInsets:(NSEdgeInsets)insets;

@end
