//
//  PSTableRowView.m
//  Perforce
//
//  Created by Adam Czubernat on 16/12/2013.
//  Copyright (c) 2013 Perforce Software, Inc. All rights reserved.
//

#import "PSTableRowView.h"

@implementation PSTableRowView
@synthesize selectionColor;

- (void)setSelected:(BOOL)selected {
	[super setSelected:selected];
	[super setEmphasized:selected];
}

- (void)setEmphasized:(BOOL)emphasized {
	// Empty
}

- (void)drawSelectionInRect:(NSRect)dirtyRect {
	if (!selectionColor)
		return;
	
	NSInteger cornerSize = self.bounds.size.height / 4.0f;
	NSBezierPath *bezier = [NSBezierPath bezierPathWithRoundedRect:self.bounds
														   xRadius:cornerSize
														   yRadius:cornerSize];
	[selectionColor setFill];
	[bezier fill];
}

@end
