//
//  PSView.h
//  Perforce
//
//  Created by Adam Czubernat on 06.06.2013.
//  Copyright (c) 2013 Perforce Software, Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>

typedef enum {
	PSViewEventClick		= 1 <<  0,
	PSViewEventDoubleClick	= 1 <<  1,
} PSViewEvent;

typedef enum {
	PSViewContentModeAspectFit,
	PSViewContentModeAspectFill,
	PSViewContentModeCenter,
	PSViewContentModeFill,
	PSViewContentModeFillHorizontal,
	PSViewContentModeFillVertical,
} PSViewContentMode;

@interface PSView : NSView

@property (nonatomic, copy) NSColor *backgroundColor;	// default is nil
@property (nonatomic, retain) NSImage *image;
@property (nonatomic, copy) void (^drawingBlock)(NSView *view, NSRect);
@property (nonatomic, assign) PSViewContentMode contentMode;

- (void)addTarget:(id)target action:(SEL)action forEvents:(PSViewEvent)events;
- (void)sendActionsForEvents:(PSViewEvent)events; // Send all actions associated with events

@end
