//
//  MainWindowController.h
//  Perforce
//
//  Created by Adam Czubernat on 09.05.2013.
//  Copyright (c) 2013 Perforce Software, Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@interface MainWindowController : NSWindowController {
	__weak IBOutlet NSMenu *fileMenu;
	__weak IBOutlet NSMenu *actionsMenu;
	__weak IBOutlet NSMenu *viewMenu;
}

- (void)loadURL:(NSString *)url;

// Menu actions

- (IBAction)fileMenuConnect:(id)sender;
- (IBAction)fileMenuConnectionDetails:(id)sender;
- (IBAction)fileMenuDisconnect:(id)sender;

- (IBAction)viewMenuColumnView:(id)sender;
- (IBAction)viewMenuIconView:(id)sender;

- (IBAction)debugMenuRunCommand:(id)sender;
- (IBAction)debugMenuSaveLog:(id)sender;

@end
