//
//  PanelController.m
//  Perforce
//
//  Created by Adam Czubernat on 11.07.2013.
//  Copyright (c) 2013 Perforce Software, Inc. All rights reserved.
//

#import "PanelController.h"

@implementation PanelController {
	__strong id retain;
}
@synthesize parentWindow;

- (id)init {
	return self = [super initWithWindowNibName:NSStringFromClass([self class])];
}

- (void)windowDidLoad {
	[super windowDidLoad];
	[self.window setPreventsApplicationTerminationWhenModal:NO];
}

- (void)presentWithWindow:(NSWindow *)window {
	
	parentWindow = window;
	retain = self;
	
	while ([window attachedSheet])
		window = [window attachedSheet]; // Traverse through sheets
	
	[[NSApplication sharedApplication]
	 beginSheet:self.window
	 modalForWindow:window
	 modalDelegate:nil
	 didEndSelector:nil
	 contextInfo:NULL];
}

- (void)dismiss {
	[[NSApplication sharedApplication] endSheet:self.window];
	[self close];
	retain = nil;
}

- (void)setPresentedView:(NSView *)view {
	[self setPresentedView:view animated:NO];
}

- (void)setPresentedView:(NSView *)view animated:(BOOL)animated {	
	[presentedView removeFromSuperview];
	presentedView = view;
	
	[self.window.contentView setFrame:view.bounds];
	[self.window setFrame:view.bounds display:YES animate:animated];
	[self.window.contentView addSubview:view];
}

- (void)dismissAfter:(NSTimeInterval)delay {
	[self performSelector:@selector(dismiss) withObject:nil afterDelay:delay];
}

- (void)presentExclusiveWithWindow:(NSWindow *)window {
	NSWindow *attachedSheet = [window attachedSheet];
	if (attachedSheet) {
		[[NSApplication sharedApplication] endSheet:attachedSheet];
		[attachedSheet close];
	}
	[self presentWithWindow:window];
}

@end
