//
//  WorkspacePanelController.h
//  Perforce
//
//  Created by Adam Czubernat on 28.05.2013.
//  Copyright (c) 2013 Perforce Software, Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "PanelController.h"

@protocol WorkspacePanelControllerDelegate <NSObject>
- (void)workspacePanelDidSelectWorkspace:(NSString *)workspace;
- (void)workspacePanelDidCreateWorkspace:(NSString *)workspace;
- (void)workspacePanelDidCancel;
@end

@interface WorkspacePanelController : PanelController

@property (nonatomic, unsafe_unretained) id <WorkspacePanelControllerDelegate> delegate;

@end
