'/*
' * P4.Net *
'Copyright (c) 2006 Shawn Hladky
'
'Permission is hereby granted, free of charge, to any person obtaining a copy of this software 
'and associated documentation files (the "Software"), to deal in the Software without 
'restriction, including without limitation the rights to use, copy, modify, merge, publish, 
'distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the 
'Software is furnished to do so, subject to the following conditions:
'
'The above copyright notice and this permission notice shall be included in all copies or 
'substantial portions of the Software.
'
'THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING 
'BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
'NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
'DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
'OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE. 
' */


Public Class RecordsetViewer

    Private _recordset As P4API.P4RecordSet
    Private _recordIndex As Integer
    Private _p4 As P4API.P4Connection

    Private Sub Label1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Label1.Click

    End Sub

    Private Sub RecordsetViewer_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        _p4 = P4ConnectionDialog.Show()
        If _p4 Is Nothing Then End
    End Sub

    Private Sub DataGridView1_CellContentClick(ByVal sender As System.Object, ByVal e As System.Windows.Forms.DataGridViewCellEventArgs)

    End Sub

    Private Sub Label3_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Label3.Click

    End Sub

    Private Sub btnRun_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnRun.Click
        RunCommand()
    End Sub

    Private Sub RunCommand()

        Dim args As New List(Of String)
        Dim s As String

        If txtCommand.Text = "" Then
            MessageBox.Show("Must enter a command!")
            Exit Sub
        End If

        Me.Enabled = False
        ' save the old cursor
        Dim oldCursor As Cursor
        oldCursor = Me.Cursor

        _p4.ExceptionLevel = P4API.P4ExceptionLevels.NoExceptionOnErrors
        _p4.Connect()

        For Each s In txtArguments.Text.Split(vbCrLf)
            If s.Trim().Length > 0 Then args.Add(s.Trim())
        Next

        ' change the cursor to the one you want
        Me.Cursor = Cursors.WaitCursor

        _recordset = _p4.Run(txtCommand.Text, args.ToArray())
        _recordIndex = 0

        PaintStrings()
        PaintRecord()

        _p4.Disconnect()

        ' restore the old cursor or else you may never get it back
        Me.Cursor = oldCursor
        Me.Enabled = True

    End Sub

    Private Sub PaintRecord()

        gridFields.Rows.Clear()
        gridArrayFields.Rows.Clear()

        If _recordset Is Nothing Then
            cmdNextRec.Enabled = False
            cmdPrevRec.Enabled = False
            Exit Sub
        End If

        'Disable both buttons if there are no records
        If _recordset.Records.Length = 0 Then
            cmdNextRec.Enabled = False
            cmdPrevRec.Enabled = False
            Exit Sub
        End If

        'make sure we're not past the last record
        If _recordIndex > _recordset.Records.Length - 1 Then
            _recordIndex = _recordset.Records.Length - 1
        End If

        cmdNextRec.Enabled = _recordIndex < _recordset.Records.Length - 1
        cmdPrevRec.Enabled = _recordIndex <> 0

        'Set the record index label
        lblRecordIndex.Text = String.Format("{0}/{1}", _recordIndex + 1, _recordset.Records.Length)

        Dim currentRecord As P4API.P4Record
        currentRecord = _recordset.Records(_recordIndex)

        Dim key As String
        For Each key In currentRecord.Fields.Keys
            gridFields.Rows.Add(key, currentRecord(key))
        Next

        Dim ArrayIndex As Integer
        For Each key In currentRecord.ArrayFields.Keys
            For ArrayIndex = 0 To currentRecord.ArrayFields(key).Length - 1
                gridArrayFields.Rows.Add(key, ArrayIndex, currentRecord.ArrayFields(key)(ArrayIndex))
            Next
        Next


    End Sub

    Private Sub PaintStrings()
        Dim s As String
        txtMessages.Text = ""
        For Each s In _recordset.Messages
            txtMessages.Text = txtMessages.Text & s & vbCrLf
        Next

        txtWarnings.Text = ""
        For Each s In _recordset.Warnings
            txtWarnings.Text = txtWarnings.Text & s & vbCrLf
        Next

        txtErrors.Text = ""
        For Each s In _recordset.Errors
            txtErrors.Text = txtErrors.Text & s & vbCrLf
        Next

    End Sub


    Private Sub cmdPrevRec_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdPrevRec.Click
        _recordIndex = _recordIndex - 1
        PaintRecord()
    End Sub

    Private Sub cmdNextRec_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdNextRec.Click
        _recordIndex = _recordIndex + 1
        PaintRecord()
    End Sub


End Class
