using System;
using System.Collections;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Runtime.CompilerServices;
using System.Text;

namespace Perforce.P4
{
	public partial class P4ClientError
	{
		public static int MsgDb_JnlEnd = ErrorOf(ErrorSubsystem.ES_DB, 1, ErrorSeverity.E_FATAL, ErrorGeneric.EV_ADMIN, 0); //"End of input in middle of word!"
		public static int MsgDb_JnlWord2Big = ErrorOf(ErrorSubsystem.ES_DB, 2, ErrorSeverity.E_FATAL, ErrorGeneric.EV_ADMIN, 0); //"Word too big for buffer!"
		public static int MsgDb_JnlOct2Long = ErrorOf(ErrorSubsystem.ES_DB, 3, ErrorSeverity.E_FATAL, ErrorGeneric.EV_ADMIN, 0); //"Octet stream too long!"
		public static int MsgDb_JnlOctSize = ErrorOf(ErrorSubsystem.ES_DB, 4, ErrorSeverity.E_FATAL, ErrorGeneric.EV_ADMIN, 0); //"Octet stream size mismatch!"
		public static int MsgDb_JnlNum2Big = ErrorOf(ErrorSubsystem.ES_DB, 5, ErrorSeverity.E_FATAL, ErrorGeneric.EV_ADMIN, 0); //"Word too big for a number!"
		public static int MsgDb_JnlQuoting = ErrorOf(ErrorSubsystem.ES_DB, 6, ErrorSeverity.E_FATAL, ErrorGeneric.EV_ADMIN, 1); //"Bad quoting in journal file at line %line%!"
		public static int MsgDb_JnlOpcode = ErrorOf(ErrorSubsystem.ES_DB, 7, ErrorSeverity.E_FATAL, ErrorGeneric.EV_ADMIN, 1); //"Bad opcode '%operation%' journal record!"
		public static int MsgDb_JnlNoVers = ErrorOf(ErrorSubsystem.ES_DB, 8, ErrorSeverity.E_FATAL, ErrorGeneric.EV_ADMIN, 0); //"Missing version number in journal record!"
		public static int MsgDb_JnlNoName = ErrorOf(ErrorSubsystem.ES_DB, 9, ErrorSeverity.E_FATAL, ErrorGeneric.EV_ADMIN, 0); //"Missing table name in journal record!"
		public static int MsgDb_JnlNoTVers = ErrorOf(ErrorSubsystem.ES_DB, 10, ErrorSeverity.E_FATAL, ErrorGeneric.EV_ADMIN, 0); //"Missing table version in journal record!"
		public static int MsgDb_JnlBadVers = ErrorOf(ErrorSubsystem.ES_DB, 11, ErrorSeverity.E_FATAL, ErrorGeneric.EV_ADMIN, 0); //"Record version not known in journal record!"
		public static int MsgDb_JnlReplay = ErrorOf(ErrorSubsystem.ES_DB, 12, ErrorSeverity.E_FATAL, ErrorGeneric.EV_ADMIN, 0); //"Journal record replay failed!"
		public static int MsgDb_JnlDeleteFailed = ErrorOf(ErrorSubsystem.ES_DB, 89, ErrorSeverity.E_FATAL, ErrorGeneric.EV_ADMIN, 2); //"In table %tableName%, the following row was not present or could not be deleted. It may be possible to use the '-f' flag to proceed beyond this point. Row data: \"
		public static int MsgDb_JnlSeqBad = ErrorOf(ErrorSubsystem.ES_DB, 13, ErrorSeverity.E_WARN, ErrorGeneric.EV_ADMIN, 1); //"Journal file '%file%' skipped (out of sequence)."
		public static int MsgDb_JnlFileBad = ErrorOf(ErrorSubsystem.ES_DB, 14, ErrorSeverity.E_FATAL, ErrorGeneric.EV_ADMIN, 2); //"Journal file '%file%' replay failed at line %line%!"
		public static int MsgDb_JnlBadMarker = ErrorOf(ErrorSubsystem.ES_DB, 76, ErrorSeverity.E_FATAL, ErrorGeneric.EV_ADMIN, 0); //"Bad transaction marker!"
		public static int MsgDb_JnlCaseUsageBad = ErrorOf(ErrorSubsystem.ES_DB, 80, ErrorSeverity.E_FATAL, ErrorGeneric.EV_ADMIN, 2); //"Case-handling mismatch: server uses %caseUsage% but journal flags are %flags%!"
		public static int MsgDb_JnlVersionMismatch = ErrorOf(ErrorSubsystem.ES_DB, 81, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"Server version %serverVersion% is replaying a version %journalVersion% journal/checkpoint."
		public static int MsgDb_CheckpointNoOverwrite = ErrorOf(ErrorSubsystem.ES_DB, 90, ErrorSeverity.E_FATAL, ErrorGeneric.EV_NONE, 0); //"A full checkpoint should not be replayed into a non-empty database. Please remove the existing db.* files and retry the operation. The '-jrF' flag can be specified to bypass this check."
		public static int MsgDb_TableCheckSum = ErrorOf(ErrorSubsystem.ES_DB, 84, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 6); //"Table %table% checksums %result%. %when% version %tableVersion%: expected %expected%, actual %actual%."
		public static int MsgDb_JnlVersionError = ErrorOf(ErrorSubsystem.ES_DB, 82, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NONE, 2); //"Server version %serverVersion% cannot replay a version %journalVersion% journal/checkpoint."
		public static int MsgDb_DbOpen = ErrorOf(ErrorSubsystem.ES_DB, 15, ErrorSeverity.E_FATAL, ErrorGeneric.EV_ADMIN, 1); //"Database open error on %table%!"
		public static int MsgDb_WriteNoLock = ErrorOf(ErrorSubsystem.ES_DB, 16, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 1); //"dbput %table%: no write lock!"
		public static int MsgDb_Write = ErrorOf(ErrorSubsystem.ES_DB, 17, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 1); //"Database write error on %table%!"
		public static int MsgDb_ReadNoLock = ErrorOf(ErrorSubsystem.ES_DB, 18, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 1); //"dbget %table%: no read lock!"
		public static int MsgDb_Read = ErrorOf(ErrorSubsystem.ES_DB, 19, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 1); //"Database get error on %table%!"
		public static int MsgDb_Stumblebum = ErrorOf(ErrorSubsystem.ES_DB, 20, ErrorSeverity.E_FATAL, ErrorGeneric.EV_ADMIN, 0); //"Database must be 98.1 through "
		public static int MsgDb_GetFormat = ErrorOf(ErrorSubsystem.ES_DB, 21, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 2); //"dbget: %table% record format %level% unsupported!"
		public static int MsgDb_ScanNoLock = ErrorOf(ErrorSubsystem.ES_DB, 22, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 1); //"dbscan %table%: no read lock!"
		public static int MsgDb_Scan = ErrorOf(ErrorSubsystem.ES_DB, 23, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 1); //"Database scan error on %table%!"
		public static int MsgDb_ScanFormat = ErrorOf(ErrorSubsystem.ES_DB, 24, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 2); //"dbscan: %table% record format %level% unsupported!"
		public static int MsgDb_DelNoLock = ErrorOf(ErrorSubsystem.ES_DB, 25, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 1); //"dbdel %table%: no write lock!"
		public static int MsgDb_Delete = ErrorOf(ErrorSubsystem.ES_DB, 26, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 1); //"Database delete error on %table%!"
		public static int MsgDb_Locking = ErrorOf(ErrorSubsystem.ES_DB, 27, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 1); //"Database locking error on %table%!"
		public static int MsgDb_EndXact = ErrorOf(ErrorSubsystem.ES_DB, 28, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 1); //"End xact with %table% still locked!"
		public static int MsgDb_GetNoGet = ErrorOf(ErrorSubsystem.ES_DB, 64, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 1); //"GetDb of %table% without prior get!"
		public static int MsgDb_ValidationFoundProblems = ErrorOf(ErrorSubsystem.ES_DB, 86, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ADMIN, 1); //"Problems were found in %numTables% table(s)."
		public static int MsgDb_TableUnknown = ErrorOf(ErrorSubsystem.ES_DB, 29, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Table %table% not known."
		public static int MsgDb_TableObsolete = ErrorOf(ErrorSubsystem.ES_DB, 78, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Table %table% is obsolete."
		public static int MsgDb_LockOrder = ErrorOf(ErrorSubsystem.ES_DB, 30, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 2); //"Locking failure: %table% locked after %table2%!"
		public static int MsgDb_LockUpgrade = ErrorOf(ErrorSubsystem.ES_DB, 31, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 1); //"Locking failure: no upgrading %table%'s lock!"
		public static int MsgDb_MaxMemory = ErrorOf(ErrorSubsystem.ES_DB, 33, ErrorSeverity.E_FATAL, ErrorGeneric.EV_TOOBIG, 0); //"Request too large for server memory (try later?)."
		public static int MsgDb_KeyTooBig = ErrorOf(ErrorSubsystem.ES_DB, 34, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 0); //"Record key exceeds max size!"
		public static int MsgDb_XactOutstandingRestart = ErrorOf(ErrorSubsystem.ES_DB, 85, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Server restarted while %count% transaction(s) outstanding."
		public static int MsgDb_ExtraDots = ErrorOf(ErrorSubsystem.ES_DB, 35, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Only three ... permitted in '%arg%'."
		public static int MsgDb_ExtraStars = ErrorOf(ErrorSubsystem.ES_DB, 36, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Too many *'s in '%arg%'."
		public static int MsgDb_Duplicate = ErrorOf(ErrorSubsystem.ES_DB, 37, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Duplicate wildcards in '%arg%'."
		public static int MsgDb_WildMismatch = ErrorOf(ErrorSubsystem.ES_DB, 38, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 2); //"Incompatible wildcards '%arg%' <-> '%arg2%'."
		public static int MsgDb_TooWild = ErrorOf(ErrorSubsystem.ES_DB, 73, ErrorSeverity.E_FAILED, ErrorGeneric.EV_TOOBIG, 0); //"Excessive combinations of wildcard ... in path and maps."
		public static int MsgDb_TooWild2 = ErrorOf(ErrorSubsystem.ES_DB, 79, ErrorSeverity.E_FAILED, ErrorGeneric.EV_TOOBIG, 0); //"Excessive combinations of wildcards in path and maps."
		public static int MsgDb_Juxtaposed = ErrorOf(ErrorSubsystem.ES_DB, 74, ErrorSeverity.E_FAILED, ErrorGeneric.EV_TOOBIG, 1); //"Senseless juxtaposition of wildcards in '%arg%'."
		public static int MsgDb_ParseErr = ErrorOf(ErrorSubsystem.ES_DB, 41, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Expression parse error at '%line%'."
		public static int MsgDb_Field2Many = ErrorOf(ErrorSubsystem.ES_DB, 42, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Too many entries for field '%field%'."
		public static int MsgDb_FieldBadVal = ErrorOf(ErrorSubsystem.ES_DB, 43, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 2); //"Value for field '%field%' must be one of %text%."
		public static int MsgDb_FieldWords = ErrorOf(ErrorSubsystem.ES_DB, 44, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Wrong number of words for field '%field%'."
		public static int MsgDb_FieldMissing = ErrorOf(ErrorSubsystem.ES_DB, 45, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Missing required field '%field%'."
		public static int MsgDb_FieldBadIndex = ErrorOf(ErrorSubsystem.ES_DB, 46, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Can't find numbered field in spec."
		public static int MsgDb_FieldUnknown = ErrorOf(ErrorSubsystem.ES_DB, 47, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Unknown field name '%field%'."
		public static int MsgDb_FieldTypeBad = ErrorOf(ErrorSubsystem.ES_DB, 48, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 2); //"Unknown type '%type%' for field '%field%'."
		public static int MsgDb_FieldOptBad = ErrorOf(ErrorSubsystem.ES_DB, 49, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 2); //"Unknown option '%option%' for field '%field%'."
		public static int MsgDb_NoEndQuote = ErrorOf(ErrorSubsystem.ES_DB, 63, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"No matching end quote in '%value%'."
		public static int MsgDb_Syntax = ErrorOf(ErrorSubsystem.ES_DB, 50, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Syntax error in '%value%'."
		public static int MsgDb_LineNo = ErrorOf(ErrorSubsystem.ES_DB, 51, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Error detected at line %line%."
		public static int MsgDb_LicenseExp = ErrorOf(ErrorSubsystem.ES_DB, 52, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ADMIN, 0); //"License expired."
		public static int MsgDb_SupportExp = ErrorOf(ErrorSubsystem.ES_DB, 53, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ADMIN, 0); //"Support expired."
		public static int MsgDb_ServerTooNew = ErrorOf(ErrorSubsystem.ES_DB, 54, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ADMIN, 0); //"Server newer than current date."
		public static int MsgDb_MustExpire = ErrorOf(ErrorSubsystem.ES_DB, 55, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ADMIN, 0); //"License must expire."
		public static int MsgDb_Checksum = ErrorOf(ErrorSubsystem.ES_DB, 56, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ADMIN, 0); //"Invalid checksum string."
		public static int MsgDb_WrongApp = ErrorOf(ErrorSubsystem.ES_DB, 57, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ADMIN, 1); //"This server is only licensed for %users% use."
		public static int MsgDb_PlatPre972 = ErrorOf(ErrorSubsystem.ES_DB, 58, ErrorSeverity.E_FAILED, ErrorGeneric.EV_UPGRADE, 0); //"Can't have platforms for pre-97.2 servers."
		public static int MsgDb_LicenseRead = ErrorOf(ErrorSubsystem.ES_DB, 59, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ADMIN, 0); //"Error reading license file."
		public static int MsgDb_LicenseBad = ErrorOf(ErrorSubsystem.ES_DB, 60, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ADMIN, 0); //"License file invalid."
		public static int MsgDb_AddressChanged = ErrorOf(ErrorSubsystem.ES_DB, 75, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ADMIN, 0); //"Server license IPaddress changed, cannot proceed."
		public static int MsgDb_LicenseNeedsApplication = ErrorOf(ErrorSubsystem.ES_DB, 83, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ADMIN, 0); //"License needs an application."
		public static int MsgDb_BadIPservice = ErrorOf(ErrorSubsystem.ES_DB, 88, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ADMIN, 0); //"Licensed client service cannot be localhost (127.0.0.1 or ::1)"
		public static int MsgDb_TreeCorrupt = ErrorOf(ErrorSubsystem.ES_DB, 66, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 0); //"BTree is corrupt!"
		public static int MsgDb_TreeNotOpened = ErrorOf(ErrorSubsystem.ES_DB, 67, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 0); //"BTree could not be opened or created!"
		public static int MsgDb_InternalUsage = ErrorOf(ErrorSubsystem.ES_DB, 68, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 0); //"Internal BTree usage is not supported!"
		public static int MsgDb_TreeAllocation = ErrorOf(ErrorSubsystem.ES_DB, 69, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 0); //"Allocation failure in db!"
		public static int MsgDb_TreeNotSupported = ErrorOf(ErrorSubsystem.ES_DB, 70, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 0); //"BTree variation is not supported!"
		public static int MsgDb_TreeAlreadyUpgraded = ErrorOf(ErrorSubsystem.ES_DB, 87, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 0); //"BTree has already been accessed by a later version of the Perforce server!"
		public static int MsgDb_TreeInternal = ErrorOf(ErrorSubsystem.ES_DB, 71, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 0); //"Internal BTree system failure!"
		public static int MsgDb_TreeNewerVersion = ErrorOf(ErrorSubsystem.ES_DB, 91, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 1); //"BTree %file% from a newer server version"
		public static int MsgDb_TreeOlderVersion = ErrorOf(ErrorSubsystem.ES_DB, 92, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 1); //"BTree %file% from an older server version - 2013.2 or earlier"
		public static int MsgDb_MapCheckFail = ErrorOf(ErrorSubsystem.ES_DB, 72, ErrorSeverity.E_FAILED, ErrorGeneric.EV_TOOBIG, 0); //"MapCheck rejected too many rows."
		public static int MsgDb_CaseMismatch = ErrorOf(ErrorSubsystem.ES_DB, 77, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 0); //"BTree Case Order Mismatch! Check p4d -Cx flag usage."
		public static int MsgDb_MaxResults = ErrorOf(ErrorSubsystem.ES_DB, 32, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ADMIN, 1); //"Request too large (over %maxResults%); see 'p4 help maxresults'."
		public static int MsgDb_MaxScanRows = ErrorOf(ErrorSubsystem.ES_DB, 61, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ADMIN, 1); //"Too many rows scanned (over %maxScanRows%); see 'p4 help maxscanrows'."
		public static int MsgDb_NotUnderRoot = ErrorOf(ErrorSubsystem.ES_DB, 39, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CONTEXT, 2); //"Path '%path%' is not under client's root '%root%'."
		public static int MsgDb_NotUnderClient = ErrorOf(ErrorSubsystem.ES_DB, 40, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CONTEXT, 2); //"Path '%path%' is not under client '%client%'."
		public static int MsgDb_ClientGone = ErrorOf(ErrorSubsystem.ES_DB, 62, ErrorSeverity.E_FATAL, ErrorGeneric.EV_ADMIN, 0); //"Client has dropped connection, terminating request."
		public static int MsgDb_CommandCancelled = ErrorOf(ErrorSubsystem.ES_DB, 62, ErrorSeverity.E_FATAL, ErrorGeneric.EV_ADMIN, 0); //"Command has been cancelled, terminating request."
		public static int MsgDb_DbStat = ErrorOf(ErrorSubsystem.ES_DB, 65, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 4); //"--- %table% pos %position% get %get% scan %scan%"
	}
}
