using System;
using System.Collections;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Runtime.CompilerServices;
using System.Text;

namespace Perforce.P4
{
	public partial class P4ClientError
	{
		public static int MsgDm_CheckFailed = ErrorOf(ErrorSubsystem.ES_DM, 1, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 2); //"%table%/%table2% inconsistencies found."
		public static int MsgDm_InvalidType = ErrorOf(ErrorSubsystem.ES_DM, 2, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 2); //"Invalid %type% '%arg%'."
		public static int MsgDm_IdTooLong = ErrorOf(ErrorSubsystem.ES_DM, 3, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Identifiers too long.  Must not be longer than 1024 bytes of UTF-8."
		public static int MsgDm_LineTooLong = ErrorOf(ErrorSubsystem.ES_DM, 673, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Logfile line too long. Maximum length is %maxLineLen%. This length can be increased by setting the filesys.bufsize configurable."
		public static int MsgDm_NoSuchServerlog = ErrorOf(ErrorSubsystem.ES_DM, 714, ErrorSeverity.E_FAILED, ErrorGeneric.EV_UNKNOWN, 1); //"No such logfile '%logfile%'."
		public static int MsgDm_IdHasDash = ErrorOf(ErrorSubsystem.ES_DM, 4, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Initial dash character not allowed in '%id%'."
		public static int MsgDm_IdEmpty = ErrorOf(ErrorSubsystem.ES_DM, 5, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Empty identifier not allowed."
		public static int MsgDm_IdNonPrint = ErrorOf(ErrorSubsystem.ES_DM, 6, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Non-printable characters not allowed in '%id%'."
		public static int MsgDm_IdHasRev = ErrorOf(ErrorSubsystem.ES_DM, 7, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Revision chars (@, #) not allowed in '%id%'."
		public static int MsgDm_IdHasSlash = ErrorOf(ErrorSubsystem.ES_DM, 8, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Slashes (/) not allowed in '%id%'."
		public static int MsgDm_IdHasComma = ErrorOf(ErrorSubsystem.ES_DM, 485, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Commas (,) not allowed in '%id%'."
		public static int MsgDm_IdHasPercent = ErrorOf(ErrorSubsystem.ES_DM, 642, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Percent character not allowed in '%id%'."
		public static int MsgDm_IdNullDir = ErrorOf(ErrorSubsystem.ES_DM, 9, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Null directory (//) not allowed in '%id%'."
		public static int MsgDm_IdRelPath = ErrorOf(ErrorSubsystem.ES_DM, 10, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Relative paths (., ..) not allowed in '%id%'."
		public static int MsgDm_IdWild = ErrorOf(ErrorSubsystem.ES_DM, 11, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Wildcards (*, %%%%x, ...) not allowed in '%id%'."
		public static int MsgDm_IdNumber = ErrorOf(ErrorSubsystem.ES_DM, 12, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Purely numeric name not allowed - '%id%'."
		public static int MsgDm_IdEmbeddedNul = ErrorOf(ErrorSubsystem.ES_DM, 749, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Embedded null bytes not allowed - '%id%'."
		public static int MsgDm_BadOption = ErrorOf(ErrorSubsystem.ES_DM, 13, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 2); //"Invalid option '%option%' in %field% option field."
		public static int MsgDm_BadChange = ErrorOf(ErrorSubsystem.ES_DM, 14, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Invalid changelist number '%change%'."
		public static int MsgDm_BadMaxResult = ErrorOf(ErrorSubsystem.ES_DM, 15, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Invalid maximum value '%value%'."
		public static int MsgDm_BadTimeout = ErrorOf(ErrorSubsystem.ES_DM, 422, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Invalid Timeout value '%value%'."
		public static int MsgDm_BadRevision = ErrorOf(ErrorSubsystem.ES_DM, 17, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Invalid revision number '%rev%'."
		public static int MsgDm_BadTypeMod = ErrorOf(ErrorSubsystem.ES_DM, 18, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Invalid file type modifier on '%arg%'; see 'p4 help filetypes'."
		public static int MsgDm_BadStorageCombo = ErrorOf(ErrorSubsystem.ES_DM, 19, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Only one storage modifier +C +D +F or +S allowed on '%arg%'."
		public static int MsgDm_BadVersionCount = ErrorOf(ErrorSubsystem.ES_DM, 460, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Bad version count '+S%count%', only values 1-10,16,32,64,128,256,512 allowed."
		public static int MsgDm_BadTypeCombo = ErrorOf(ErrorSubsystem.ES_DM, 20, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 2); //"Disallowed modifier (%option%) on '%arg%'; see 'p4 help filetypes'."
		public static int MsgDm_BadType = ErrorOf(ErrorSubsystem.ES_DM, 21, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Invalid file type '%type%'; see 'p4 help filetypes'."
		public static int MsgDm_BadDigest = ErrorOf(ErrorSubsystem.ES_DM, 418, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Invalid digest string '%digest%'."
		public static int MsgDm_BadTypePartial = ErrorOf(ErrorSubsystem.ES_DM, 435, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"A partial file type is not allowed here."
		public static int MsgDm_BadTypeAuto = ErrorOf(ErrorSubsystem.ES_DM, 624, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Automatic type detection is not allowed here."
		public static int MsgDm_NeedsUpgrades = ErrorOf(ErrorSubsystem.ES_DM, 22, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ADMIN, 2); //"Database is at old upgrade level %level%.  Use 'p4d -xu' to upgrade to level %level2%."
		public static int MsgDm_PastUpgrade = ErrorOf(ErrorSubsystem.ES_DM, 23, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ADMIN, 2); //"Database is at upgrade level %level% past this server's level %level2%."
		public static int MsgDm_Unicode = ErrorOf(ErrorSubsystem.ES_DM, 24, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ADMIN, 1); //"Database has %value% tables with non-UTF8 text and can't be switched to Unicode mode."
		public static int MsgDm_DescMissing = ErrorOf(ErrorSubsystem.ES_DM, 25, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 1); //"%key% description missing!"
		public static int MsgDm_NoSuchChange = ErrorOf(ErrorSubsystem.ES_DM, 26, ErrorSeverity.E_FAILED, ErrorGeneric.EV_UNKNOWN, 1); //"%change% unknown."
		public static int MsgDm_AlreadyCommitted = ErrorOf(ErrorSubsystem.ES_DM, 27, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CONTEXT, 1); //"%change% is already committed."
		public static int MsgDm_WrongClient = ErrorOf(ErrorSubsystem.ES_DM, 28, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CONTEXT, 2); //"%change% belongs to client %client%."
		public static int MsgDm_WrongUser = ErrorOf(ErrorSubsystem.ES_DM, 29, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CONTEXT, 2); //"%change% belongs to user %user%."
		public static int MsgDm_NoSuchCounter = ErrorOf(ErrorSubsystem.ES_DM, 30, ErrorSeverity.E_FAILED, ErrorGeneric.EV_UNKNOWN, 1); //"No such counter '%counter%'."
		public static int MsgDm_NoSuchKey = ErrorOf(ErrorSubsystem.ES_DM, 643, ErrorSeverity.E_FAILED, ErrorGeneric.EV_UNKNOWN, 1); //"No such key '%key%'."
		public static int MsgDm_NotThatCounter = ErrorOf(ErrorSubsystem.ES_DM, 31, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Too dangerous to touch counter '%counter%'."
		public static int MsgDm_MayNotBeNegative = ErrorOf(ErrorSubsystem.ES_DM, 615, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Negative value not allowed for counter '%counter%'."
		public static int MsgDm_MustBeNumeric = ErrorOf(ErrorSubsystem.ES_DM, 617, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Non-numeric value not allowed for counter '%counter%'."
		public static int MsgDm_NoSuchDepot = ErrorOf(ErrorSubsystem.ES_DM, 32, ErrorSeverity.E_FAILED, ErrorGeneric.EV_UNKNOWN, 1); //"Depot '%depot%' doesn't exist."
		public static int MsgDm_NoSuchDepot2 = ErrorOf(ErrorSubsystem.ES_DM, 33, ErrorSeverity.E_FAILED, ErrorGeneric.EV_UNKNOWN, 1); //"Depot '%depot%' unknown - use 'depot' to create it."
		public static int MsgDm_NoSuchDomain = ErrorOf(ErrorSubsystem.ES_DM, 34, ErrorSeverity.E_FAILED, ErrorGeneric.EV_UNKNOWN, 2); //"%type% '%name%' doesn't exist."
		public static int MsgDm_NoSuchDomain2 = ErrorOf(ErrorSubsystem.ES_DM, 35, ErrorSeverity.E_FAILED, ErrorGeneric.EV_UNKNOWN, 3); //"%type% '%name%' unknown - use '%command%' command to create it."
		public static int MsgDm_WrongDomain = ErrorOf(ErrorSubsystem.ES_DM, 36, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CONTEXT, 3); //"%name% is a %type%, not a %type2%."
		public static int MsgDm_TooManyClients = ErrorOf(ErrorSubsystem.ES_DM, 37, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ADMIN, 0); //"Can't add client - over license quota."
		public static int MsgDm_NoSuchJob = ErrorOf(ErrorSubsystem.ES_DM, 38, ErrorSeverity.E_FAILED, ErrorGeneric.EV_UNKNOWN, 1); //"Job '%job%' doesn't exist."
		public static int MsgDm_NoSuchJob2 = ErrorOf(ErrorSubsystem.ES_DM, 39, ErrorSeverity.E_FAILED, ErrorGeneric.EV_UNKNOWN, 1); //"Job '%job%' unknown - use 'job' to create it."
		public static int MsgDm_NoSuchFix = ErrorOf(ErrorSubsystem.ES_DM, 40, ErrorSeverity.E_FAILED, ErrorGeneric.EV_UNKNOWN, 0); //"No such fix."
		public static int MsgDm_NoPerms = ErrorOf(ErrorSubsystem.ES_DM, 41, ErrorSeverity.E_FAILED, ErrorGeneric.EV_PROTECT, 0); //"You don't have permission for this operation."
		public static int MsgDm_OperatorNotAllowed = ErrorOf(ErrorSubsystem.ES_DM, 632, ErrorSeverity.E_FAILED, ErrorGeneric.EV_PROTECT, 2); //"Operator user %userName% may not perform operation %funcName%"
		public static int MsgDm_NoSuchRelease = ErrorOf(ErrorSubsystem.ES_DM, 537, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"There was no Perforce release named '%release%'."
		public static int MsgDm_ClientTooOld = ErrorOf(ErrorSubsystem.ES_DM, 538, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"You may not set minClient to a release newer than your client."
		public static int MsgDm_NoProtect = ErrorOf(ErrorSubsystem.ES_DM, 123, ErrorSeverity.E_FAILED, ErrorGeneric.EV_PROTECT, 1); //"Access for user '%user%' has not been enabled by 'p4 protect'."
		public static int MsgDm_PathNotUnder = ErrorOf(ErrorSubsystem.ES_DM, 42, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CONTEXT, 2); //"Path '%depotFile%' is not under '%prefix%'."
		public static int MsgDm_TooManyUsers = ErrorOf(ErrorSubsystem.ES_DM, 43, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ADMIN, 0); //"Can't create a new user - over license quota."
		public static int MsgDm_MapNotUnder = ErrorOf(ErrorSubsystem.ES_DM, 44, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CONTEXT, 2); //"Mapping '%depotFile%' is not under '%prefix%'."
		public static int MsgDm_MapNoListAccess = ErrorOf(ErrorSubsystem.ES_DM, 432, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CONTEXT, 0); //"User does not have list access for mapped depots."
		public static int MsgDm_DepotMissing = ErrorOf(ErrorSubsystem.ES_DM, 45, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 1); //"Depot %depot% missing from depot table!"
		public static int MsgDm_UnloadNotOwner = ErrorOf(ErrorSubsystem.ES_DM, 708, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Client, label, or task stream %domainName% is not owned by you."
		public static int MsgDm_UnloadNotPossible = ErrorOf(ErrorSubsystem.ES_DM, 776, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 2); //"%domainType% %domainName% has file(s) exclusively opened or has promoted shelves, and may not be unloaded. Revert the exclusively opened files and delete the promoted shelves, then retry the unload."
		public static int MsgDm_ReloadNotOwner = ErrorOf(ErrorSubsystem.ES_DM, 709, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Unloaded client, label, or task stream %domainName% is not owned by you."
		public static int MsgDm_UnloadDepotMissing = ErrorOf(ErrorSubsystem.ES_DM, 707, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"No unload depot has been defined for this server."
		public static int MsgDm_UnloadData = ErrorOf(ErrorSubsystem.ES_DM, 715, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%object% %name% unloaded."
		public static int MsgDm_ReloadData = ErrorOf(ErrorSubsystem.ES_DM, 716, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%object% %name% reloaded."
		public static int MsgDm_DepotVsDomains = ErrorOf(ErrorSubsystem.ES_DM, 46, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 0); //"Depot and domains table out of sync!"
		public static int MsgDm_RevVsRevCx = ErrorOf(ErrorSubsystem.ES_DM, 47, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 0); //"Revision table out of sync with index!"
		public static int MsgDm_NoPrevRev = ErrorOf(ErrorSubsystem.ES_DM, 616, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"Unable to show the differences for file %depotFile% because the revision prior to %depotRev% is missing from the revisions table. If the prior revisions of this file were obliterated, this is a normal situation; otherwise it may indicate repository damage and should be investigated further."
		public static int MsgDm_CantFindChange = ErrorOf(ErrorSubsystem.ES_DM, 49, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 1); //"Can't find %change%!"
		public static int MsgDm_BadIntegFlag = ErrorOf(ErrorSubsystem.ES_DM, 50, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 0); //"DmtIntegData unknown DBT_OPEN_FLAG!"
		public static int MsgDm_BadJobTemplate = ErrorOf(ErrorSubsystem.ES_DM, 51, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 0); //"Job template unusable!"
		public static int MsgDm_NeedJobUpgrade = ErrorOf(ErrorSubsystem.ES_DM, 52, ErrorSeverity.E_FATAL, ErrorGeneric.EV_ADMIN, 0); //"Jobs database must be upgraded with 'p4 jobs -R'!"
		public static int MsgDm_BadJobPresets = ErrorOf(ErrorSubsystem.ES_DM, 53, ErrorSeverity.E_FATAL, ErrorGeneric.EV_ADMIN, 0); //"Presets in jobspec unusable!"
		public static int MsgDm_JobNameMissing = ErrorOf(ErrorSubsystem.ES_DM, 54, ErrorSeverity.E_FATAL, ErrorGeneric.EV_ADMIN, 0); //"Missing job name field!"
		public static int MsgDm_HaveVsRev = ErrorOf(ErrorSubsystem.ES_DM, 55, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 1); //"File %depotFile% isn't in revisions table!"
		public static int MsgDm_AddHaveVsRev = ErrorOf(ErrorSubsystem.ES_DM, 792, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 1); //"File %depotFile% isn't in revisions table. The file may have been obliterated by an administrator. Make a backup copy of your local file before proceeding. Then use 'p4 sync' to synchronize your client state with the server. Then copy the desired file back into your workspace location. Then retry the add."
		public static int MsgDm_ReloadSuspicious = ErrorOf(ErrorSubsystem.ES_DM, 800, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Input file contains an incorrect record for %tableName%."
		public static int MsgDm_BadOpenFlag = ErrorOf(ErrorSubsystem.ES_DM, 56, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 0); //"DmOpenData unhandled DBT_OPEN_FLAG!"
		public static int MsgDm_NameChanged = ErrorOf(ErrorSubsystem.ES_DM, 57, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 1); //"File %depotFile% changed it's name!"
		public static int MsgDm_WorkingVsLocked = ErrorOf(ErrorSubsystem.ES_DM, 58, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 0); //"Working and locked tables out of sync!"
		public static int MsgDm_IntegVsRev = ErrorOf(ErrorSubsystem.ES_DM, 59, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 1); //"%depotFile% is missing from the rev table!"
		public static int MsgDm_IntegVsWork = ErrorOf(ErrorSubsystem.ES_DM, 60, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 1); //"%depotFile% is missing from the working table!"
		public static int MsgDm_ConcurrentFileChange = ErrorOf(ErrorSubsystem.ES_DM, 640, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"%depotFile% was altered during the course of the submit. Verify the contents of the changelist and retry the submit."
		public static int MsgDm_AtMostOne = ErrorOf(ErrorSubsystem.ES_DM, 61, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NOTYET, 1); //"In the change being submitted, %depotFile% has more than one 'branch' or 'delete' integration. Use 'p4 resolved' to display the integrations that are contained in this change. Revert any file(s) containing multiple 'branch' or 'delete' integrations. Then re-integrate those files containing at most one such integration. Then retry the submit."
		public static int MsgDm_IntegVsShelve = ErrorOf(ErrorSubsystem.ES_DM, 631, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 2); //"%depotFile%%rev%: can't resolve (shelved change was deleted); must revert, or revert -k and edit before submit."
		public static int MsgDm_MissingDesc = ErrorOf(ErrorSubsystem.ES_DM, 62, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Change description missing.  You must enter one."
		public static int MsgDm_BadJobView = ErrorOf(ErrorSubsystem.ES_DM, 63, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CONFIG, 0); //"Invalid JobView.  Set with 'p4 user'."
		public static int MsgDm_NoModComChange = ErrorOf(ErrorSubsystem.ES_DM, 64, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CONTEXT, 1); //"Can't update committed change %change%."
		public static int MsgDm_TheseCantChange = ErrorOf(ErrorSubsystem.ES_DM, 65, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ILLEGAL, 0); //"Client and status cannot be changed."
		public static int MsgDm_OwnerCantChange = ErrorOf(ErrorSubsystem.ES_DM, 467, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ILLEGAL, 0); //"Client, user, date and status cannot be changed."
		public static int MsgDm_UserCantChange = ErrorOf(ErrorSubsystem.ES_DM, 750, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ILLEGAL, 0); //"User cannot be changed in a committed change."
		public static int MsgDm_OpenFilesCantChange = ErrorOf(ErrorSubsystem.ES_DM, 473, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ILLEGAL, 0); //"Change has files open, client cannot be modified."
		public static int MsgDm_OpenFilesCantChangeUser = ErrorOf(ErrorSubsystem.ES_DM, 509, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ILLEGAL, 0); //"Change has files open, user cannot be modified."
		public static int MsgDm_CantOpenHere = ErrorOf(ErrorSubsystem.ES_DM, 66, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ILLEGAL, 0); //"Can't include file(s) not already opened.\nOpen new files with p4 add, p4 edit, etc."
		public static int MsgDm_OpenAttrRO = ErrorOf(ErrorSubsystem.ES_DM, 687, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ILLEGAL, 2); //"%file% - can't %action% file with propagating attributes from an edge server"
		public static int MsgDm_ReconcileBadName = ErrorOf(ErrorSubsystem.ES_DM, 676, ErrorSeverity.E_WARN, ErrorGeneric.EV_ILLEGAL, 1); //"%file% - can't reconcile filename with illegal characters."
		public static int MsgDm_ReconcileNeedForce = ErrorOf(ErrorSubsystem.ES_DM, 677, ErrorSeverity.E_WARN, ErrorGeneric.EV_ILLEGAL, 1); //"%file% - can't reconcile filename with wildcards [@#%*]. Use -f to force reconcile."
		public static int MsgDm_StatusSuccess = ErrorOf(ErrorSubsystem.ES_DM, 684, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 4); //"%localfile% - reconcile to %action% %depotFile%%workRev%"
		public static int MsgDm_PurgeFirst = ErrorOf(ErrorSubsystem.ES_DM, 67, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NOTYET, 1); //"Depot %depot% isn't empty. To delete a depot, all file revisions must be removed and all lazy copy references from other depots must be severed. Use 'p4 obliterate' or 'p4 snap' to break file linkages from other depots, then clear this depot with 'p4 obliterate', then retry the deletion."
		public static int MsgDm_SnapFirst = ErrorOf(ErrorSubsystem.ES_DM, 619, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NOTYET, 1); //"Depot %depot% isn't empty of archive contents. One or more files are still present in the depot directory. Other depots may have branched or integrated from files in this depot. Break those linkages with 'p4 snap' and/or remove references from other depots with 'p4 obliterate' first. Next, remove all non-Perforce files from the depot prior to depot deletion. Once all references have been removed, either remove any remaining physical files and directories from the depot directory and retry the operation, or specify '-f' to bypass this check and delete the depot."
		public static int MsgDm_DepotHasStreams = ErrorOf(ErrorSubsystem.ES_DM, 751, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NOTYET, 1); //"Depot '%depot%' is the location of existing streams; cannot delete until they are removed."
		public static int MsgDm_ReloadFirst = ErrorOf(ErrorSubsystem.ES_DM, 722, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NOTYET, 1); //"Unload depot %depot% isn't empty of unload files; reload any unloaded clients or labels with 'p4 reload' first. All labels with the 'autoreload' option set must be deleted prior to deleting the unload depot. Remove all non-Perforce files from the depot prior to depot deletion."
		public static int MsgDm_MustForceUnloadDepot = ErrorOf(ErrorSubsystem.ES_DM, 775, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"The Commit Server cannot tell whether unload depot %depot% may still be in use by unloaded clients or labels on one or more Edge Servers. First, reload any unloaded clients or labels at each Edge Server with 'p4 reload'. Next, all labels on each Edge Server with the 'autoreload' option set must be deleted prior to deleting the unload depot. Next, remove all non-Perforce files from the depot prior to depot deletion. Finally, specify -f to bypass this check and force the unload depot deletion."
		public static int MsgDm_LockedUpdate = ErrorOf(ErrorSubsystem.ES_DM, 68, ErrorSeverity.E_FAILED, ErrorGeneric.EV_PROTECT, 3); //"Locked %type% '%name%' owned by '%user%'; use -f to force update."
		public static int MsgDm_LockedDelete = ErrorOf(ErrorSubsystem.ES_DM, 70, ErrorSeverity.E_FAILED, ErrorGeneric.EV_PROTECT, 2); //"%type% '%name%' is locked and can't be deleted."
		public static int MsgDm_OpenedDelete = ErrorOf(ErrorSubsystem.ES_DM, 71, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NOTYET, 1); //"Client '%client%' has files opened. To delete the client, revert any opened files and delete any pending changes first. An administrator may specify -f to force the delete of another user's client."
		public static int MsgDm_OpenedSwitch = ErrorOf(ErrorSubsystem.ES_DM, 607, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NOTYET, 1); //"Client '%client%' has files opened; use -f to force switch."
		public static int MsgDm_OpenedTaskSwitch = ErrorOf(ErrorSubsystem.ES_DM, 743, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NOTYET, 1); //"Client '%client%' has files opened from a task stream; must revert, or revert -k before switching."
		public static int MsgDm_ClassicSwitch = ErrorOf(ErrorSubsystem.ES_DM, 685, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NOTYET, 1); //"Client '%client%' has a static view that will be overwritten; use -f to force switch."
		public static int MsgDm_PendingDelete = ErrorOf(ErrorSubsystem.ES_DM, 447, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NOTYET, 1); //"Client '%client%' has pending changes. To delete the client, delete any pending changes first. An administrator may specify -f to force the delete of another user's client."
		public static int MsgDm_ShelvedDelete = ErrorOf(ErrorSubsystem.ES_DM, 524, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NOTYET, 1); //"Client '%client%' has files shelved; use 'shelve -df' to remove them, and then try again,\nor use 'client -df -Fs' to delete the client and leave the shelved changes intact."
		public static int MsgDm_ShelveNotChanged = ErrorOf(ErrorSubsystem.ES_DM, 688, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%depotFile%%depotRev% - unchanged, not shelved"
		public static int MsgDm_NoSuchGroup = ErrorOf(ErrorSubsystem.ES_DM, 72, ErrorSeverity.E_FAILED, ErrorGeneric.EV_UNKNOWN, 1); //"Group '%group%' doesn't exist."
		public static int MsgDm_NoIntegOverlays = ErrorOf(ErrorSubsystem.ES_DM, 421, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Overlay (+) mappings are not allowed in branch views."
		public static int MsgDm_NoIntegHavemaps = ErrorOf(ErrorSubsystem.ES_DM, 448, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Havemap entries found in non-client view!"
		public static int MsgDm_BadMappedFileName = ErrorOf(ErrorSubsystem.ES_DM, 73, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Branch mapping produced illegal filename."
		public static int MsgDm_JobNameJob = ErrorOf(ErrorSubsystem.ES_DM, 74, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"The job name 'job' is reserved."
		public static int MsgDm_JobDescMissing = ErrorOf(ErrorSubsystem.ES_DM, 75, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"'%field%' field blank.  You must provide it."
		public static int MsgDm_JobHasChanged = ErrorOf(ErrorSubsystem.ES_DM, 434, ErrorSeverity.E_FAILED, ErrorGeneric.EV_UNKNOWN, 0); //"Job has been modified by another user, clear date field to overwrite."
		public static int MsgDm_JobFieldAlways = ErrorOf(ErrorSubsystem.ES_DM, 441, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 2); //"%field% is a read-only always field and can't be changed from '%value%'.\nThe job may have been updated while you were editing."
		public static int MsgDm_BadSpecType = ErrorOf(ErrorSubsystem.ES_DM, 412, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Unknown spec type %type%."
		public static int MsgDm_LameCodes = ErrorOf(ErrorSubsystem.ES_DM, 410, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 3); //"Field codes must be between %low%-%hi% for %type% specs."
		public static int MsgDm_JobFieldReadOnly = ErrorOf(ErrorSubsystem.ES_DM, 77, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 2); //"%field% is read-only and can't be changed from '%value%'."
		public static int MsgDm_MultiWordDefault = ErrorOf(ErrorSubsystem.ES_DM, 78, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"%field% can't have a default multi-word value."
		public static int MsgDm_ProtectedCodes = ErrorOf(ErrorSubsystem.ES_DM, 411, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Builtin field %code% cannot be changed."
		public static int MsgDm_LabelOwner = ErrorOf(ErrorSubsystem.ES_DM, 80, ErrorSeverity.E_FAILED, ErrorGeneric.EV_PROTECT, 2); //"Can't modify label '%label%' owned by '%user%'."
		public static int MsgDm_LabelLocked = ErrorOf(ErrorSubsystem.ES_DM, 81, ErrorSeverity.E_FAILED, ErrorGeneric.EV_PROTECT, 1); //"Can't modify locked label '%label%'.\nUse 'label' to change label options."
		public static int MsgDm_LabelHasRev = ErrorOf(ErrorSubsystem.ES_DM, 438, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NOTYET, 1); //"Label '%label%' has a Revision field and must remain empty."
		public static int MsgDm_WildAdd = ErrorOf(ErrorSubsystem.ES_DM, 82, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Can't add filenames with wildcards [@#%*] in them.\nUse -f option to force add."
		public static int MsgDm_WildAddTripleDots = ErrorOf(ErrorSubsystem.ES_DM, 637, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Can't add filenames containing the ellipsis wildcard (...)."
		public static int MsgDm_InvalidEscape = ErrorOf(ErrorSubsystem.ES_DM, 433, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Target file has illegal escape sequence [%xx]."
		public static int MsgDm_UserOrGroup = ErrorOf(ErrorSubsystem.ES_DM, 83, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Indicator must be 'user' or 'group', not '%value%'."
		public static int MsgDm_CantChangeUser = ErrorOf(ErrorSubsystem.ES_DM, 84, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"User name can't be changed from '%user%'."
		public static int MsgDm_CantChangeUserType = ErrorOf(ErrorSubsystem.ES_DM, 577, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"User type can't be changed."
		public static int MsgDm_Passwd982 = ErrorOf(ErrorSubsystem.ES_DM, 85, ErrorSeverity.E_FAILED, ErrorGeneric.EV_UPGRADE, 0); //"You need a 98.2 or newer client to set a password."
		public static int MsgDm_NoClearText = ErrorOf(ErrorSubsystem.ES_DM, 419, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Passwords can only be set by 'p4 passwd' at this security level."
		public static int MsgDm_WrongUserDelete = ErrorOf(ErrorSubsystem.ES_DM, 86, ErrorSeverity.E_FAILED, ErrorGeneric.EV_PROTECT, 1); //"Not user '%user%'; use -f to force delete."
		public static int MsgDm_DfltBranchView = ErrorOf(ErrorSubsystem.ES_DM, 87, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"You cannot use the default branch view; it is just a sample."
		public static int MsgDm_LabelNoSync = ErrorOf(ErrorSubsystem.ES_DM, 437, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NOTYET, 0); //"The Revision field can only be added to empty labels."
		public static int MsgDm_FixBadVal = ErrorOf(ErrorSubsystem.ES_DM, 88, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Job fix status must be one of %values%."
		public static int MsgDm_ParallelOptions = ErrorOf(ErrorSubsystem.ES_DM, 795, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //
		public static int MsgDm_ParallelNotEnabled = ErrorOf(ErrorSubsystem.ES_DM, 796, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Parallel file transfer must be enabled using net.parallel.max"
		public static int MsgDm_NoClient = ErrorOf(ErrorSubsystem.ES_DM, 89, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 1); //"%clientFile% - can't translate to local path -- no client!"
		public static int MsgDm_NoDepot = ErrorOf(ErrorSubsystem.ES_DM, 90, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 1); //"Can't find %depot% in depot map!"
		public static int MsgDm_NoArchive = ErrorOf(ErrorSubsystem.ES_DM, 91, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 1); //"Can't map %lbrFile% to archive!"
		public static int MsgDm_EmptyRelate = ErrorOf(ErrorSubsystem.ES_DM, 92, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 0); //"RelateMap has empty maps!"
		public static int MsgDm_BadCaller = ErrorOf(ErrorSubsystem.ES_DM, 93, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CONFIG, 0); //"Invalid user (P4USER) or client (P4CLIENT) name."
		public static int MsgDm_DomainIsUnloaded = ErrorOf(ErrorSubsystem.ES_DM, 702, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CONFIG, 2); //"%domainType% %domain% has been unloaded, and must be reloaded to be used."
		public static int MsgDm_NotClientOrLabel = ErrorOf(ErrorSubsystem.ES_DM, 703, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CONFIG, 2); //"%domain% must be a %domainType%."
		public static int MsgDm_NotUnloaded = ErrorOf(ErrorSubsystem.ES_DM, 704, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CONFIG, 1); //"%domain% does not require reloading."
		public static int MsgDm_AlreadyUnloaded = ErrorOf(ErrorSubsystem.ES_DM, 705, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CONFIG, 1); //"%domain% has already been unloaded."
		public static int MsgDm_CantChangeUnloadedOpt = ErrorOf(ErrorSubsystem.ES_DM, 706, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"The autoreload/noautoreload option may not be modified."
		public static int MsgDm_NoUnloadedAutoLabel = ErrorOf(ErrorSubsystem.ES_DM, 717, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"An automatic label may not specify the autoreload option."
		public static int MsgDm_StreamIsUnloaded = ErrorOf(ErrorSubsystem.ES_DM, 748, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CONFIG, 2); //"Client %client% cannot be used with unloaded stream %stream%, switch to another stream or reload it."
		public static int MsgDm_NotAsService = ErrorOf(ErrorSubsystem.ES_DM, 571, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CONFIG, 0); //"Command not allowed for a service user."
		public static int MsgDm_LockedClient = ErrorOf(ErrorSubsystem.ES_DM, 94, ErrorSeverity.E_FAILED, ErrorGeneric.EV_PROTECT, 2); //"Locked client '%client%' can only be used by owner '%user%'."
		public static int MsgDm_LockedHost = ErrorOf(ErrorSubsystem.ES_DM, 95, ErrorSeverity.E_FAILED, ErrorGeneric.EV_PROTECT, 2); //"Client '%client%' can only be used from host '%host%'."
		public static int MsgDm_ClientBoundToServer = ErrorOf(ErrorSubsystem.ES_DM, 672, ErrorSeverity.E_FAILED, ErrorGeneric.EV_PROTECT, 2); //"Client '%client%' is restricted to use on server '%serverID%'."
		public static int MsgDm_NotBoundToServer = ErrorOf(ErrorSubsystem.ES_DM, 762, ErrorSeverity.E_FAILED, ErrorGeneric.EV_PROTECT, 3); //"%objectType% '%objectName%' is not restricted to use on server '%serverID%'."
		public static int MsgDm_BindingNotAllowed = ErrorOf(ErrorSubsystem.ES_DM, 773, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 3); //"%objectType% '%objectName%' should not be restricted to use on server '%serverID%'."
		public static int MsgDm_BoundToOtherServer = ErrorOf(ErrorSubsystem.ES_DM, 761, ErrorSeverity.E_FAILED, ErrorGeneric.EV_PROTECT, 4); //"%objectType% '%objectName%' is restricted to use on server '%domainServerID%', not on server '%serverID%'."
		public static int MsgDm_UnidentifiedServer = ErrorOf(ErrorSubsystem.ES_DM, 670, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Server identity has not been defined, use 'p4d -xD' to specify it."
		public static int MsgDm_TooManyCommitServers = ErrorOf(ErrorSubsystem.ES_DM, 769, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"At most one commit-server may be defined. Server %serverid% is already specified to be a commit-server."
		public static int MsgDm_ServiceNotProvided = ErrorOf(ErrorSubsystem.ES_DM, 671, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Server does not provide this service."
		public static int MsgDm_EmptyFileName = ErrorOf(ErrorSubsystem.ES_DM, 96, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"An empty string is not allowed as a file name."
		public static int MsgDm_NoRev = ErrorOf(ErrorSubsystem.ES_DM, 97, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"A revision specification (# or @) cannot be used here."
		public static int MsgDm_NoRevRange = ErrorOf(ErrorSubsystem.ES_DM, 98, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"A revision range cannot be used here."
		public static int MsgDm_NeedClient = ErrorOf(ErrorSubsystem.ES_DM, 99, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CONFIG, 2); //"%arg% - must create client '%client%' to access local files."
		public static int MsgDm_ReferClient = ErrorOf(ErrorSubsystem.ES_DM, 100, ErrorSeverity.E_FAILED, ErrorGeneric.EV_UNKNOWN, 2); //"%path% - must refer to client '%client%'."
		public static int MsgDm_BadAtRev = ErrorOf(ErrorSubsystem.ES_DM, 101, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ILLEGAL, 1); //"Invalid changelist/client/label/date '@%arg%'."
		public static int MsgDm_BadRevSpec = ErrorOf(ErrorSubsystem.ES_DM, 102, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Unintelligible revision specification '%arg%'."
		public static int MsgDm_BadRevRel = ErrorOf(ErrorSubsystem.ES_DM, 103, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Can't yet do relative operations on '%rev%'."
		public static int MsgDm_BadRevPend = ErrorOf(ErrorSubsystem.ES_DM, 426, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Can't use a pending changelist number for this command."
		public static int MsgDm_ManyRevSpec = ErrorOf(ErrorSubsystem.ES_DM, 436, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Too many revision specifications (max %max%)."
		public static int MsgDm_LabelLoop = ErrorOf(ErrorSubsystem.ES_DM, 455, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Too many automatic labels (label '%label%' may refer to itself)."
		public static int MsgDm_TwistedMap = ErrorOf(ErrorSubsystem.ES_DM, 439, ErrorSeverity.E_FAILED, ErrorGeneric.EV_TOOBIG, 0); //"Client map too twisted for directory list."
		public static int MsgDm_EmptyResults = ErrorOf(ErrorSubsystem.ES_DM, 104, ErrorSeverity.E_WARN, ErrorGeneric.EV_EMPTY, 1); //"%reason%."
		public static int MsgDm_LimitBadArg = ErrorOf(ErrorSubsystem.ES_DM, 625, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"%path% - must refer to a local depot in depot syntax."
		public static int MsgDm_NoDelete = ErrorOf(ErrorSubsystem.ES_DM, 105, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 1); //"%path% - can't delete remote file!"
		public static int MsgDm_NoCheckin = ErrorOf(ErrorSubsystem.ES_DM, 106, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 1); //"%path% - can't checkin remote file!"
		public static int MsgDm_RmtError = ErrorOf(ErrorSubsystem.ES_DM, 107, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 1); //"%text%"
		public static int MsgDm_TooOld = ErrorOf(ErrorSubsystem.ES_DM, 108, ErrorSeverity.E_FAILED, ErrorGeneric.EV_UPGRADE, 0); //"Remote server is too old to support remote access.  Install a new server."
		public static int MsgDm_DbFailed = ErrorOf(ErrorSubsystem.ES_DM, 109, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 1); //"Remote depot '%depot%' database access failed."
		public static int MsgDm_ArchiveFailed = ErrorOf(ErrorSubsystem.ES_DM, 110, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 1); //"Remote depot '%depot%' archive access failed."
		public static int MsgDm_NoRmtInterop = ErrorOf(ErrorSubsystem.ES_DM, 111, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ADMIN, 0); //"Remote depot access is not supported between UNIX and NT prior to 99.2."
		public static int MsgDm_RmtAuthFailed = ErrorOf(ErrorSubsystem.ES_DM, 124, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 0); //"Remote authorization server access failed."
		public static int MsgDm_RmtAddChangeFailed = ErrorOf(ErrorSubsystem.ES_DM, 783, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 1); //"Commit server access failed while trying to add change %change%."
		public static int MsgDm_RmtDeleteChangeFailed = ErrorOf(ErrorSubsystem.ES_DM, 784, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 1); //"Commit server access failed while trying to delete change %change%."
		public static int MsgDm_RemoteChangeExists = ErrorOf(ErrorSubsystem.ES_DM, 785, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 1); //"Change %change% already exists in this installation."
		public static int MsgDm_RemoteChangeMissing = ErrorOf(ErrorSubsystem.ES_DM, 786, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 1); //"There is no change %change% in this installation."
		public static int MsgDm_ChangeNotShelved = ErrorOf(ErrorSubsystem.ES_DM, 787, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 1); //"%change% is not currently shelved."
		public static int MsgDm_RmtAddDomainFailed = ErrorOf(ErrorSubsystem.ES_DM, 757, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 1); //"Commit server access failed while trying to add a domain named %domainName%."
		public static int MsgDm_RmtDeleteDomainFailed = ErrorOf(ErrorSubsystem.ES_DM, 754, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 1); //"Commit server access failed while trying to delete a domain named %domainName%."
		public static int MsgDm_RmtExclusiveLockFailed = ErrorOf(ErrorSubsystem.ES_DM, 758, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 0); //"Commit server access failed while trying to get/release exclusive (+l) filetype."
		public static int MsgDm_RemoteDomainExists = ErrorOf(ErrorSubsystem.ES_DM, 755, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 1); //"A domain named %domainName% already exists in this installation."
		public static int MsgDm_RemoteDomainMissing = ErrorOf(ErrorSubsystem.ES_DM, 756, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 1); //"There is no domain named %domainName% in this installation."
		public static int MsgDm_ServiceUserLogin = ErrorOf(ErrorSubsystem.ES_DM, 720, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 0); //"Remote server refused request. Please verify that service user is correctly logged in to remote server, then retry."
		public static int MsgDm_RmtSequenceFailed = ErrorOf(ErrorSubsystem.ES_DM, 482, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 1); //"Remote '%counter%' counter update failed."
		public static int MsgDm_OutOfSequence = ErrorOf(ErrorSubsystem.ES_DM, 483, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 2); //"Sequence error:  local 'change' counter '%local%' vs remote '%remote%'!"
		public static int MsgDm_ChangeExists = ErrorOf(ErrorSubsystem.ES_DM, 484, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 1); //"Sequence error:  next changelist '%change%' already exists!"
		public static int MsgDm_RmtJournalWaitFailed = ErrorOf(ErrorSubsystem.ES_DM, 651, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 0); //"Remote journalwait failed!"
		public static int MsgDm_NoRevisionOverwrite = ErrorOf(ErrorSubsystem.ES_DM, 741, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 2); //"Revision %depotFile%#%depotRev% already exists! A submit operation attempted to overwrite this revision with a new file at the same revision. This should never happen, and therefore the server has aborted the submit. It is possible that the Perforce database files have been corrupted by a disk failure, system crash, or improper restore operation. Please contact Perforce technical support for assistance. Please do not perform any further operations on the server until the problem can be resolved. Please save all server logs, journals, and database tables for use in determining the necessary recovery operations."
		public static int MsgDm_BadTemplate = ErrorOf(ErrorSubsystem.ES_DM, 112, ErrorSeverity.E_FATAL, ErrorGeneric.EV_ADMIN, 1); //"%key% spec template unusable!"
		public static int MsgDm_FieldMissing = ErrorOf(ErrorSubsystem.ES_DM, 113, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Field %field% missing from form."
		public static int MsgDm_NoNotOp = ErrorOf(ErrorSubsystem.ES_DM, 114, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Can't handle ^ (not) operator there."
		public static int MsgDm_SameCode = ErrorOf(ErrorSubsystem.ES_DM, 116, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 2); //"Fields '%field%' and '%field2%' have the same code."
		public static int MsgDm_SameTag = ErrorOf(ErrorSubsystem.ES_DM, 413, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 2); //"Fields '%field%' and '%field2%' have the same tag."
		public static int MsgDm_NoDefault = ErrorOf(ErrorSubsystem.ES_DM, 117, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 2); //"Field '%field%' needs a preset value to be type '%opt%'."
		public static int MsgDm_SemiInDefault = ErrorOf(ErrorSubsystem.ES_DM, 118, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Default for '%field%' can't have ;'s in it."
		public static int MsgDm_LicensedClients = ErrorOf(ErrorSubsystem.ES_DM, 119, ErrorSeverity.E_INFO, ErrorGeneric.EV_ADMIN, 2); //"License count: %count% clients used of %max% licensed."
		public static int MsgDm_LicensedUsers = ErrorOf(ErrorSubsystem.ES_DM, 120, ErrorSeverity.E_INFO, ErrorGeneric.EV_ADMIN, 2); //"License count: %count% users used of %max% licensed."
		public static int MsgDm_TryDelClient = ErrorOf(ErrorSubsystem.ES_DM, 121, ErrorSeverity.E_INFO, ErrorGeneric.EV_ADMIN, 0); //"Try deleting old clients with 'client -d'."
		public static int MsgDm_TryDelUser = ErrorOf(ErrorSubsystem.ES_DM, 122, ErrorSeverity.E_INFO, ErrorGeneric.EV_ADMIN, 0); //"Try deleting old users with 'user -d'."
		public static int MsgDm_TooManyRoots = ErrorOf(ErrorSubsystem.ES_DM, 123, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Too many client root alternatives -- only 2 allowed."
		public static int MsgDm_TryEvalLicense = ErrorOf(ErrorSubsystem.ES_DM, 470, ErrorSeverity.E_INFO, ErrorGeneric.EV_ADMIN, 0); //"\nAdditional users/clients may be obtained for\nevaluation purposes by visiting...\n\nhttp://www.perforce.com/eval\n"
		public static int MsgDm_AnnotateTooBig = ErrorOf(ErrorSubsystem.ES_DM, 572, ErrorSeverity.E_FAILED, ErrorGeneric.EV_TOOBIG, 1); //"File size exceeds dm.annotate.maxsize (%maxSize% bytes)."
		public static int MsgDm_NotBucket = ErrorOf(ErrorSubsystem.ES_DM, 558, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"%depot% is not an archive depot."
		public static int MsgDm_BucketAdd = ErrorOf(ErrorSubsystem.ES_DM, 559, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"Archiving %depotFile%%depotRev% to %archiveFile%."
		public static int MsgDm_BucketRestore = ErrorOf(ErrorSubsystem.ES_DM, 560, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"Restoring %depotFile%%depotRev% from %archiveFile%."
		public static int MsgDm_BucketPurge = ErrorOf(ErrorSubsystem.ES_DM, 561, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"Purged %depotFile%%depotRev%."
		public static int MsgDm_BucketSkipHead = ErrorOf(ErrorSubsystem.ES_DM, 562, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"Not archiving %depotFile%%depotRev%: head revision."
		public static int MsgDm_BucketSkipLazy = ErrorOf(ErrorSubsystem.ES_DM, 563, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"Not archiving %depotFile%%depotRev%: lazy copy."
		public static int MsgDm_BucketSkipBranched = ErrorOf(ErrorSubsystem.ES_DM, 564, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"Not archiving %depotFile%%depotRev%: content used elsewhere."
		public static int MsgDm_BucketSkipBucketed = ErrorOf(ErrorSubsystem.ES_DM, 585, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"Not archiving %depotFile%%depotRev%: trait 'archiveBucket' has been set."
		public static int MsgDm_BucketSkipType = ErrorOf(ErrorSubsystem.ES_DM, 565, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"Not archiving %depotFile%%depotRev%: stored in delta format (+D)."
		public static int MsgDm_BucketNoFilesToArchive = ErrorOf(ErrorSubsystem.ES_DM, 566, ErrorSeverity.E_WARN, ErrorGeneric.EV_USAGE, 1); //"[%argc% - no|No] revisions can be archived."
		public static int MsgDm_BucketNoFilesToRestore = ErrorOf(ErrorSubsystem.ES_DM, 567, ErrorSeverity.E_WARN, ErrorGeneric.EV_USAGE, 1); //"[%argc% - no|No] revisions can be restored."
		public static int MsgDm_BucketNoFilesToPurge = ErrorOf(ErrorSubsystem.ES_DM, 568, ErrorSeverity.E_WARN, ErrorGeneric.EV_USAGE, 1); //"[%argc% - no|No] revisions can be purged."
		public static int MsgDm_CachePurgeFile = ErrorOf(ErrorSubsystem.ES_DM, 791, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"Purging content of %lbrFile% %lbrRev% size %archiveSize%."
		public static int MsgDm_ChangeCreated = ErrorOf(ErrorSubsystem.ES_DM, 200, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"%change% created[ with %workCount% open file(s)][ fixing %jobCount% job(s)]."
		public static int MsgDm_ChangeUpdated = ErrorOf(ErrorSubsystem.ES_DM, 201, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 5); //"%change% updated[, adding %workCount% file(s)][, removing %workCount2% file(s)][, adding %jobCount% fix(es)][, removing %jobCount2% fix(es)]."
		public static int MsgDm_ChangeDeleteOpen = ErrorOf(ErrorSubsystem.ES_DM, 202, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%change% has %count% open file(s) associated with it and can't be deleted."
		public static int MsgDm_ChangeDeleteHasFix = ErrorOf(ErrorSubsystem.ES_DM, 203, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%change% has %count% fixes associated with it and can't be deleted."
		public static int MsgDm_ChangeDeleteHasFiles = ErrorOf(ErrorSubsystem.ES_DM, 204, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%change% has %count% files associated with it and can't be deleted."
		public static int MsgDm_ChangeDeleteShelved = ErrorOf(ErrorSubsystem.ES_DM, 517, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CONTEXT, 1); //"%change% has shelved files associated with it and can't be deleted."
		public static int MsgDm_ChangeDeleteSuccess = ErrorOf(ErrorSubsystem.ES_DM, 205, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"%change% deleted."
		public static int MsgDm_ChangeNotOwner = ErrorOf(ErrorSubsystem.ES_DM, 468, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 2); //"%change% can only be updated by user %user%."
		public static int MsgDm_CommittedNoPerm = ErrorOf(ErrorSubsystem.ES_DM, 573, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 2); //"%change% can only be updated by user %user% with -u, or by admin user with -f."
		public static int MsgDm_PendingNoPerm = ErrorOf(ErrorSubsystem.ES_DM, 574, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 2); //"%change% can only be updated by user %user%, or by admin user with -f."
		public static int MsgDm_PropertyData = ErrorOf(ErrorSubsystem.ES_DM, 731, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //
		public static int MsgDm_PropertyDataUser = ErrorOf(ErrorSubsystem.ES_DM, 732, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //
		public static int MsgDm_PropertyDataGroup = ErrorOf(ErrorSubsystem.ES_DM, 733, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //
		public static int MsgDm_NoSuchProperty = ErrorOf(ErrorSubsystem.ES_DM, 734, ErrorSeverity.E_FAILED, ErrorGeneric.EV_UNKNOWN, 4); //"No such property '%settingName%' sequence %settingSequence% user %settingUser% group %settingGroup%."
		public static int MsgDm_PropertyAllData = ErrorOf(ErrorSubsystem.ES_DM, 774, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 5); //
		public static int MsgDm_BadSequence = ErrorOf(ErrorSubsystem.ES_DM, 747, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Invalid sequence number '%seq%'."
		public static int MsgDm_ExPROPERTY = ErrorOf(ErrorSubsystem.ES_DM, 735, ErrorSeverity.E_WARN, ErrorGeneric.EV_EMPTY, 1); //"[%settingName% - no|No] such property."
		public static int MsgDm_ChangesData = ErrorOf(ErrorSubsystem.ES_DM, 206, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 5); //"%change% on %date% by %user%@%client%%description%"
		public static int MsgDm_ChangesDataPending = ErrorOf(ErrorSubsystem.ES_DM, 207, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 5); //"%change% on %date% by %user%@%client% *pending*%description%"
		public static int MsgDm_ConfigData = ErrorOf(ErrorSubsystem.ES_DM, 545, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //
		public static int MsgDm_NoSuchConfig = ErrorOf(ErrorSubsystem.ES_DM, 546, ErrorSeverity.E_FAILED, ErrorGeneric.EV_UNKNOWN, 1); //"No such configuration variable '%config%'."
		public static int MsgDm_ConfigWasNotSet = ErrorOf(ErrorSubsystem.ES_DM, 547, ErrorSeverity.E_FAILED, ErrorGeneric.EV_UNKNOWN, 1); //"Configuration variable '%config%' did not have a value."
		public static int MsgDm_UseConfigure = ErrorOf(ErrorSubsystem.ES_DM, 548, ErrorSeverity.E_FAILED, ErrorGeneric.EV_UNKNOWN, 0); //
		public static int MsgDm_CopyOpenTarget = ErrorOf(ErrorSubsystem.ES_DM, 569, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ILLEGAL, 0); //"Can't copy to target path with files already open."
		public static int MsgDm_CopyMoveMapFrom = ErrorOf(ErrorSubsystem.ES_DM, 778, ErrorSeverity.E_INFO, ErrorGeneric.EV_USAGE, 1); //"can't open as move/add because %movedFrom% is not mapped correctly."
		public static int MsgDm_CopyMoveNoFrom = ErrorOf(ErrorSubsystem.ES_DM, 779, ErrorSeverity.E_INFO, ErrorGeneric.EV_USAGE, 1); //"can't open as move/add because %movedFrom% is not being opened for delete."
		public static int MsgDm_CopyMoveExTo = ErrorOf(ErrorSubsystem.ES_DM, 780, ErrorSeverity.E_INFO, ErrorGeneric.EV_USAGE, 0); //"can't open as move/add because a file already exists in this location."
		public static int MsgDm_CopyMapSummary = ErrorOf(ErrorSubsystem.ES_DM, 781, ErrorSeverity.E_WARN, ErrorGeneric.EV_NONE, 0); //"Some files couldn't be opened for move.  Try expanding the mapping?"
		public static int MsgDm_CopyChangeSummary = ErrorOf(ErrorSubsystem.ES_DM, 782, ErrorSeverity.E_WARN, ErrorGeneric.EV_NONE, 1); //"Some files couldn't be opened for move.[  Try copying from @%change% instead?]"
		public static int MsgDm_CountersData = ErrorOf(ErrorSubsystem.ES_DM, 208, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //
		public static int MsgDm_DeleteMoved = ErrorOf(ErrorSubsystem.ES_DM, 627, ErrorSeverity.E_WARN, ErrorGeneric.EV_NONE, 1); //"%clientFile% - can't delete moved file; must undo move first"
		public static int MsgDm_DirsData = ErrorOf(ErrorSubsystem.ES_DM, 209, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"%dirName%"
		public static int MsgDm_DepotSave = ErrorOf(ErrorSubsystem.ES_DM, 210, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Depot %depotName% saved."
		public static int MsgDm_DepotNoChange = ErrorOf(ErrorSubsystem.ES_DM, 211, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Depot %depotName% not changed."
		public static int MsgDm_DepotDelete = ErrorOf(ErrorSubsystem.ES_DM, 212, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Depot %depotName% deleted."
		public static int MsgDm_DepotSpecDup = ErrorOf(ErrorSubsystem.ES_DM, 420, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CONTEXT, 1); //"There is already a spec depot called '%depot%'."
		public static int MsgDm_DepotUnloadDup = ErrorOf(ErrorSubsystem.ES_DM, 701, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CONTEXT, 1); //"There is already an unload depot called '%depot%'."
		public static int MsgDm_NoDepotTypeChange = ErrorOf(ErrorSubsystem.ES_DM, 618, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ILLEGAL, 0); //"Depot type cannot be changed."
		public static int MsgDm_DepotMapInvalid = ErrorOf(ErrorSubsystem.ES_DM, 442, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Map entry '%map%' must have only 1 wildcard which must be a trailing '/...' or '\\...'."
		public static int MsgDm_DepotNotStream = ErrorOf(ErrorSubsystem.ES_DM, 507, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NONE, 1); //"Depot type for '%depot%' must be 'stream'."
		public static int MsgDm_DepotNotSpec = ErrorOf(ErrorSubsystem.ES_DM, 675, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NONE, 0); //"SpecMap entries may only be added for a depot of type 'spec'."
		public static int MsgDm_ImportNotUnder = ErrorOf(ErrorSubsystem.ES_DM, 544, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CONTEXT, 1); //"Import path '%depotFile%' is not under an accessible depot."
		public static int MsgDm_InvalidParent = ErrorOf(ErrorSubsystem.ES_DM, 542, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CONTEXT, 1); //"Invalid parent field '%parent%'. Check stream, parent and type."
		public static int MsgDm_StreamOverflow = ErrorOf(ErrorSubsystem.ES_DM, 549, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Stream hierarchy in endless loop!"
		public static int MsgDm_NoStreamAtChange = ErrorOf(ErrorSubsystem.ES_DM, 550, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CONTEXT, 2); //"No stream '%stream%' existed at change %change%"
		public static int MsgDm_NotStreamReady = ErrorOf(ErrorSubsystem.ES_DM, 557, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Client '%client%' requires an application that can fully support streams."
		public static int MsgDm_MissingStream = ErrorOf(ErrorSubsystem.ES_DM, 575, ErrorSeverity.E_FAILED, ErrorGeneric.EV_UNKNOWN, 2); //"Missing stream '%name%' in stream hierarchy for '%stream%'."
		public static int MsgDm_InvalidStreamFmt = ErrorOf(ErrorSubsystem.ES_DM, 576, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NONE, 1); //"Stream '%stream%' is not the correct format of '//depotname/string' "
		public static int MsgDm_StreamPathRooted = ErrorOf(ErrorSubsystem.ES_DM, 578, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NONE, 1); //"View '%view%' must be relative and not contain leading slashes "
		public static int MsgDm_StreamPathSlash = ErrorOf(ErrorSubsystem.ES_DM, 579, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NONE, 1); //"Imported path '%view%' requires leading slashes in full depot path "
		public static int MsgDm_StreamHasChildren = ErrorOf(ErrorSubsystem.ES_DM, 580, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NOTYET, 1); //"Stream '%stream%' has child streams; cannot delete until they are removed."
		public static int MsgDm_StreamHasClients = ErrorOf(ErrorSubsystem.ES_DM, 581, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NOTYET, 1); //"Stream '%stream%' has active clients; cannot delete until they are removed."
		public static int MsgDm_StreamIncompatibleP = ErrorOf(ErrorSubsystem.ES_DM, 583, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CONTEXT, 4); //"Stream '%stream%' (%type%) not compatible with Parent %parent% (%parentType%); use -u to force update."
		public static int MsgDm_StreamIncompatibleC = ErrorOf(ErrorSubsystem.ES_DM, 584, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CONTEXT, 3); //"Stream '%stream%' (%oldType% -> %type%) not compatible with child streams; use -u to force update."
		public static int MsgDm_StreamOwnerUpdate = ErrorOf(ErrorSubsystem.ES_DM, 586, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NONE, 2); //"Stream '%stream%' owner '%owner%' required for -u force update."
		public static int MsgDm_StreamIsMainline = ErrorOf(ErrorSubsystem.ES_DM, 630, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Stream '%name%' has no parent, therefore (command not allowed)."
		public static int MsgDm_StreamNoFlow = ErrorOf(ErrorSubsystem.ES_DM, 680, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CONTEXT, 1); //"Stream '%stream%' type of virtual cannot have 'toparent' or 'fromparent' options set."
		public static int MsgDm_StreamIsVirtual = ErrorOf(ErrorSubsystem.ES_DM, 681, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Stream '%name%' is a virtual stream (command not allowed)."
		public static int MsgDm_StreamNoReparent = ErrorOf(ErrorSubsystem.ES_DM, 729, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NONE, 3); //"Cannot change Parent '%parent%' in %type% stream '%stream%'."
		public static int MsgDm_StreamNoConvert = ErrorOf(ErrorSubsystem.ES_DM, 736, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Cannot convert '%type%' stream to 'task' stream."
		public static int MsgDm_StreamConverted = ErrorOf(ErrorSubsystem.ES_DM, 738, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"Stream '%name%' converted from 'task' to '%type%'."
		public static int MsgDm_StreamParentIsTask = ErrorOf(ErrorSubsystem.ES_DM, 739, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Parent stream '%name%' is a task stream, child streams not allowed."
		public static int MsgDm_StreamBadConvert = ErrorOf(ErrorSubsystem.ES_DM, 740, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Cannot convert 'task' stream to '%type%' - parent from different depot."
		public static int MsgDm_DepotsData = ErrorOf(ErrorSubsystem.ES_DM, 213, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 6); //"%type% %depotName% %updateDate% %location% %map% '%description%'"
		public static int MsgDm_DepotsDataExtra = ErrorOf(ErrorSubsystem.ES_DM, 214, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 7); //"%type% %depotName% %updateDate% %location% %address% %map% '%description%'"
		public static int MsgDm_ServerSave = ErrorOf(ErrorSubsystem.ES_DM, 661, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Server %serverName% saved."
		public static int MsgDm_ServerNoChange = ErrorOf(ErrorSubsystem.ES_DM, 662, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Server %serverName% not changed."
		public static int MsgDm_ServerDelete = ErrorOf(ErrorSubsystem.ES_DM, 663, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Server %serverName% deleted."
		public static int MsgDm_NoSuchServer = ErrorOf(ErrorSubsystem.ES_DM, 664, ErrorSeverity.E_FAILED, ErrorGeneric.EV_UNKNOWN, 1); //"Server '%server%' doesn't exist."
		public static int MsgDm_ServersData = ErrorOf(ErrorSubsystem.ES_DM, 665, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 6); //"%serverID% %type% %name% %address% %services% '%description%'"
		public static int MsgDm_ServerTypeMismatch = ErrorOf(ErrorSubsystem.ES_DM, 719, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CONTEXT, 0); //"Server type is not appropriate for specified server services."
		public static int MsgDm_ServerViewMap = ErrorOf(ErrorSubsystem.ES_DM, 745, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CONTEXT, 0); //"This type of view mapping may not be provided for this server."
		public static int MsgDm_FiltersReplicaOnly = ErrorOf(ErrorSubsystem.ES_DM, 746, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CONTEXT, 0); //"Data Filters should be specified only for replica servers."
		public static int MsgDm_DescribeChange = ErrorOf(ErrorSubsystem.ES_DM, 215, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 5); //"%change% by %user%@%client% on %date%%description%"
		public static int MsgDm_DescribeChangePending = ErrorOf(ErrorSubsystem.ES_DM, 216, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 5); //"%change% by %user%@%client% on %date% *pending*%description%"
		public static int MsgDm_DescribeData = ErrorOf(ErrorSubsystem.ES_DM, 217, ErrorSeverity.E_INFO, ErrorGeneric.EV_USAGE, 3); //"%depotFile%%depotRev% %action%"
		public static int MsgDm_DescribeMove = ErrorOf(ErrorSubsystem.ES_DM, 495, ErrorSeverity.E_INFO, ErrorGeneric.EV_USAGE, 4); //"%depotFile%%depotRev% moved from %depotFile2%%depotRev2%"
		public static int MsgDm_DescribeDiff = ErrorOf(ErrorSubsystem.ES_DM, 218, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 4); //
		public static int MsgDm_DiffData = ErrorOf(ErrorSubsystem.ES_DM, 219, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 4); //
		public static int MsgDm_Diff2DataLeft = ErrorOf(ErrorSubsystem.ES_DM, 220, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //
		public static int MsgDm_Diff2DataRight = ErrorOf(ErrorSubsystem.ES_DM, 221, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //
		public static int MsgDm_Diff2DataRightPre041 = ErrorOf(ErrorSubsystem.ES_DM, 423, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //
		public static int MsgDm_Diff2DataContent = ErrorOf(ErrorSubsystem.ES_DM, 222, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 6); //
		public static int MsgDm_Diff2DataTypes = ErrorOf(ErrorSubsystem.ES_DM, 223, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 6); //
		public static int MsgDm_Diff2DataIdentical = ErrorOf(ErrorSubsystem.ES_DM, 224, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 6); //
		public static int MsgDm_Diff2DataUnified = ErrorOf(ErrorSubsystem.ES_DM, 225, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 4); //"--- %depotFile%\t%depotDate%\n+++ %depotFile2%\t%depotDate2%"
		public static int MsgDm_Diff2DataUnifiedDiffer = ErrorOf(ErrorSubsystem.ES_DM, 471, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 4); //"Binary files %depotFile%%depotRev% and %depotFile2%%depotRev2% differ"
		public static int MsgDm_DomainSave = ErrorOf(ErrorSubsystem.ES_DM, 226, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%domainType% %domainName% saved."
		public static int MsgDm_DomainNoChange = ErrorOf(ErrorSubsystem.ES_DM, 227, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%domainType% %domainName% not changed."
		public static int MsgDm_DomainDelete = ErrorOf(ErrorSubsystem.ES_DM, 228, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%domainType% %domainName% deleted."
		public static int MsgDm_DomainSwitch = ErrorOf(ErrorSubsystem.ES_DM, 608, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%domainType% %domainName% switched."
		public static int MsgDm_DomainsDataClient = ErrorOf(ErrorSubsystem.ES_DM, 229, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 5); //"%domainType% %domainName% %updateDate% root %domainMount% '%description%'"
		public static int MsgDm_DomainsData = ErrorOf(ErrorSubsystem.ES_DM, 230, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 4); //"%domainType% %domainName% %updateDate% '%description%'"
		public static int MsgDm_DupOK = ErrorOf(ErrorSubsystem.ES_DM, 462, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 4); //"%file%%rev% duplicated from %file2%%rev2%"
		public static int MsgDm_DupExists = ErrorOf(ErrorSubsystem.ES_DM, 463, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%file%%rev% already exists"
		public static int MsgDm_DupLocked = ErrorOf(ErrorSubsystem.ES_DM, 464, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 4); //"%file%%rev% is opened for %action% on client %client%"
		public static int MsgDm_FilelogData = ErrorOf(ErrorSubsystem.ES_DM, 231, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"%depotFile%"
		public static int MsgDm_FilelogRevDefault = ErrorOf(ErrorSubsystem.ES_DM, 232, ErrorSeverity.E_INFO, ErrorGeneric.EV_USAGE, 4); //"%depotRev% %change% %action% on %date%"
		public static int MsgDm_FilelogRevMessage = ErrorOf(ErrorSubsystem.ES_DM, 233, ErrorSeverity.E_INFO, ErrorGeneric.EV_USAGE, 8); //"%depotRev% %change% %action% on %date% by %user%@%client% (%type%)%description%"
		public static int MsgDm_FilelogInteg = ErrorOf(ErrorSubsystem.ES_DM, 234, ErrorSeverity.E_INFO, ErrorGeneric.EV_UNKNOWN, 3); //"%how% %fromFile%%fromRev%"
		public static int MsgDm_FilesData = ErrorOf(ErrorSubsystem.ES_DM, 235, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 5); //"%depotFile%%depotRev% - %action% %change% (%type%)"
		public static int MsgDm_FilesSummary = ErrorOf(ErrorSubsystem.ES_DM, 446, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 4); //"%path% %fileCount% files %fileSize% bytes [%blockCount% blocks]"
		public static int MsgDm_FilesDiskUsage = ErrorOf(ErrorSubsystem.ES_DM, 454, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 4); //"%depotFile%%depotRev% %fileSize% bytes [%blockCount% blocks]"
		public static int MsgDm_FilesSummaryHuman = ErrorOf(ErrorSubsystem.ES_DM, 788, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 4); //"%path% %fileCount% files %fileSize% [%blockCount% blocks]"
		public static int MsgDm_FilesDiskUsageHuman = ErrorOf(ErrorSubsystem.ES_DM, 789, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 4); //"%depotFile%%depotRev% %fileSize% [%blockCount% blocks]"
		public static int MsgDm_FixAdd = ErrorOf(ErrorSubsystem.ES_DM, 236, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"%job% fixed by %change% (%status%)."
		public static int MsgDm_FixDelete = ErrorOf(ErrorSubsystem.ES_DM, 238, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"Deleted fix %job% by %change%."
		public static int MsgDm_FixesData = ErrorOf(ErrorSubsystem.ES_DM, 239, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 6); //"%job% fixed by %change% on %date% by %user%@%client% (%status%)"
		public static int MsgDm_GrepOutput = ErrorOf(ErrorSubsystem.ES_DM, 531, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 4); //"%depotFile%#%depotRev%%separator%%linecontent%"
		public static int MsgDm_GrepFileOutput = ErrorOf(ErrorSubsystem.ES_DM, 532, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%depotFile%#%depotRev%"
		public static int MsgDm_GrepWithLineNumber = ErrorOf(ErrorSubsystem.ES_DM, 533, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 6); //"%depotFile%#%depotRev%%separator1%%linenumber%%separator2%%linecontent%"
		public static int MsgDm_GrepLineTooLong = ErrorOf(ErrorSubsystem.ES_DM, 534, ErrorSeverity.E_WARN, ErrorGeneric.EV_NONE, 4); //"%depotFile%#%depotRev% - line %linenumber%: maximum line length of %maxlinelength% exceeded"
		public static int MsgDm_GrepMaxRevs = ErrorOf(ErrorSubsystem.ES_DM, 535, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Grep revision limit exceeded (over %maxRevs%)."
		public static int MsgDm_GrepSeparator = ErrorOf(ErrorSubsystem.ES_DM, 536, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"--"
		public static int MsgDm_GroupCreated = ErrorOf(ErrorSubsystem.ES_DM, 241, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Group %group% created."
		public static int MsgDm_GroupNotCreated = ErrorOf(ErrorSubsystem.ES_DM, 242, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Group %group% not created."
		public static int MsgDm_GroupDeleted = ErrorOf(ErrorSubsystem.ES_DM, 243, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Group %group% deleted."
		public static int MsgDm_GroupNotUpdated = ErrorOf(ErrorSubsystem.ES_DM, 244, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Group %group% not updated."
		public static int MsgDm_GroupUpdated = ErrorOf(ErrorSubsystem.ES_DM, 245, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Group %group% updated."
		public static int MsgDm_GroupNotOwner = ErrorOf(ErrorSubsystem.ES_DM, 472, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NONE, 2); //"User '%user%' is not an owner of group '%group%'."
		public static int MsgDm_GroupExists = ErrorOf(ErrorSubsystem.ES_DM, 718, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NONE, 1); //"No permission to modify existing group %group%."
		public static int MsgDm_GroupsData = ErrorOf(ErrorSubsystem.ES_DM, 246, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"%group%"
		public static int MsgDm_GroupsDataVerbose = ErrorOf(ErrorSubsystem.ES_DM, 474, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 5); //"%group% %maxresults% %maxscanrows% %maxtimeout% %timeout%"
		public static int MsgDm_HaveData = ErrorOf(ErrorSubsystem.ES_DM, 247, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"%depotFile%%haveRev% - %lp%"
		public static int MsgDm_IntegAlreadyOpened = ErrorOf(ErrorSubsystem.ES_DM, 250, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%depotFile% - can't %action% (already opened on this client)"
		public static int MsgDm_IntegIntoReadOnly = ErrorOf(ErrorSubsystem.ES_DM, 251, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%depotFile% - can only %action% into file in a local depot"
		public static int MsgDm_IntegXOpened = ErrorOf(ErrorSubsystem.ES_DM, 252, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%depotFile% - can't %action% exclusive file already opened"
		public static int MsgDm_IntegBadAncestor = ErrorOf(ErrorSubsystem.ES_DM, 253, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 5); //"%depotFile% - can't %action% from %fromFile%%fromRev% without -d or %flag% flag"
		public static int MsgDm_IntegBadBase = ErrorOf(ErrorSubsystem.ES_DM, 254, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 4); //"%depotFile% - can't %action% from %fromFile%%fromRev% without -i flag"
		public static int MsgDm_IntegBadAction = ErrorOf(ErrorSubsystem.ES_DM, 255, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 4); //"%depotFile% - can't %action% (already opened for %badAction%)[ (remapped from %movedFrom%)]"
		public static int MsgDm_IntegBadClient = ErrorOf(ErrorSubsystem.ES_DM, 256, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%depotFile% - is already opened by client %client%"
		public static int MsgDm_IntegBadUser = ErrorOf(ErrorSubsystem.ES_DM, 257, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%depotFile% - is already opened by user %user%"
		public static int MsgDm_IntegCantAdd = ErrorOf(ErrorSubsystem.ES_DM, 258, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%depotFile% - can't %action% existing file"
		public static int MsgDm_IntegCantModify = ErrorOf(ErrorSubsystem.ES_DM, 259, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%depotFile% - can't %action% deleted file"
		public static int MsgDm_IntegMustSync = ErrorOf(ErrorSubsystem.ES_DM, 260, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"%toFile% - must sync before integrating."
		public static int MsgDm_IntegOpenOkayBase = ErrorOf(ErrorSubsystem.ES_DM, 424, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 8); //"%depotFile%%workRev% - %action% from %fromFile%%fromRev%[ using base %baseFile%][%baseRev%][ (remapped from %remappedFrom%)]"
		public static int MsgDm_IntegSyncBranch = ErrorOf(ErrorSubsystem.ES_DM, 262, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 5); //"%depotFile%%workRev% - %action%/sync from %fromFile%%fromRev%"
		public static int MsgDm_IntegSyncIntegBase = ErrorOf(ErrorSubsystem.ES_DM, 427, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 8); //"%depotFile%%workRev% - sync/%action% from %fromFile%%fromRev%[ using base %baseFile%][%baseRev%][ (remapped from %remappedFrom%)]"
		public static int MsgDm_IntegNotHandled = ErrorOf(ErrorSubsystem.ES_DM, 264, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"%depotFile%%workRev% - flag %flag% not handled!"
		public static int MsgDm_IntegTooVirtual = ErrorOf(ErrorSubsystem.ES_DM, 449, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%depotFile% - can't %action% file branched with integrate -v"
		public static int MsgDm_IntegIncompatable = ErrorOf(ErrorSubsystem.ES_DM, 461, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%depotFile% - file type of %fromFile% incompatible"
		public static int MsgDm_IntegMovedUnmapped = ErrorOf(ErrorSubsystem.ES_DM, 551, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%depotFile% - not in client view (remapped from %movedFrom%)"
		public static int MsgDm_IntegMovedNoAccess = ErrorOf(ErrorSubsystem.ES_DM, 552, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%depotFile% - no permission (remapped from %movedFrom%)"
		public static int MsgDm_IntegMovedOutScope = ErrorOf(ErrorSubsystem.ES_DM, 556, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%depotFile% - not in branch view (remapped from %movedFrom%)"
		public static int MsgDm_IntegMovedNoFrom = ErrorOf(ErrorSubsystem.ES_DM, 721, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 5); //"%depotFile% - can't %action% from %fromFile%%fromRev% (moved from %movedFrom%; provide a branch view that maps this file, or use -Di to disregard move/deletes)"
		public static int MsgDm_IntegMovedNoFromS = ErrorOf(ErrorSubsystem.ES_DM, 759, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 5); //"%depotFile% - can't %action% from %fromFile%%fromRev% (moved from %movedFrom%; provide a branch/stream view that maps this file, or use 'p4 copy' to force)"
		public static int MsgDm_IntegBaselessMove = ErrorOf(ErrorSubsystem.ES_DM, 682, ErrorSeverity.E_WARN, ErrorGeneric.EV_NONE, 3); //"%depotFile% - resolve move to %moveFile% before integrating from %fromFile%"
		public static int MsgDm_IntegPreviewResolve = ErrorOf(ErrorSubsystem.ES_DM, 710, ErrorSeverity.E_INFO, ErrorGeneric.EV_USAGE, 5); //"must resolve %resolveType% from %fromFile%%fromRev%[ using base %baseFile%][%baseRev%]"
		public static int MsgDm_IntegPreviewResolveMove = ErrorOf(ErrorSubsystem.ES_DM, 711, ErrorSeverity.E_INFO, ErrorGeneric.EV_USAGE, 2); //"must resolve move to %fromFile%[ using base %baseFile%]"
		public static int MsgDm_IntegPreviewResolved = ErrorOf(ErrorSubsystem.ES_DM, 768, ErrorSeverity.E_INFO, ErrorGeneric.EV_USAGE, 3); //"%how% %fromFile%%fromRev%"
		public static int MsgDm_IntegedData = ErrorOf(ErrorSubsystem.ES_DM, 265, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 5); //"%toFile%%toRev% - %how% %fromFile%%fromRev%"
		public static int MsgDm_JobSave = ErrorOf(ErrorSubsystem.ES_DM, 266, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Job %job% saved."
		public static int MsgDm_JobNoChange = ErrorOf(ErrorSubsystem.ES_DM, 267, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Job %job% not changed."
		public static int MsgDm_JobDelete = ErrorOf(ErrorSubsystem.ES_DM, 268, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Job %job% deleted."
		public static int MsgDm_JobDescription = ErrorOf(ErrorSubsystem.ES_DM, 269, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 5); //"%job%[ on %date%][ by %user%][ *%status%*][%description%]"
		public static int MsgDm_JobDeleteHasFix = ErrorOf(ErrorSubsystem.ES_DM, 465, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%job% has %count% fixes associated with it and can't be deleted."
		public static int MsgDm_LabelSyncAdd = ErrorOf(ErrorSubsystem.ES_DM, 272, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%depotFile%%haveRev% - added"
		public static int MsgDm_LabelSyncDelete = ErrorOf(ErrorSubsystem.ES_DM, 273, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%depotFile%%haveRev% - deleted"
		public static int MsgDm_LabelSyncReplace = ErrorOf(ErrorSubsystem.ES_DM, 274, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%depotFile%%haveRev% - replaced"
		public static int MsgDm_LabelSyncUpdate = ErrorOf(ErrorSubsystem.ES_DM, 275, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%depotFile%%haveRev% - updated"
		public static int MsgDm_LicenseSave = ErrorOf(ErrorSubsystem.ES_DM, 450, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"License file saved."
		public static int MsgDm_LicenseNoChange = ErrorOf(ErrorSubsystem.ES_DM, 451, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"License file not changed."
		public static int MsgDm_LockSuccess = ErrorOf(ErrorSubsystem.ES_DM, 276, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"%depotFile% - locking"
		public static int MsgDm_LockAlready = ErrorOf(ErrorSubsystem.ES_DM, 277, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"%depotFile% - already locked"
		public static int MsgDm_LockAlreadyOther = ErrorOf(ErrorSubsystem.ES_DM, 278, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"%depotFile% - already locked by %user%@%client%"
		public static int MsgDm_LockNoPermission = ErrorOf(ErrorSubsystem.ES_DM, 279, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"%depotFile% - no permission to lock file"
		public static int MsgDm_LockBadUnicode = ErrorOf(ErrorSubsystem.ES_DM, 525, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"%depotFile% - cannot submit unicode type file using non-unicode server"
		public static int MsgDm_LockUtf16NotSupp = ErrorOf(ErrorSubsystem.ES_DM, 526, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"%depotFile% - utf16 files can not be submitted by pre-2007.2 clients"
		public static int MsgDm_UnLockSuccess = ErrorOf(ErrorSubsystem.ES_DM, 280, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"%depotFile% - unlocking"
		public static int MsgDm_UnLockAlready = ErrorOf(ErrorSubsystem.ES_DM, 281, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"%depotFile% - already unlocked"
		public static int MsgDm_UnLockAlreadyOther = ErrorOf(ErrorSubsystem.ES_DM, 282, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"%depotFile% - locked by %user%@%client%"
		public static int MsgDm_ShelvedHasWorking = ErrorOf(ErrorSubsystem.ES_DM, 742, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"Cannot submit - files are open by client %client% at change %change%."
		public static int MsgDm_LoggerData = ErrorOf(ErrorSubsystem.ES_DM, 283, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"%sequence% %key% %attribute%"
		public static int MsgDm_MergeBadBase = ErrorOf(ErrorSubsystem.ES_DM, 638, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"%depotFile% - can't merge unrelated file %fromFile%%fromRev%"
		public static int MsgDm_MoveSuccess = ErrorOf(ErrorSubsystem.ES_DM, 487, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 4); //"%toFile%%toRev% - moved from %fromFile%%fromRev%"
		public static int MsgDm_MoveBadAction = ErrorOf(ErrorSubsystem.ES_DM, 488, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%depotFile% - can't move (already opened for %badAction%)"
		public static int MsgDm_MoveDeleted = ErrorOf(ErrorSubsystem.ES_DM, 626, ErrorSeverity.E_WARN, ErrorGeneric.EV_NONE, 2); //"%clientFile% - can't move (open for %action%); must accept other resolve(s) or ignore"
		public static int MsgDm_MoveExists = ErrorOf(ErrorSubsystem.ES_DM, 489, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"%depotFile% - can't move to an existing file"
		public static int MsgDm_MoveMisMatch = ErrorOf(ErrorSubsystem.ES_DM, 490, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 0); //"Mismatched move on client!"
		public static int MsgDm_MoveNoMatch = ErrorOf(ErrorSubsystem.ES_DM, 491, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"%depotFile% - needs %direction%file %movedFile%"
		public static int MsgDm_MoveNoInteg = ErrorOf(ErrorSubsystem.ES_DM, 763, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NONE, 2); //"%depotFile% - moved from %movedFile% but has no matching resolve record; must 'add -d' or 'move' to correct."
		public static int MsgDm_MoveReadOnly = ErrorOf(ErrorSubsystem.ES_DM, 494, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"%depotFile% - can't move to a spec or remote depot"
		public static int MsgDm_MoveNotSynced = ErrorOf(ErrorSubsystem.ES_DM, 528, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"%depotFile% - not synced, can't force move"
		public static int MsgDm_MoveNotResolved = ErrorOf(ErrorSubsystem.ES_DM, 529, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"%depotFile% - is unresolved, can't force move"
		public static int MsgDm_MoveNeedForce = ErrorOf(ErrorSubsystem.ES_DM, 530, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"%clientFile% - is synced; use -f to force move"
		public static int MsgDm_OpenAlready = ErrorOf(ErrorSubsystem.ES_DM, 284, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%depotFile% - can't %action% (already opened on this client)"
		public static int MsgDm_OpenReadOnly = ErrorOf(ErrorSubsystem.ES_DM, 285, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%depotFile% - can only %action% file in a local depot"
		public static int MsgDm_OpenXOpened = ErrorOf(ErrorSubsystem.ES_DM, 286, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%depotFile% - can't %action% exclusive file already opened"
		public static int MsgDm_OpenXOpenedFailed = ErrorOf(ErrorSubsystem.ES_DM, 777, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NONE, 2); //"%depotFile% - can't %action% exclusive file already opened"
		public static int MsgDm_OpenBadAction = ErrorOf(ErrorSubsystem.ES_DM, 287, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"%depotFile% - can't %action% (already opened for %badAction%)"
		public static int MsgDm_OpenBadClient = ErrorOf(ErrorSubsystem.ES_DM, 288, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%depotFile% - is already opened by client %client%"
		public static int MsgDm_OpenBadUser = ErrorOf(ErrorSubsystem.ES_DM, 289, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%depotFile% - is already opened by user %user%"
		public static int MsgDm_OpenBadChange = ErrorOf(ErrorSubsystem.ES_DM, 290, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%depotFile% - can't change from %change% - use 'reopen'"
		public static int MsgDm_OpenBadType = ErrorOf(ErrorSubsystem.ES_DM, 291, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%depotFile% - can't change from %type% - use 'reopen'"
		public static int MsgDm_OpenReOpen = ErrorOf(ErrorSubsystem.ES_DM, 292, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"%depotFile%%workRev% - reopened for %action%"
		public static int MsgDm_OpenUpToDate = ErrorOf(ErrorSubsystem.ES_DM, 293, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"%depotFile%%workRev% - currently opened for %action%"
		public static int MsgDm_OpenCantExists = ErrorOf(ErrorSubsystem.ES_DM, 294, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%depotFile% - can't %action% existing file"
		public static int MsgDm_OpenCantDeleted = ErrorOf(ErrorSubsystem.ES_DM, 295, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%depotFile% - can't %action% deleted file"
		public static int MsgDm_OpenSuccess = ErrorOf(ErrorSubsystem.ES_DM, 296, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"%depotFile%%workRev% - opened for %action%"
		public static int MsgDm_OpenMustResolve = ErrorOf(ErrorSubsystem.ES_DM, 297, ErrorSeverity.E_INFO, ErrorGeneric.EV_USAGE, 2); //"%depotFile% - must sync/resolve %workRev% before submitting"
		public static int MsgDm_OpenIsLocked = ErrorOf(ErrorSubsystem.ES_DM, 298, ErrorSeverity.E_INFO, ErrorGeneric.EV_USAGE, 3); //"%depotFile% - locked by %user%@%client%"
		public static int MsgDm_OpenIsOpened = ErrorOf(ErrorSubsystem.ES_DM, 299, ErrorSeverity.E_INFO, ErrorGeneric.EV_USAGE, 3); //"%depotFile% - also opened by %user%@%client%"
		public static int MsgDm_OpenWarnExists = ErrorOf(ErrorSubsystem.ES_DM, 300, ErrorSeverity.E_INFO, ErrorGeneric.EV_USAGE, 2); //"%depotFile% - warning: %action% of existing file"
		public static int MsgDm_OpenWarnDeleted = ErrorOf(ErrorSubsystem.ES_DM, 301, ErrorSeverity.E_INFO, ErrorGeneric.EV_USAGE, 2); //"%depotFile% - warning: %action% of deleted file"
		public static int MsgDm_OpenWarnMoved = ErrorOf(ErrorSubsystem.ES_DM, 493, ErrorSeverity.E_INFO, ErrorGeneric.EV_USAGE, 2); //"%depotFile% - warning: %action% of moved file"
		public static int MsgDm_OpenWarnOpenStream = ErrorOf(ErrorSubsystem.ES_DM, 553, ErrorSeverity.E_INFO, ErrorGeneric.EV_USAGE, 1); //"%depotFile% - warning: cannot submit from non-stream client"
		public static int MsgDm_OpenWarnOpenNotStream = ErrorOf(ErrorSubsystem.ES_DM, 554, ErrorSeverity.E_INFO, ErrorGeneric.EV_USAGE, 2); //"%depotFile% - warning: cannot submit from stream %stream% client"
		public static int MsgDm_OpenWarnFileNotMapped = ErrorOf(ErrorSubsystem.ES_DM, 570, ErrorSeverity.E_INFO, ErrorGeneric.EV_USAGE, 2); //"%depotFile% - warning: file not mapped in stream %stream% client"
		public static int MsgDm_OpenWarnChangeMap = ErrorOf(ErrorSubsystem.ES_DM, 799, ErrorSeverity.E_INFO, ErrorGeneric.EV_USAGE, 2); //"%depotFile% - warning: cannot submit file locked [to %change% ]by client's ChangeView mapping"
		public static int MsgDm_OpenOtherDepot = ErrorOf(ErrorSubsystem.ES_DM, 724, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NONE, 3); //"%clientFile% - can't open %depotFile% (already opened as %depotFile2%)"
		public static int MsgDm_OpenTaskNotMapped = ErrorOf(ErrorSubsystem.ES_DM, 752, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%clientFile% - can't open %depotFile% (not mapped in client), must sync first."
		public static int MsgDm_OpenedData = ErrorOf(ErrorSubsystem.ES_DM, 302, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 5); //"%depotFile%%workRev% - %action% %change% (%type%)"
		public static int MsgDm_OpenedOther = ErrorOf(ErrorSubsystem.ES_DM, 303, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 7); //"%depotFile%%workRev% - %action% %change% (%type%) by %user%@%client%"
		public static int MsgDm_OpenedLocked = ErrorOf(ErrorSubsystem.ES_DM, 304, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 5); //"%depotFile%%workRev% - %action% %change% (%type%) *locked*"
		public static int MsgDm_OpenedOtherLocked = ErrorOf(ErrorSubsystem.ES_DM, 305, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 7); //"%depotFile%%workRev% - %action% %change% (%type%) by %user%@%client% *locked*"
		public static int MsgDm_OpenedXData = ErrorOf(ErrorSubsystem.ES_DM, 635, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 5); //"%depotFile%%workRev% - %action% %change% (%type%) *exclusive*"
		public static int MsgDm_OpenedXOther = ErrorOf(ErrorSubsystem.ES_DM, 636, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 7); //"%depotFile%%workRev% - %action% %change% (%type%) by %user%@%client% *exclusive*"
		public static int MsgDm_OpenedDataS = ErrorOf(ErrorSubsystem.ES_DM, 644, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"%depotFile% - %action% %change%"
		public static int MsgDm_OpenedOtherS = ErrorOf(ErrorSubsystem.ES_DM, 645, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 5); //"%depotFile% - %action% %change% by %user%@%client%"
		public static int MsgDm_OpenedLockedS = ErrorOf(ErrorSubsystem.ES_DM, 646, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"%depotFile% - %action% %change% *locked*"
		public static int MsgDm_OpenedOtherLockedS = ErrorOf(ErrorSubsystem.ES_DM, 647, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 5); //"%depotFile% - %action% %change% by %user%@%client% *locked*"
		public static int MsgDm_OpenedXDataS = ErrorOf(ErrorSubsystem.ES_DM, 648, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"%depotFile% - %action% %change% *exclusive*"
		public static int MsgDm_OpenedXOtherS = ErrorOf(ErrorSubsystem.ES_DM, 649, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 5); //"%depotFile% - %action% %change% by %user%@%client% *exclusive*"
		public static int MsgDm_OpenExclOrphaned = ErrorOf(ErrorSubsystem.ES_DM, 770, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"%depotFile% - %user%@%client% *orphaned*"
		public static int MsgDm_OpenExclLocked = ErrorOf(ErrorSubsystem.ES_DM, 771, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"%depotFile% - %user%@%client% *exclusive*"
		public static int MsgDm_OpenExclOther = ErrorOf(ErrorSubsystem.ES_DM, 772, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 4); //"%depotFile% - %user%@%client% %server%"
		public static int MsgDm_PopulateDesc = ErrorOf(ErrorSubsystem.ES_DM, 679, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"Populate %target%[ from %source%]."
		public static int MsgDm_PopulateTargetExists = ErrorOf(ErrorSubsystem.ES_DM, 678, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ILLEGAL, 0); //"Can't populate target path when files already exist."
		public static int MsgDm_PopulateTargetMixed = ErrorOf(ErrorSubsystem.ES_DM, 726, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ILLEGAL, 0); //"Can't update target with mixed stream/non-stream paths."
		public static int MsgDm_PopulateInvalidStream = ErrorOf(ErrorSubsystem.ES_DM, 727, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ILLEGAL, 1); //"Can't update stream target with '%depotFile%'"
		public static int MsgDm_PopulateMultipleStreams = ErrorOf(ErrorSubsystem.ES_DM, 728, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ILLEGAL, 0); //"Can't update multiple streams with single command."
		public static int MsgDm_ProtectSave = ErrorOf(ErrorSubsystem.ES_DM, 306, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"Protections saved."
		public static int MsgDm_ProtectNoChange = ErrorOf(ErrorSubsystem.ES_DM, 307, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"Protections not changed."
		public static int MsgDm_ProtectsData = ErrorOf(ErrorSubsystem.ES_DM, 440, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 6); //"%perm% %isgroup% %user% %ipaddr% %mapFlag%%depotFile%"
		public static int MsgDm_ProtectsMaxData = ErrorOf(ErrorSubsystem.ES_DM, 452, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"%perm%"
		public static int MsgDm_ProtectsEmpty = ErrorOf(ErrorSubsystem.ES_DM, 456, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ADMIN, 0); //"Protections table is empty."
		public static int MsgDm_ProtectsNoSuper = ErrorOf(ErrorSubsystem.ES_DM, 469, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ADMIN, 0); //"Can't delete last valid 'super' entry from protections table."
		public static int MsgDm_PurgeSnapData = ErrorOf(ErrorSubsystem.ES_DM, 308, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 4); //"%depotFile%%depotRev% - copy from %lbrFile% %lbrRev%"
		public static int MsgDm_PurgeDeleted = ErrorOf(ErrorSubsystem.ES_DM, 309, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 6); //"Deleted [%onHave% client ][%onLabel% label ][%onInteg% integration ][%onWorking% opened ][%onRev% revision ][and added %synInteg% integration ]record(s)."
		public static int MsgDm_PurgeCheck = ErrorOf(ErrorSubsystem.ES_DM, 310, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 6); //"Would delete [%onHave% client ][%onLabel% label ][%onInteg% integration ][%onWorking% opened ][%onRev% revision ][and add %synInteg% integration ]record(s)."
		public static int MsgDm_PurgeNoRecords = ErrorOf(ErrorSubsystem.ES_DM, 311, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"No records to delete."
		public static int MsgDm_PurgeData = ErrorOf(ErrorSubsystem.ES_DM, 312, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%depotFile%%depotRev% - purged"
		public static int MsgDm_PurgeActiveTask = ErrorOf(ErrorSubsystem.ES_DM, 737, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ILLEGAL, 2); //"Can't %action% active task stream files - '%depotFile%'"
		public static int MsgDm_ReleaseHasPending = ErrorOf(ErrorSubsystem.ES_DM, 313, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%depotFile%%haveRev% - has pending integrations, not reverted"
		public static int MsgDm_ReleaseAbandon = ErrorOf(ErrorSubsystem.ES_DM, 314, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"%depotFile%%haveRev% - was %action%, abandoned"
		public static int MsgDm_ReleaseClear = ErrorOf(ErrorSubsystem.ES_DM, 315, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"%depotFile%%haveRev% - was %action%, cleared"
		public static int MsgDm_ReleaseDelete = ErrorOf(ErrorSubsystem.ES_DM, 316, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"%depotFile%%haveRev% - was %action%, deleted"
		public static int MsgDm_ReleaseRevert = ErrorOf(ErrorSubsystem.ES_DM, 317, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"%depotFile%%haveRev% - was %action%, reverted"
		public static int MsgDm_ReleaseUnlockAbandon = ErrorOf(ErrorSubsystem.ES_DM, 318, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"%depotFile%%haveRev% - was %action%, unlocked and abandoned"
		public static int MsgDm_ReleaseUnlockClear = ErrorOf(ErrorSubsystem.ES_DM, 319, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"%depotFile%%haveRev% - was %action%, unlocked and cleared"
		public static int MsgDm_ReleaseUnlockDelete = ErrorOf(ErrorSubsystem.ES_DM, 320, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"%depotFile%%haveRev% - was %action%, unlocked and deleted"
		public static int MsgDm_ReleaseUnlockRevert = ErrorOf(ErrorSubsystem.ES_DM, 321, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"%depotFile%%haveRev% - was %action%, unlocked and reverted"
		public static int MsgDm_ReleaseNotOwner = ErrorOf(ErrorSubsystem.ES_DM, 443, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"%depotFile%%haveRev% - belongs to user %user%, not reverted"
		public static int MsgDm_ReleaseHasMoved = ErrorOf(ErrorSubsystem.ES_DM, 486, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%depotFile%%haveRev% - has been moved, not reverted"
		public static int MsgDm_ReopenData = ErrorOf(ErrorSubsystem.ES_DM, 322, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 5); //"%depotFile%%workRev% - reopened[; user %user%][; type %type%][; %change%]"
		public static int MsgDm_ReopenDataNoChange = ErrorOf(ErrorSubsystem.ES_DM, 323, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 5); //"%depotFile%%workRev% - nothing changed[; user %user%][; type %type%][; %change%]"
		public static int MsgDm_ReopenCharSet = ErrorOf(ErrorSubsystem.ES_DM, 767, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"%depotFile%%workRev% - reopened; charset %charset%"
		public static int MsgDm_ReopenBadType = ErrorOf(ErrorSubsystem.ES_DM, 760, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%depotFile%%workRev% - can't change +l type with reopen; use revert -k and then edit -t to change type."
		public static int MsgDm_ResolveAction = ErrorOf(ErrorSubsystem.ES_DM, 590, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 6); //"%localPath% - resolving %resolveType% from %fromFile%%fromRev%[ using base %baseFile%][%baseRev%]"
		public static int MsgDm_ResolveActionMove = ErrorOf(ErrorSubsystem.ES_DM, 622, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"%localPath% - resolving move to %fromFile%[ using base %baseFile%]"
		public static int MsgDm_ResolveDelete = ErrorOf(ErrorSubsystem.ES_DM, 324, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"%localPath% - has been deleted - revert and sync."
		public static int MsgDm_ResolveShelveDelete = ErrorOf(ErrorSubsystem.ES_DM, 639, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 2); //"%depotFile%%rev%: can't resolve (shelved file was deleted); must revert, or revert -k and edit before submit."
		public static int MsgDm_ResolveDoBranch = ErrorOf(ErrorSubsystem.ES_DM, 594, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"Branch resolve"
		public static int MsgDm_ResolveDoBranchActionT = ErrorOf(ErrorSubsystem.ES_DM, 595, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"branch"
		public static int MsgDm_ResolveDoBranchActionY = ErrorOf(ErrorSubsystem.ES_DM, 596, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"ignore"
		public static int MsgDm_ResolveDoDelete = ErrorOf(ErrorSubsystem.ES_DM, 597, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"Delete resolve"
		public static int MsgDm_ResolveDoDeleteActionT = ErrorOf(ErrorSubsystem.ES_DM, 598, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"delete"
		public static int MsgDm_ResolveDoDeleteActionY = ErrorOf(ErrorSubsystem.ES_DM, 599, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"ignore"
		public static int MsgDm_ResolveFiletype = ErrorOf(ErrorSubsystem.ES_DM, 591, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"Filetype resolve"
		public static int MsgDm_ResolveFiletypeAction = ErrorOf(ErrorSubsystem.ES_DM, 592, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"(%type%)"
		public static int MsgDm_ResolveMove = ErrorOf(ErrorSubsystem.ES_DM, 600, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"Filename resolve"
		public static int MsgDm_ResolveMoveAction = ErrorOf(ErrorSubsystem.ES_DM, 601, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"%depotPath%"
		public static int MsgDm_ResolveTrait = ErrorOf(ErrorSubsystem.ES_DM, 666, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"Attribute resolve"
		public static int MsgDm_ResolveTraitActionT = ErrorOf(ErrorSubsystem.ES_DM, 667, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"overwrite your open attributes with their set of [%count% ]attribute(s)"
		public static int MsgDm_ResolveTraitActionY = ErrorOf(ErrorSubsystem.ES_DM, 668, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"leave your set of [%count% ]open attribute(s) unchanged"
		public static int MsgDm_ResolveTraitActionM = ErrorOf(ErrorSubsystem.ES_DM, 669, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"merge their [%count% ]propagating attribute(s) with your set of attribute(s)"
		public static int MsgDm_ResolveCharset = ErrorOf(ErrorSubsystem.ES_DM, 764, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"Charset resolve"
		public static int MsgDm_ResolveCharsetActionT = ErrorOf(ErrorSubsystem.ES_DM, 765, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"overwrite your open character set with their character set of %charset%"
		public static int MsgDm_ResolveCharsetActionY = ErrorOf(ErrorSubsystem.ES_DM, 766, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"leave your character set of %charset% unchanged"
		public static int MsgDm_Resolve2WayRaw = ErrorOf(ErrorSubsystem.ES_DM, 325, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"%localPath% - vs %fromFile%%fromRev%"
		public static int MsgDm_Resolve3WayRaw = ErrorOf(ErrorSubsystem.ES_DM, 326, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 7); //"%localPath% - %baseType%/%headType% merge %fromFile%%fromRev%[ using base %baseFile%][%baseRev%]"
		public static int MsgDm_Resolve3WayText = ErrorOf(ErrorSubsystem.ES_DM, 327, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"%localPath% - merging %fromFile%%fromRev%"
		public static int MsgDm_Resolve3WayTextBase = ErrorOf(ErrorSubsystem.ES_DM, 425, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 5); //"%localPath% - merging %fromFile%%fromRev% using base %baseFile%%baseRev%"
		public static int MsgDm_ResolveMustIgnore = ErrorOf(ErrorSubsystem.ES_DM, 798, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NONE, 1); //"%clientFile% - their revision is unavailable; resolve -ay (ignore) or revert?"
		public static int MsgDm_ResolvedAction = ErrorOf(ErrorSubsystem.ES_DM, 593, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 6); //"%localPath% - resolved %resolveType% from %fromFile%%fromRev%[ using base %baseFile%][%baseRev%]"
		public static int MsgDm_ResolvedActionMove = ErrorOf(ErrorSubsystem.ES_DM, 623, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 4); //"%localPath% - resolved move (%how% %fromFile%)[ using base %baseFile%]"
		public static int MsgDm_ResolvedData = ErrorOf(ErrorSubsystem.ES_DM, 328, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 4); //"%localPath% - %how% %fromFile%%fromRev%"
		public static int MsgDm_ResolvedDataBase = ErrorOf(ErrorSubsystem.ES_DM, 428, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 6); //"%localPath% - %how% %fromFile%%fromRev% base %baseFile%%baseRev%"
		public static int MsgDm_RetypeData = ErrorOf(ErrorSubsystem.ES_DM, 459, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 4); //"%depotFile%%depotRev% - %oldType% now %newType%"
		public static int MsgDm_ReviewData = ErrorOf(ErrorSubsystem.ES_DM, 329, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 4); //"%change% %user% <%email%> (%fullName%)"
		public static int MsgDm_ReviewsData = ErrorOf(ErrorSubsystem.ES_DM, 330, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"%user% <%email%> (%fullname%)"
		public static int MsgDm_SpecSave = ErrorOf(ErrorSubsystem.ES_DM, 414, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Spec %type% saved."
		public static int MsgDm_SpecNoChange = ErrorOf(ErrorSubsystem.ES_DM, 415, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Spec %type% not changed."
		public static int MsgDm_SpecDeleted = ErrorOf(ErrorSubsystem.ES_DM, 416, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Spec %type% deleted."
		public static int MsgDm_SpecNotDefined = ErrorOf(ErrorSubsystem.ES_DM, 417, ErrorSeverity.E_FAILED, ErrorGeneric.EV_UNKNOWN, 1); //"Spec %type% not defined."
		public static int MsgDm_ShelveCantUpdate = ErrorOf(ErrorSubsystem.ES_DM, 512, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"%depotFile% - already shelved, use -f to update."
		public static int MsgDm_ShelveLocked = ErrorOf(ErrorSubsystem.ES_DM, 518, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"%depotFile% - shelved file locked, try again later."
		public static int MsgDm_ShelveUnlocked = ErrorOf(ErrorSubsystem.ES_DM, 519, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"%depotFile% - shelved file unlocked, try again later."
		public static int MsgDm_ShelveIncompatible = ErrorOf(ErrorSubsystem.ES_DM, 522, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"%depotFile% - can't overwrite a shelved moved file, use -r to replace."
		public static int MsgDm_ShelveMaxFiles = ErrorOf(ErrorSubsystem.ES_DM, 523, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Shelve file limit exceeded (over %maxFiles%)."
		public static int MsgDm_ShelveNoPerm = ErrorOf(ErrorSubsystem.ES_DM, 541, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"%depotFile% - no permission to shelve file"
		public static int MsgDm_ShelveNeedsResolve = ErrorOf(ErrorSubsystem.ES_DM, 620, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NONE, 3); //"%depotFile% - must resolve %file%%srev% before shelving"
		public static int MsgDm_ShelveOpenResolves = ErrorOf(ErrorSubsystem.ES_DM, 633, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NONE, 3); //"%depotFile% - unshelved file for [%user%@]%client% needs resolve"
		public static int MsgDm_FieldCount = ErrorOf(ErrorSubsystem.ES_DM, 496, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"'%tag%' unknown or wrong number of fields for path-type."
		public static int MsgDm_StreamNotOwner = ErrorOf(ErrorSubsystem.ES_DM, 497, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NONE, 2); //"Stream '%stream%' is owned by '%owner%'."
		public static int MsgDm_StreamTargetExists = ErrorOf(ErrorSubsystem.ES_DM, 753, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NONE, 1); //"%stream% - can't create stream where files already exist."
		public static int MsgDm_StreamsData = ErrorOf(ErrorSubsystem.ES_DM, 498, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 5); //"Stream %stream% %type% %parent% '%title%'[ %status%]"
		public static int MsgDm_StreamRootErr = ErrorOf(ErrorSubsystem.ES_DM, 499, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NONE, 1); //"Stream '%stream%' must begin with '//'."
		public static int MsgDm_StreamNested = ErrorOf(ErrorSubsystem.ES_DM, 501, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NONE, 2); //"Streams cannot be nested. '%stream%' contains existing stream '%nested%'."
		public static int MsgDm_StreamDoubleSlash = ErrorOf(ErrorSubsystem.ES_DM, 502, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NONE, 1); //"Stream '%stream%' contains embedded double slashes (//)."
		public static int MsgDm_StreamEqDepot = ErrorOf(ErrorSubsystem.ES_DM, 503, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NONE, 1); //"Stream '%stream%' must be below depot level."
		public static int MsgDm_StreamDepthErr = ErrorOf(ErrorSubsystem.ES_DM, 504, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NONE, 1); //"Stream '%stream%' must reside in first folder below depot level."
		public static int MsgDm_StreamEndSlash = ErrorOf(ErrorSubsystem.ES_DM, 505, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NONE, 1); //"Trailing slash not allowed in '%id%'."
		public static int MsgDm_StreamVsDomains = ErrorOf(ErrorSubsystem.ES_DM, 506, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 0); //"Stream and domains table out of sync!"
		public static int MsgDm_LocWild = ErrorOf(ErrorSubsystem.ES_DM, 514, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 2); //"%loc% wildcards (*, ...) not allowed in path: '%path%'."
		public static int MsgDm_EmbWild = ErrorOf(ErrorSubsystem.ES_DM, 543, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Embedded wildcards (*, ...) not allowed in '%path%'."
		public static int MsgDm_EmbSpecChar = ErrorOf(ErrorSubsystem.ES_DM, 700, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Embedded special characters (*, %%, #, @) not allowed in '%path%'."
		public static int MsgDm_PosWild = ErrorOf(ErrorSubsystem.ES_DM, 515, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Positional wildcards (%%%%x) not allowed in path: '%path%'."
		public static int MsgDm_StreamOwnerReq = ErrorOf(ErrorSubsystem.ES_DM, 582, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NONE, 1); //"Owner field of Stream '%stream%' required."
		public static int MsgDm_SubmitUpToDate = ErrorOf(ErrorSubsystem.ES_DM, 331, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%depotFile% - opened at head rev %workRev%"
		public static int MsgDm_SubmitWasAdd = ErrorOf(ErrorSubsystem.ES_DM, 332, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%depotFile% - %action% of added file; must revert"
		public static int MsgDm_SubmitWasDelete = ErrorOf(ErrorSubsystem.ES_DM, 333, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%depotFile% - %action% of deleted file; must revert"
		public static int MsgDm_SubmitWasDeleteCanReadd = ErrorOf(ErrorSubsystem.ES_DM, 539, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%depotFile% - %action% of deleted file; must sync & add -d or revert"
		public static int MsgDm_SubmitMustResolve = ErrorOf(ErrorSubsystem.ES_DM, 334, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"%depotFile% - must resolve before submitting"
		public static int MsgDm_SubmitTransfer = ErrorOf(ErrorSubsystem.ES_DM, 335, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"%action% %depotFile%%depotRev%"
		public static int MsgDm_SubmitRefresh = ErrorOf(ErrorSubsystem.ES_DM, 336, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%depotFile%%depotRev% - refreshing"
		public static int MsgDm_SubmitReverted = ErrorOf(ErrorSubsystem.ES_DM, 444, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%depotFile%%depotRev% - unchanged, reverted"
		public static int MsgDm_SubmitMovedToDefault = ErrorOf(ErrorSubsystem.ES_DM, 445, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%depotFile%%depotRev% - unchanged, moved to default changelist"
		public static int MsgDm_SubmitResolve = ErrorOf(ErrorSubsystem.ES_DM, 337, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"%toFile% - must resolve %fromFile%%fromRev%"
		public static int MsgDm_SubmitNewResolve = ErrorOf(ErrorSubsystem.ES_DM, 338, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%fromFile% - must resolve %fromRev%"
		public static int MsgDm_SubmitChanges = ErrorOf(ErrorSubsystem.ES_DM, 339, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"Use 'p4 submit -c %change%' to submit file(s) in pending %newChange%."
		public static int MsgDm_SyncAdd = ErrorOf(ErrorSubsystem.ES_DM, 340, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"%depotFile%%depotRev% - added as %localPath%"
		public static int MsgDm_SyncDelete = ErrorOf(ErrorSubsystem.ES_DM, 341, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"%depotFile%%haveRev% - deleted as %localPath%"
		public static int MsgDm_SyncReplace = ErrorOf(ErrorSubsystem.ES_DM, 342, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"%depotFile%%depotRev% - replacing %localPath%"
		public static int MsgDm_SyncCantDelete = ErrorOf(ErrorSubsystem.ES_DM, 343, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"%depotFile%%workRev% - is opened for %action% and can't be deleted"
		public static int MsgDm_SyncCantReplace = ErrorOf(ErrorSubsystem.ES_DM, 344, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"%depotFile%%workRev% - is opened for %action% and can't be replaced"
		public static int MsgDm_SyncUpdate = ErrorOf(ErrorSubsystem.ES_DM, 345, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"%depotFile%%depotRev% - updating %localPath%"
		public static int MsgDm_SyncRefresh = ErrorOf(ErrorSubsystem.ES_DM, 346, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"%depotFile%%depotRev% - refreshing %localPath%"
		public static int MsgDm_SyncIntegUpdate = ErrorOf(ErrorSubsystem.ES_DM, 347, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%depotFile%%workRev% - is opened and not being changed"
		public static int MsgDm_SyncIntegDelete = ErrorOf(ErrorSubsystem.ES_DM, 348, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"%depotFile%%workRev% - is opened for %action% - not changed"
		public static int MsgDm_SyncIntegBackwards = ErrorOf(ErrorSubsystem.ES_DM, 349, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%depotFile%%workRev% - is opened at a later revision - not changed"
		public static int MsgDm_SyncUptodate = ErrorOf(ErrorSubsystem.ES_DM, 350, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%depotFile%%haveRev% - is up-to-date"
		public static int MsgDm_SyncResolve = ErrorOf(ErrorSubsystem.ES_DM, 351, ErrorSeverity.E_INFO, ErrorGeneric.EV_USAGE, 2); //"%depotFile% - must resolve %revRange% before submitting"
		public static int MsgDm_SyncCantPublishIsOpen = ErrorOf(ErrorSubsystem.ES_DM, 457, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"%depotFile% - can't sync -p a file that's opened"
		public static int MsgDm_SyncCantPublishOnHave = ErrorOf(ErrorSubsystem.ES_DM, 458, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"%depotFile% - can't sync -p a file that's synced"
		public static int MsgDm_SyncMissingMoveSource = ErrorOf(ErrorSubsystem.ES_DM, 492, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%depotFile% - can't sync moved file,  %fromFile% is missing from the rev table!"
		public static int MsgDm_SyncNotSafeAdd = ErrorOf(ErrorSubsystem.ES_DM, 602, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"%depotFile%%depotRev% - can't overwrite existing file %localPath%"
		public static int MsgDm_SyncNotSafeDelete = ErrorOf(ErrorSubsystem.ES_DM, 603, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"%depotFile%%depotRev% - can't delete modified file %localPath%"
		public static int MsgDm_SyncNotSafeUpdate = ErrorOf(ErrorSubsystem.ES_DM, 604, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"%depotFile%%depotRev% - can't update modified file %localPath%"
		public static int MsgDm_SyncNotSafeReplace = ErrorOf(ErrorSubsystem.ES_DM, 605, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"%depotFile%%depotRev% - can't replace modified file %localPath%"
		public static int MsgDm_SyncIndexOutOfBounds = ErrorOf(ErrorSubsystem.ES_DM, 606, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 2); //"Index out of range %index% of %total%"
		public static int MsgDm_TraitCleared = ErrorOf(ErrorSubsystem.ES_DM, 429, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"%depotFile%%depotRev% - %name% cleared"
		public static int MsgDm_TraitNotSet = ErrorOf(ErrorSubsystem.ES_DM, 430, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"%depotFile%%depotRev% - %name% not set"
		public static int MsgDm_TraitSet = ErrorOf(ErrorSubsystem.ES_DM, 431, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"%depotFile%%depotRev% - %name% set"
		public static int MsgDm_TraitIsOpen = ErrorOf(ErrorSubsystem.ES_DM, 686, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CONTEXT, 0); //"Cannot set propagating traits on currently opened file(s)."
		public static int MsgDm_TriggerSave = ErrorOf(ErrorSubsystem.ES_DM, 352, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"Triggers saved."
		public static int MsgDm_TriggerNoChange = ErrorOf(ErrorSubsystem.ES_DM, 353, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"Triggers not changed."
		public static int MsgDm_TriggerNoDepotFile = ErrorOf(ErrorSubsystem.ES_DM, 793, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 2); //"Trigger depot file '%file%' not found, purged or wrong type for trigger '%trigger%'."
		public static int MsgDm_TriggerNoArchiveType = ErrorOf(ErrorSubsystem.ES_DM, 794, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Archive trigger may not use trigger depot files."
		public static int MsgDm_TypeMapSave = ErrorOf(ErrorSubsystem.ES_DM, 354, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"%type% saved."
		public static int MsgDm_TypeMapNoChange = ErrorOf(ErrorSubsystem.ES_DM, 355, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"%type% not changed."
		public static int MsgDm_UnshelveBadAction = ErrorOf(ErrorSubsystem.ES_DM, 510, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%depotFile% - can't unshelve (already opened for %badAction%)"
		public static int MsgDm_UnshelveBadClientView = ErrorOf(ErrorSubsystem.ES_DM, 641, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%depotFile% - can't unshelve (already opened for %action% using a different client view path)"
		public static int MsgDm_UnshelveBadAdd = ErrorOf(ErrorSubsystem.ES_DM, 520, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"Can't unshelve %depotFile% to open for %badAdd%: file already exists."
		public static int MsgDm_UnshelveBadEdit = ErrorOf(ErrorSubsystem.ES_DM, 521, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"Can't unshelve %depotFile% to open for %badEdit%: file does not exist or has been deleted."
		public static int MsgDm_UnshelveSuccess = ErrorOf(ErrorSubsystem.ES_DM, 511, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"%depotFile%%depotRev% - unshelved, opened for %action%"
		public static int MsgDm_UnshelveIsLocked = ErrorOf(ErrorSubsystem.ES_DM, 513, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"File(s) in this shelve are locked - try again later!"
		public static int MsgDm_UnshelveResolve = ErrorOf(ErrorSubsystem.ES_DM, 621, ErrorSeverity.E_INFO, ErrorGeneric.EV_USAGE, 3); //"%depotFile% - must resolve %fromFile%%rev% before submitting"
		public static int MsgDm_UnshelveNotTask = ErrorOf(ErrorSubsystem.ES_DM, 744, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 2); //"%depotFile% - can't unshelve for %action%, task stream client required."
		public static int MsgDm_UnshelveFromRemote = ErrorOf(ErrorSubsystem.ES_DM, 797, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%depotFile% - can't unshelve from remote server (already opened for %badAction%)"
		public static int MsgDm_UserSave = ErrorOf(ErrorSubsystem.ES_DM, 356, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"User %user% saved."
		public static int MsgDm_UserNoChange = ErrorOf(ErrorSubsystem.ES_DM, 357, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"User %user% not changed."
		public static int MsgDm_UserNotExist = ErrorOf(ErrorSubsystem.ES_DM, 358, ErrorSeverity.E_FAILED, ErrorGeneric.EV_UNKNOWN, 1); //"User %user% doesn't exist."
		public static int MsgDm_UserCantDelete = ErrorOf(ErrorSubsystem.ES_DM, 359, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"User %user% has file(s) open on %value% client(s) and can't be deleted."
		public static int MsgDm_UserDelete = ErrorOf(ErrorSubsystem.ES_DM, 360, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"User %user% deleted."
		public static int MsgDm_UsersData = ErrorOf(ErrorSubsystem.ES_DM, 361, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 4); //"%user% <%email%> (%fullName%) accessed %accessDate%"
		public static int MsgDm_UsersDataLong = ErrorOf(ErrorSubsystem.ES_DM, 555, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 7); //"%user% <%email%> (%fullName%) accessed %accessDate% type %type% ticket expires %endDate% password last changed %passDate%"
		public static int MsgDm_VerifyData = ErrorOf(ErrorSubsystem.ES_DM, 362, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 7); //"%depotFile%%depotRev% - %action% %change% (%type%) %digest%[ %status%]"
		public static int MsgDm_VerifyDataProblem = ErrorOf(ErrorSubsystem.ES_DM, 730, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NONE, 7); //"%depotFile%%depotRev% - %action% %change% (%type%) %digest% %status%"
		public static int MsgDm_WhereData = ErrorOf(ErrorSubsystem.ES_DM, 364, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 4); //"%mapFlag%%depotFile% %clientFile% %localPath%"
		public static int MsgDm_ExARCHIVES = ErrorOf(ErrorSubsystem.ES_DM, 790, ErrorSeverity.E_WARN, ErrorGeneric.EV_EMPTY, 1); //"[%argc% - no|No] such cached archive(s)."
		public static int MsgDm_ExCHANGE = ErrorOf(ErrorSubsystem.ES_DM, 365, ErrorSeverity.E_WARN, ErrorGeneric.EV_EMPTY, 1); //"[%argc% - no|No] such changelist."
		public static int MsgDm_ExSTREAM = ErrorOf(ErrorSubsystem.ES_DM, 508, ErrorSeverity.E_WARN, ErrorGeneric.EV_EMPTY, 1); //"[%argc% - no|No] such stream."
		public static int MsgDm_ExUSER = ErrorOf(ErrorSubsystem.ES_DM, 366, ErrorSeverity.E_WARN, ErrorGeneric.EV_EMPTY, 1); //"[%argc% - no|No] such user(s)."
		public static int MsgDm_ExVIEW = ErrorOf(ErrorSubsystem.ES_DM, 367, ErrorSeverity.E_WARN, ErrorGeneric.EV_EMPTY, 1); //"[%argc% - file(s)|File(s)] not in client view."
		public static int MsgDm_ExVIEW2 = ErrorOf(ErrorSubsystem.ES_DM, 477, ErrorSeverity.E_WARN, ErrorGeneric.EV_EMPTY, 2); //"%!%[%argc% - file(s)|File(s)] not in client view."
		public static int MsgDm_ExSVIEW = ErrorOf(ErrorSubsystem.ES_DM, 478, ErrorSeverity.E_WARN, ErrorGeneric.EV_EMPTY, 1); //"[%argc% - no|No] source file(s) in branch view."
		public static int MsgDm_ExTVIEW = ErrorOf(ErrorSubsystem.ES_DM, 479, ErrorSeverity.E_WARN, ErrorGeneric.EV_EMPTY, 2); //"%!%[%argc% - no|No] target file(s) in branch view."
		public static int MsgDm_ExBVIEW = ErrorOf(ErrorSubsystem.ES_DM, 368, ErrorSeverity.E_WARN, ErrorGeneric.EV_EMPTY, 2); //"%!%[%argc% - no|No] target file(s) in both client and branch view."
		public static int MsgDm_ExPROTECT = ErrorOf(ErrorSubsystem.ES_DM, 369, ErrorSeverity.E_WARN, ErrorGeneric.EV_EMPTY, 1); //"[%argc% - no|No] permission for operation on file(s)."
		public static int MsgDm_ExPROTECT2 = ErrorOf(ErrorSubsystem.ES_DM, 480, ErrorSeverity.E_WARN, ErrorGeneric.EV_EMPTY, 2); //"%!%[%argc% - no|No] permission for operation on file(s)."
		public static int MsgDm_ExPROTNAME = ErrorOf(ErrorSubsystem.ES_DM, 370, ErrorSeverity.E_WARN, ErrorGeneric.EV_EMPTY, 1); //"[%argc% - protected|Protected] namespace - access denied."
		public static int MsgDm_ExPROTNAME2 = ErrorOf(ErrorSubsystem.ES_DM, 481, ErrorSeverity.E_WARN, ErrorGeneric.EV_EMPTY, 2); //"%!%[%argc% - protected|Protected] namespace - access denied."
		public static int MsgDm_ExINTEGPEND = ErrorOf(ErrorSubsystem.ES_DM, 371, ErrorSeverity.E_WARN, ErrorGeneric.EV_EMPTY, 1); //"[%argc% - all|All] revision(s) already integrated in pending changelist."
		public static int MsgDm_ExINTEGPERM = ErrorOf(ErrorSubsystem.ES_DM, 372, ErrorSeverity.E_WARN, ErrorGeneric.EV_EMPTY, 1); //"[%argc% - all|All] revision(s) already integrated."
		public static int MsgDm_ExINTEGMOVEDEL = ErrorOf(ErrorSubsystem.ES_DM, 725, ErrorSeverity.E_WARN, ErrorGeneric.EV_EMPTY, 1); //"[%argc% - move/delete(s)|Move/delete(s)] must be integrated along with matching move/add(s)."
		public static int MsgDm_ExDIFF = ErrorOf(ErrorSubsystem.ES_DM, 373, ErrorSeverity.E_WARN, ErrorGeneric.EV_EMPTY, 1); //"[%argc% - no|No] differing files."
		public static int MsgDm_ExDIFFPre101 = ErrorOf(ErrorSubsystem.ES_DM, 527, ErrorSeverity.E_WARN, ErrorGeneric.EV_EMPTY, 1); //"[%argc% - no|No] file(s) to diff."
		public static int MsgDm_ExDIGESTED = ErrorOf(ErrorSubsystem.ES_DM, 374, ErrorSeverity.E_WARN, ErrorGeneric.EV_EMPTY, 1); //"[%argc% - file(s)|File(s)] already have digests."
		public static int MsgDm_ExFILE = ErrorOf(ErrorSubsystem.ES_DM, 375, ErrorSeverity.E_WARN, ErrorGeneric.EV_EMPTY, 1); //"[%argc% - no|No] such file(s)."
		public static int MsgDm_ExHAVE = ErrorOf(ErrorSubsystem.ES_DM, 376, ErrorSeverity.E_WARN, ErrorGeneric.EV_EMPTY, 1); //"[%argc% - file(s)|File(s)] not on client."
		public static int MsgDm_ExINTEGED = ErrorOf(ErrorSubsystem.ES_DM, 377, ErrorSeverity.E_WARN, ErrorGeneric.EV_EMPTY, 1); //"[%argc% - no|No] file(s) integrated."
		public static int MsgDm_ExLABEL = ErrorOf(ErrorSubsystem.ES_DM, 378, ErrorSeverity.E_WARN, ErrorGeneric.EV_EMPTY, 1); //"[%argc% - file(s)|File(s)] not in label."
		public static int MsgDm_ExLABSYNC = ErrorOf(ErrorSubsystem.ES_DM, 379, ErrorSeverity.E_WARN, ErrorGeneric.EV_EMPTY, 1); //"[%argc% - label|Label] in sync."
		public static int MsgDm_ExOPENALL = ErrorOf(ErrorSubsystem.ES_DM, 380, ErrorSeverity.E_WARN, ErrorGeneric.EV_EMPTY, 1); //"[%argc% - file(s)|File(s)] not opened anywhere."
		public static int MsgDm_ExOPENCHANGE = ErrorOf(ErrorSubsystem.ES_DM, 381, ErrorSeverity.E_WARN, ErrorGeneric.EV_EMPTY, 1); //"[%argc% - file(s)|File(s)] not opened in that changelist."
		public static int MsgDm_ExUNLOCKCHANGE = ErrorOf(ErrorSubsystem.ES_DM, 650, ErrorSeverity.E_WARN, ErrorGeneric.EV_EMPTY, 1); //"[%argc% - shelved|Shelved] file(s) not locked in that changelist."
		public static int MsgDm_ExOPENCLIENT = ErrorOf(ErrorSubsystem.ES_DM, 382, ErrorSeverity.E_WARN, ErrorGeneric.EV_EMPTY, 1); //"[%argc% - file(s)|File(s)] not opened on this client."
		public static int MsgDm_ExOPENNOTEDIT = ErrorOf(ErrorSubsystem.ES_DM, 383, ErrorSeverity.E_WARN, ErrorGeneric.EV_EMPTY, 1); //"[%argc% - file(s)|File(s)] not opened for edit."
		public static int MsgDm_ExOPENDFLT = ErrorOf(ErrorSubsystem.ES_DM, 384, ErrorSeverity.E_WARN, ErrorGeneric.EV_EMPTY, 1); //"[%argc% - file(s)|File(s)] not opened in default changelist."
		public static int MsgDm_ExRESOLVED = ErrorOf(ErrorSubsystem.ES_DM, 385, ErrorSeverity.E_WARN, ErrorGeneric.EV_EMPTY, 1); //"[%argc% - no|No] file(s) resolved."
		public static int MsgDm_ExTORESOLVE = ErrorOf(ErrorSubsystem.ES_DM, 387, ErrorSeverity.E_WARN, ErrorGeneric.EV_EMPTY, 1); //"[%argc% - no|No] file(s) to resolve."
		public static int MsgDm_ExTORETYPE = ErrorOf(ErrorSubsystem.ES_DM, 674, ErrorSeverity.E_WARN, ErrorGeneric.EV_EMPTY, 1); //"[%argc% - no|No] file(s) to retype."
		public static int MsgDm_ExUPTODATE = ErrorOf(ErrorSubsystem.ES_DM, 388, ErrorSeverity.E_WARN, ErrorGeneric.EV_EMPTY, 1); //"[%argc% - file(s)|File(s)] up-to-date."
		public static int MsgDm_ExTOUNSHELVE = ErrorOf(ErrorSubsystem.ES_DM, 516, ErrorSeverity.E_WARN, ErrorGeneric.EV_EMPTY, 1); //"[%argc% - no|No] file(s) to unshelve."
		public static int MsgDm_ExTORECONCILE = ErrorOf(ErrorSubsystem.ES_DM, 683, ErrorSeverity.E_WARN, ErrorGeneric.EV_EMPTY, 1); //"[%argc% - no|No] file(s) to reconcile."
		public static int MsgDm_ExABOVECHANGE = ErrorOf(ErrorSubsystem.ES_DM, 389, ErrorSeverity.E_WARN, ErrorGeneric.EV_EMPTY, 1); //"[%argc% - no|No] revision(s) above those at that changelist number."
		public static int MsgDm_ExABOVEDATE = ErrorOf(ErrorSubsystem.ES_DM, 390, ErrorSeverity.E_WARN, ErrorGeneric.EV_EMPTY, 1); //"[%argc% - no|No] revision(s) after that date."
		public static int MsgDm_ExABOVEHAVE = ErrorOf(ErrorSubsystem.ES_DM, 391, ErrorSeverity.E_WARN, ErrorGeneric.EV_EMPTY, 1); //"[%argc% - no|No] revision(s) above those on client."
		public static int MsgDm_ExABOVELABEL = ErrorOf(ErrorSubsystem.ES_DM, 392, ErrorSeverity.E_WARN, ErrorGeneric.EV_EMPTY, 1); //"[%argc% - no|No] revision(s) above those in label."
		public static int MsgDm_ExABOVEREVISION = ErrorOf(ErrorSubsystem.ES_DM, 393, ErrorSeverity.E_WARN, ErrorGeneric.EV_EMPTY, 1); //"[%argc% - no|No] revision(s) above that revision."
		public static int MsgDm_ExATCHANGE = ErrorOf(ErrorSubsystem.ES_DM, 394, ErrorSeverity.E_WARN, ErrorGeneric.EV_EMPTY, 1); //"[%argc% - no|No] file(s) at that changelist number."
		public static int MsgDm_ExATDATE = ErrorOf(ErrorSubsystem.ES_DM, 395, ErrorSeverity.E_WARN, ErrorGeneric.EV_EMPTY, 1); //"[%argc% - no|No] file(s) as of that date."
		public static int MsgDm_ExATHAVE = ErrorOf(ErrorSubsystem.ES_DM, 396, ErrorSeverity.E_WARN, ErrorGeneric.EV_EMPTY, 1); //"[%argc% - file(s)|File(s)] not on client."
		public static int MsgDm_ExATLABEL = ErrorOf(ErrorSubsystem.ES_DM, 397, ErrorSeverity.E_WARN, ErrorGeneric.EV_EMPTY, 1); //"[%argc% - file(s)|File(s)] not in label."
		public static int MsgDm_ExATREVISION = ErrorOf(ErrorSubsystem.ES_DM, 398, ErrorSeverity.E_WARN, ErrorGeneric.EV_EMPTY, 1); //"[%argc% - no|No] file(s) at that revision."
		public static int MsgDm_ExATACTION = ErrorOf(ErrorSubsystem.ES_DM, 399, ErrorSeverity.E_WARN, ErrorGeneric.EV_EMPTY, 1); //"[%argc% - no|No] file(s) with that action."
		public static int MsgDm_ExATTEXT = ErrorOf(ErrorSubsystem.ES_DM, 540, ErrorSeverity.E_WARN, ErrorGeneric.EV_EMPTY, 1); //"[%argc% - no|No] file(s) of type text."
		public static int MsgDm_ExBELOWCHANGE = ErrorOf(ErrorSubsystem.ES_DM, 400, ErrorSeverity.E_WARN, ErrorGeneric.EV_EMPTY, 1); //"[%argc% - no|No] revision(s) below those at that changelist number."
		public static int MsgDm_ExBELOWDATE = ErrorOf(ErrorSubsystem.ES_DM, 401, ErrorSeverity.E_WARN, ErrorGeneric.EV_EMPTY, 1); //"[%argc% - no|No] revision(s) before that date."
		public static int MsgDm_ExBELOWHAVE = ErrorOf(ErrorSubsystem.ES_DM, 402, ErrorSeverity.E_WARN, ErrorGeneric.EV_EMPTY, 1); //"[%argc% - no|No] revision(s) below those on client."
		public static int MsgDm_ExBELOWLABEL = ErrorOf(ErrorSubsystem.ES_DM, 403, ErrorSeverity.E_WARN, ErrorGeneric.EV_EMPTY, 1); //"[%argc% - no|No] revision(s) below those in label."
		public static int MsgDm_ExBELOWREVISION = ErrorOf(ErrorSubsystem.ES_DM, 404, ErrorSeverity.E_WARN, ErrorGeneric.EV_EMPTY, 1); //"[%argc% - no|No] revision(s) below that revision."
		public static int MsgDm_OpenWarnPurged = ErrorOf(ErrorSubsystem.ES_DM, 405, ErrorSeverity.E_INFO, ErrorGeneric.EV_USAGE, 2); //"%depotFile% - warning: %action% of purged file"
		public static int MsgDm_MonitorData = ErrorOf(ErrorSubsystem.ES_DM, 406, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 9); //"%id% [%prog% ][%host% ][%runstate%|T] %user% [%client% ]%elapsed% %function% %args%"
		public static int MsgDm_MonitorClear = ErrorOf(ErrorSubsystem.ES_DM, 407, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"** process '%id%' record cleared **"
		public static int MsgDm_MonitorPause = ErrorOf(ErrorSubsystem.ES_DM, 609, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"** process '%id%' record paused **"
		public static int MsgDm_MonitorResume = ErrorOf(ErrorSubsystem.ES_DM, 610, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"** process '%id%' record resumed **"
		public static int MsgDm_MonitorTerminate = ErrorOf(ErrorSubsystem.ES_DM, 408, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"** process '%id%' marked for termination **"
		public static int MsgDm_MonitorCantTerminate = ErrorOf(ErrorSubsystem.ES_DM, 409, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"** process '%id%' can't terminate, runtime < 10 seconds **"
		public static int MsgDm_AdminSpecData = ErrorOf(ErrorSubsystem.ES_DM, 466, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"%depotFile% - created"
		public static int MsgDm_AdminPasswordData = ErrorOf(ErrorSubsystem.ES_DM, 723, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"%user% - must reset password"
		public static int MsgDm_NotUnderRoot = ErrorOf(ErrorSubsystem.ES_DB, 39, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CONTEXT, 2); //"Path '%path%' is not under client's root '%root%'."
		public static int MsgDm_NotUnderClient = ErrorOf(ErrorSubsystem.ES_DB, 40, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CONTEXT, 2); //"Path '%path%' is not under client '%client%'."
		public static int MsgDm_CommandCancelled = ErrorOf(ErrorSubsystem.ES_DB, 62, ErrorSeverity.E_FAILED, ErrorGeneric.EV_COMM, 0); //"Command terminated because client closed connection."
		public static int MsgDm_MaxResults = ErrorOf(ErrorSubsystem.ES_DB, 32, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ADMIN, 1); //"Request too large (over %maxResults%); see 'p4 help maxresults'."
		public static int MsgDm_MaxScanRows = ErrorOf(ErrorSubsystem.ES_DB, 61, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ADMIN, 1); //"Too many rows scanned (over %maxScanRows%); see 'p4 help maxscanrows'."
		public static int MsgDm_MaxLockTime = ErrorOf(ErrorSubsystem.ES_DM, 453, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ADMIN, 1); //"Operation took too long (over %maxLockTime% seconds); see 'p4 help maxlocktime'."
		public static int MsgDm_UnknownReplicationMode = ErrorOf(ErrorSubsystem.ES_DM, 611, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 1); //"Unknown replication mode '%mode%'."
		public static int MsgDm_UnknownReplicationTarget = ErrorOf(ErrorSubsystem.ES_DM, 612, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 1); //"Unknown replication target '%target%'."
		public static int MsgDm_AdminLockDataEx = ErrorOf(ErrorSubsystem.ES_DM, 475, ErrorSeverity.E_INFO, ErrorGeneric.EV_ADMIN, 1); //"Write: %name%"
		public static int MsgDm_AdminLockDataSh = ErrorOf(ErrorSubsystem.ES_DM, 476, ErrorSeverity.E_INFO, ErrorGeneric.EV_ADMIN, 1); //"Read : %name%"
		public static int MsgDm_DiskSpaceMinimum = ErrorOf(ErrorSubsystem.ES_DM, 613, ErrorSeverity.E_FAILED, ErrorGeneric.EV_UNKNOWN, 3); //"The filesystem '%filesys%' has only %freeSpace% free, but the server configuration requires at least %cfgSpace% available."
		public static int MsgDm_DiskSpaceEstimated = ErrorOf(ErrorSubsystem.ES_DM, 614, ErrorSeverity.E_FAILED, ErrorGeneric.EV_UNKNOWN, 3); //"The filesystem '%filesys%' has only %freeSpace% free, but the command estimates it needs at least %estSpace% available."
		public static int MsgDm_ResourceAlreadyLocked = ErrorOf(ErrorSubsystem.ES_DM, 628, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 2); //"Resource %objType%#%objName% is already locked!"
		public static int MsgDm_NoSuchResource = ErrorOf(ErrorSubsystem.ES_DM, 629, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 2); //"Resource %objType%#%objName% was never locked!"
		public static int MsgDm_BadMaxScanRow = ErrorOf(ErrorSubsystem.ES_DM, 16, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Invalid MaxScanRow number '%value%'."
		public static int MsgDm_ErrorInSpec = ErrorOf(ErrorSubsystem.ES_DM, 69, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ILLEGAL, 1); //"Error in %domain% specification."
		public static int MsgDm_JobName101 = ErrorOf(ErrorSubsystem.ES_DM, 79, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"A job name field with code 101 must be present."
		public static int MsgDm_NoCodeZero = ErrorOf(ErrorSubsystem.ES_DM, 115, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Code 0 not allowed on field '%field%'."
		public static int MsgDm_FixAddDefault = ErrorOf(ErrorSubsystem.ES_DM, 237, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%job% fixed by %change%."
		public static int MsgDm_FixesDataDefault = ErrorOf(ErrorSubsystem.ES_DM, 240, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 5); //"%job% fixed by %change% on %date% by %user%@%client%"
		public static int MsgDm_InfoUnknownDomain = ErrorOf(ErrorSubsystem.ES_DM, 248, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"%domainType% unknown."
		public static int MsgDm_InfoDomain = ErrorOf(ErrorSubsystem.ES_DM, 249, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%domainType% root: %root%"
		public static int MsgDm_EditSpecSave = ErrorOf(ErrorSubsystem.ES_DM, 270, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Spec %type% saved."
		public static int MsgDm_EditSpecNoChange = ErrorOf(ErrorSubsystem.ES_DM, 271, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Spec %type% not changed."
		public static int MsgDm_ExTOINTEG = ErrorOf(ErrorSubsystem.ES_DM, 386, ErrorSeverity.E_WARN, ErrorGeneric.EV_EMPTY, 1); //"[%argc% - no|No] file(s) to integrate."
		public static int MsgDm_IntegOpenOkay = ErrorOf(ErrorSubsystem.ES_DM, 261, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 5); //"%depotFile%%workRev% - %action% from %fromFile%%fromRev%"
		public static int MsgDm_IntegSyncDelete = ErrorOf(ErrorSubsystem.ES_DM, 263, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 5); //"%depotFile%%workRev% - sync/%action% from %fromFile%%fromRev%"
		public static int MsgDm_NoNextRev = ErrorOf(ErrorSubsystem.ES_DM, 48, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 1); //"Can't find %depotFile%'s successor rev!"
	}
}
