using System;
using System.Collections;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Runtime.CompilerServices;
using System.Text;

namespace Perforce.P4
{
	public partial class P4ClientError
	{
		public static int MsgServer_LbrCheckout = ErrorOf(ErrorSubsystem.ES_SERVER, 1, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 1); //"Librarian checkout %lbrFile% failed."
		public static int MsgServer_LbrDiff = ErrorOf(ErrorSubsystem.ES_SERVER, 2, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 1); //"Librarian diff %lbrFile% failed."
		public static int MsgServer_LbrDigest = ErrorOf(ErrorSubsystem.ES_SERVER, 3, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 1); //"Librarian digest %lbrFile% failed."
		public static int MsgServer_LbrFileSize = ErrorOf(ErrorSubsystem.ES_SERVER, 4, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 1); //"Librarian filesize %lbrFile% failed."
		public static int MsgServer_LbrCheckin = ErrorOf(ErrorSubsystem.ES_SERVER, 5, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 1); //"Librarian checkin %lbrFile% failed."
		public static int MsgServer_LbrMerge = ErrorOf(ErrorSubsystem.ES_SERVER, 6, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 0); //"Librarian merge failed."
		public static int MsgServer_LbrNoTrigger = ErrorOf(ErrorSubsystem.ES_SERVER, 390, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ADMIN, 1); //"No archive trigger defined for %lbrFile%."
		public static int MsgServer_BadRoot = ErrorOf(ErrorSubsystem.ES_SERVER, 7, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ADMIN, 0); //"Root directory (set with $P4ROOT or -r flag) invalid."
		public static int MsgServer_BadIPAddr = ErrorOf(ErrorSubsystem.ES_SERVER, 8, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ADMIN, 0); //"Licensing error -- invalid server IP address."
		public static int MsgServer_GotUnlocked = ErrorOf(ErrorSubsystem.ES_SERVER, 9, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 1); //"%depotFile% became unlocked!"
		public static int MsgServer_GotLocked = ErrorOf(ErrorSubsystem.ES_SERVER, 10, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 3); //"%depotFile% was just locked by %user% on %client%!"
		public static int MsgServer_NoInteg = ErrorOf(ErrorSubsystem.ES_SERVER, 11, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 1); //"%depotFile% missing integration record!"
		public static int MsgServer_GotUnresolved = ErrorOf(ErrorSubsystem.ES_SERVER, 13, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 1); //"%toFile% got unresolved!"
		public static int MsgServer_CantOpen = ErrorOf(ErrorSubsystem.ES_SERVER, 14, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 2); //"%depotFile% - can't %action% file!"
		public static int MsgServer_NoDumpName = ErrorOf(ErrorSubsystem.ES_SERVER, 15, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Must specify dump file."
		public static int MsgServer_DumpNameIsADbName = ErrorOf(ErrorSubsystem.ES_SERVER, 621, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Cannot specify db name %dbname% as a dump file name."
		public static int MsgServer_NoCkptName = ErrorOf(ErrorSubsystem.ES_SERVER, 16, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Must specify checkpoint/journal files."
		public static int MsgServer_BadJnlFlag = ErrorOf(ErrorSubsystem.ES_SERVER, 17, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Unknown journaling flag.  Try 'c', 'd', 'j' or 'r'."
		public static int MsgServer_BadExtraFlag = ErrorOf(ErrorSubsystem.ES_SERVER, 18, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Unknown -x operation.  Try 'f', 'i', 'u', 'v', or 'x'."
		public static int MsgServer_ExtraIDUsage = ErrorOf(ErrorSubsystem.ES_SERVER, 567, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: p4d -xD [ serverID ]"
		public static int MsgServer_ServerIDAlreadySet = ErrorOf(ErrorSubsystem.ES_SERVER, 568, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Server already has a server ID: %serverID%"
		public static int MsgServer_NoServerID = ErrorOf(ErrorSubsystem.ES_SERVER, 569, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Server does not yet have a server ID."
		public static int MsgServer_ServerID = ErrorOf(ErrorSubsystem.ES_SERVER, 570, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Server ID: %serverID%"
		public static int MsgServer_MetaDumpFailed = ErrorOf(ErrorSubsystem.ES_SERVER, 19, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 1); //"%file%: metadata dump failed"
		public static int MsgServer_SkippedJnls = ErrorOf(ErrorSubsystem.ES_SERVER, 368, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ADMIN, 1); //"%count% out of sequence journals were not replayed"
		public static int MsgServer_Password982 = ErrorOf(ErrorSubsystem.ES_SERVER, 20, ErrorSeverity.E_FAILED, ErrorGeneric.EV_UPGRADE, 0); //"You need a 98.2 or newer client to access as a password-protected user."
		public static int MsgServer_BadPassword = ErrorOf(ErrorSubsystem.ES_SERVER, 21, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CONFIG, 0); //"Perforce password (P4PASSWD) invalid or unset."
		public static int MsgServer_MustSetPassword = ErrorOf(ErrorSubsystem.ES_SERVER, 307, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Password must be set before access can be granted."
		public static int MsgServer_WeakPassword = ErrorOf(ErrorSubsystem.ES_SERVER, 321, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"The security level of this server requires the password to be reset."
		public static int MsgServer_TicketOnly = ErrorOf(ErrorSubsystem.ES_SERVER, 322, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Password not allowed at this server security level, use 'p4 login'."
		public static int MsgServer_Unicode = ErrorOf(ErrorSubsystem.ES_SERVER, 22, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CONFIG, 0); //"Unicode server permits only unicode enabled clients."
		public static int MsgServer_Unicode2 = ErrorOf(ErrorSubsystem.ES_SERVER, 23, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CONFIG, 0); //"Unicode clients require a unicode enabled server."
		public static int MsgServer_OperationFailed = ErrorOf(ErrorSubsystem.ES_SERVER, 24, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 1); //"Operation: %command%"
		public static int MsgServer_OperationDate = ErrorOf(ErrorSubsystem.ES_SERVER, 25, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 1); //"Date %date%:"
		public static int MsgServer_BadCommand = ErrorOf(ErrorSubsystem.ES_SERVER, 26, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Unknown command.  Try 'p4 help' for info."
		public static int MsgServer_IllegalCommand = ErrorOf(ErrorSubsystem.ES_SERVER, 329, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Illegal command usage.  Try 'p4 help' for info."
		public static int MsgServer_HandshakeFailed = ErrorOf(ErrorSubsystem.ES_SERVER, 27, ErrorSeverity.E_FAILED, ErrorGeneric.EV_COMM, 0); //"Handshake failed."
		public static int MsgServer_ConnectBroken = ErrorOf(ErrorSubsystem.ES_SERVER, 28, ErrorSeverity.E_FAILED, ErrorGeneric.EV_COMM, 1); //"Connection from %peerAddress% broken."
		public static int MsgServer_ClientOpFailed = ErrorOf(ErrorSubsystem.ES_SERVER, 29, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CLIENT, 0); //"Client side operation(s) failed.  Command aborted."
		public static int MsgServer_Usage = ErrorOf(ErrorSubsystem.ES_SERVER, 30, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Usage: %usage%"
		public static int MsgServer_OldDiffClient = ErrorOf(ErrorSubsystem.ES_SERVER, 31, ErrorSeverity.E_FAILED, ErrorGeneric.EV_UPGRADE, 0); //"Client doesn't have necessary support for diff -s."
		public static int MsgServer_OldReconcileClient = ErrorOf(ErrorSubsystem.ES_SERVER, 583, ErrorSeverity.E_FAILED, ErrorGeneric.EV_UPGRADE, 0); //"Client doesn't have necessary support for reconcile."
		public static int MsgServer_Jobs982Win = ErrorOf(ErrorSubsystem.ES_SERVER, 33, ErrorSeverity.E_FAILED, ErrorGeneric.EV_UPGRADE, 0); //"Must upgrade to 98.2 p4win to access jobs."
		public static int MsgServer_No973Wingui = ErrorOf(ErrorSubsystem.ES_SERVER, 302, ErrorSeverity.E_FAILED, ErrorGeneric.EV_UPGRADE, 0); //"Must upgrade past 97.3 p4win for this operation."
		public static int MsgServer_JobsDashS = ErrorOf(ErrorSubsystem.ES_SERVER, 34, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 2); //
		public static int MsgServer_AddDelete = ErrorOf(ErrorSubsystem.ES_SERVER, 35, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Can't add (-a) and delete (-d) at the same time."
		public static int MsgServer_ZFlagsConflict = ErrorOf(ErrorSubsystem.ES_SERVER, 537, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Must not use both 'z' and 'Z' flags"
		public static int MsgServer_Password991 = ErrorOf(ErrorSubsystem.ES_SERVER, 36, ErrorSeverity.E_FAILED, ErrorGeneric.EV_UPGRADE, 0); //"Only 99.1 or later clients support 'p4 passwd'."
		public static int MsgServer_Password032 = ErrorOf(ErrorSubsystem.ES_SERVER, 310, ErrorSeverity.E_FAILED, ErrorGeneric.EV_UPGRADE, 0); //"Only 2003.2 or later clients support 'p4 passwd' at this server security level."
		public static int MsgServer_NoClearText = ErrorOf(ErrorSubsystem.ES_SERVER, 311, ErrorSeverity.E_FAILED, ErrorGeneric.EV_UPGRADE, 0); //"This operation is not permitted at this server security level."
		public static int MsgServer_LoginExpired = ErrorOf(ErrorSubsystem.ES_SERVER, 312, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ILLEGAL, 0); //"Your session has expired, please login again."
		public static int MsgServer_PasswordExpired = ErrorOf(ErrorSubsystem.ES_SERVER, 455, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ILLEGAL, 0); //"Your password has expired, please change your password."
		public static int MsgServer_LoginNotRequired = ErrorOf(ErrorSubsystem.ES_SERVER, 313, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"'login' not necessary, no password set for this user."
		public static int MsgServer_LoginPrintTicket = ErrorOf(ErrorSubsystem.ES_SERVER, 314, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"%ticket%"
		public static int MsgServer_LoginUser = ErrorOf(ErrorSubsystem.ES_SERVER, 325, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"User %user% logged in."
		public static int MsgServer_LoginGoodTill = ErrorOf(ErrorSubsystem.ES_SERVER, 326, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"User %user% ticket expires in %hours% hours %minutes% minutes."
		public static int MsgServer_LoginNoTicket = ErrorOf(ErrorSubsystem.ES_SERVER, 327, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"User %user% was authenticated by password not ticket."
		public static int MsgServer_LogoutUser = ErrorOf(ErrorSubsystem.ES_SERVER, 315, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"User %user% logged out."
		public static int MsgServer_LoggedOut = ErrorOf(ErrorSubsystem.ES_SERVER, 318, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ILLEGAL, 0); //"Your session was logged out, please login again."
		public static int MsgServer_Login032 = ErrorOf(ErrorSubsystem.ES_SERVER, 319, ErrorSeverity.E_FAILED, ErrorGeneric.EV_UPGRADE, 0); //"Only 2003.2 or later clients support 'p4 login' at this server security level."
		public static int MsgServer_Login042 = ErrorOf(ErrorSubsystem.ES_SERVER, 335, ErrorSeverity.E_FAILED, ErrorGeneric.EV_UPGRADE, 0); //"Only 2004.2 or later clients support 'p4 login' for external authentication."
		public static int MsgServer_Login072 = ErrorOf(ErrorSubsystem.ES_SERVER, 355, ErrorSeverity.E_FAILED, ErrorGeneric.EV_UPGRADE, 0); //"Only 2007.2 or later clients support 'p4 login' for single sign-on."
		public static int MsgServer_SSOfailed = ErrorOf(ErrorSubsystem.ES_SERVER, 356, ErrorSeverity.E_FAILED, ErrorGeneric.EV_UNKNOWN, 1); //"Single sign-on on client failed: %result%"
		public static int MsgServer_SSONoEnv = ErrorOf(ErrorSubsystem.ES_SERVER, 357, ErrorSeverity.E_FAILED, ErrorGeneric.EV_UNKNOWN, 0); //"Single sign-on on client failed: 'P4LOGINSSO' not set."
		public static int MsgServer_SSOInvalid = ErrorOf(ErrorSubsystem.ES_SERVER, 358, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ILLEGAL, 0); //"Login invalid."
		public static int MsgServer_CantAuthenticate = ErrorOf(ErrorSubsystem.ES_SERVER, 334, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ILLEGAL, 1); //"Command unavailable: external authentication '%triggerType%' trigger not found."
		public static int MsgServer_CantChangeOther = ErrorOf(ErrorSubsystem.ES_SERVER, 336, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ILLEGAL, 0); //"Cannot change password for another user with external authentication."
		public static int MsgServer_NoSuchUser = ErrorOf(ErrorSubsystem.ES_SERVER, 37, ErrorSeverity.E_FAILED, ErrorGeneric.EV_UNKNOWN, 1); //"User %user% doesn't exist."
		public static int MsgServer_BadPassword0 = ErrorOf(ErrorSubsystem.ES_SERVER, 38, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ILLEGAL, 0); //"Password invalid."
		public static int MsgServer_BadPassword1 = ErrorOf(ErrorSubsystem.ES_SERVER, 39, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ILLEGAL, 0); //"Passwords don't match."
		public static int MsgServer_PasswordTooShort2 = ErrorOf(ErrorSubsystem.ES_SERVER, 543, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ILLEGAL, 1); //"Password should be at least %size% characters in length."
		public static int MsgServer_PasswordTooLong = ErrorOf(ErrorSubsystem.ES_SERVER, 527, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ILLEGAL, 1); //"Password should be no longer than %maxLength% bytes in length."
		public static int MsgServer_PasswordTooSimple = ErrorOf(ErrorSubsystem.ES_SERVER, 309, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ILLEGAL, 0); //"Password should be mixed case or contain non alphabetic characters."
		public static int MsgServer_NoProxyAuth = ErrorOf(ErrorSubsystem.ES_SERVER, 369, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ILLEGAL, 1); //"Authentication from resolved port '%port%' not allowed!"
		public static int MsgServer_MimAttack = ErrorOf(ErrorSubsystem.ES_SERVER, 429, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ILLEGAL, 0); //"Problem with TCP connections between client and server"
		public static int MsgServer_NoSuppASflag = ErrorOf(ErrorSubsystem.ES_SERVER, 40, ErrorSeverity.E_FAILED, ErrorGeneric.EV_UPGRADE, 0); //"Your client doesn't support the -as flag."
		public static int MsgServer_NoSuppVflag = ErrorOf(ErrorSubsystem.ES_SERVER, 41, ErrorSeverity.E_FAILED, ErrorGeneric.EV_UPGRADE, 0); //"Your client doesn't support the -v flag."
		public static int MsgServer_SubmitFailed = ErrorOf(ErrorSubsystem.ES_SERVER, 42, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NOTYET, 1); //"Submit failed -- fix problems above then use 'p4 submit -c %change%'."
		public static int MsgServer_SubmitShelvedFailed = ErrorOf(ErrorSubsystem.ES_SERVER, 641, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NOTYET, 1); //"Submit failed -- fix problems above then use 'p4 submit -e %change%'."
		public static int MsgServer_CounterWarning = ErrorOf(ErrorSubsystem.ES_SERVER, 518, ErrorSeverity.E_WARN, ErrorGeneric.EV_NONE, 3); //"Warning: '%counterName%' counter is now %counterValue%, maximum allowed is %counterMax%"
		public static int MsgServer_SubmitIsShelved = ErrorOf(ErrorSubsystem.ES_SERVER, 410, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NOTYET, 1); //"Change %change% has shelved files --  cannot submit."
		public static int MsgServer_SubmitNeedsShelved = ErrorOf(ErrorSubsystem.ES_SERVER, 640, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NOTYET, 1); //"Change %change% does not have shelved files --  cannot submit."
		public static int MsgServer_CouldntLock = ErrorOf(ErrorSubsystem.ES_SERVER, 43, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NOTYET, 0); //"File(s) couldn't be locked."
		public static int MsgServer_MergesPending = ErrorOf(ErrorSubsystem.ES_SERVER, 44, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NOTYET, 0); //"Merges still pending -- use 'resolve' to merge files."
		public static int MsgServer_ResolveOrRevert = ErrorOf(ErrorSubsystem.ES_SERVER, 45, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NOTYET, 0); //"Out of date files must be resolved or reverted."
		public static int MsgServer_CantRevertToPurged = ErrorOf(ErrorSubsystem.ES_SERVER, 501, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NOTYET, 1); //"%file% has been purged and cannot be reverted. Use 'p4 revert -k' and then 'p4 sync' to get a newer revision."
		public static int MsgServer_RetypeInvalidTempobj = ErrorOf(ErrorSubsystem.ES_SERVER, 374, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NONE, 0); //"Invalid +S modifier or xtempobj type used for changing librarian filetype.\nSee 'p4 help retype'."
		public static int MsgServer_NoSubmit = ErrorOf(ErrorSubsystem.ES_SERVER, 46, ErrorSeverity.E_FAILED, ErrorGeneric.EV_EMPTY, 0); //"No files to submit."
		public static int MsgServer_TriggerFailed = ErrorOf(ErrorSubsystem.ES_SERVER, 47, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NOTYET, 2); //"'%trigger%' validation failed: %result%"
		public static int MsgServer_TriggerOutput = ErrorOf(ErrorSubsystem.ES_SERVER, 362, ErrorSeverity.E_INFO, ErrorGeneric.EV_NOTYET, 1); //"%result%"
		public static int MsgServer_TriggersFailed = ErrorOf(ErrorSubsystem.ES_SERVER, 48, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NOTYET, 1); //"Submit validation failed -- fix problems then use 'p4 submit -c %change%'."
		public static int MsgServer_SubmitAborted = ErrorOf(ErrorSubsystem.ES_SERVER, 49, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NOTYET, 1); //"Submit aborted -- fix problems then use 'p4 submit -c %change%'."
		public static int MsgServer_SubmitShelvedAborted = ErrorOf(ErrorSubsystem.ES_SERVER, 642, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NOTYET, 1); //"Submit aborted -- fix problems then use 'p4 submit -e %change%'."
		public static int MsgServer_PopulateAborted = ErrorOf(ErrorSubsystem.ES_SERVER, 595, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NOTYET, 0); //"Populate aborted -- fix problems and retry."
		public static int MsgServer_PopulateIsVirtual = ErrorOf(ErrorSubsystem.ES_SERVER, 633, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Target stream is virtual, cannot update."
		public static int MsgServer_IntegIsTask = ErrorOf(ErrorSubsystem.ES_SERVER, 631, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Target of integration '%stream%' requires an appropriate task stream client."
		public static int MsgServer_PropertyAdd = ErrorOf(ErrorSubsystem.ES_SERVER, 634, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"Property %settingName% %action%."
		public static int MsgServer_PropertyDelete = ErrorOf(ErrorSubsystem.ES_SERVER, 635, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Property %settingName% deleted."
		public static int MsgServer_UseProperty = ErrorOf(ErrorSubsystem.ES_SERVER, 636, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: property [ -a -n name -v value | -d -n name | -l [ -n name ] ] [ -s sequence ] [ -u user | -g group ] [ -A ] [ -F filter -T taglist -m max ]"
		public static int MsgServer_NoDefaultSubmit = ErrorOf(ErrorSubsystem.ES_SERVER, 50, ErrorSeverity.E_FAILED, ErrorGeneric.EV_EMPTY, 0); //"No files to submit from the default changelist."
		public static int MsgServer_BadImport = ErrorOf(ErrorSubsystem.ES_SERVER, 354, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CLIENT, 2); //"Can't copy %depotFile%%depotRev% - revision has been purged!"
		public static int MsgServer_BadTransfers = ErrorOf(ErrorSubsystem.ES_SERVER, 51, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CLIENT, 0); //"Some file(s) could not be transferred from client."
		public static int MsgServer_DigestMisMatch = ErrorOf(ErrorSubsystem.ES_SERVER, 465, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CLIENT, 3); //"%clientFile% corrupted during transfer %clientDigest% vs %serverDigest%"
		public static int MsgServer_SubmitDataChanged = ErrorOf(ErrorSubsystem.ES_SERVER, 324, ErrorSeverity.E_FAILED, ErrorGeneric.EV_EMPTY, 0); //"Files newly opened or reverted during submission."
		public static int MsgServer_SubmitTampered = ErrorOf(ErrorSubsystem.ES_SERVER, 342, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NONE, 1); //"%clientFile% tampered with after resolve - edit or revert."
		public static int MsgServer_DirsWild = ErrorOf(ErrorSubsystem.ES_SERVER, 52, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Wildcard ... not allowed by 'p4 dirs'.  Use * instead."
		public static int MsgServer_HelpSeeRename = ErrorOf(ErrorSubsystem.ES_SERVER, 53, ErrorSeverity.E_WARN, ErrorGeneric.EV_USAGE, 0); //"See 'p4 help rename' for instructions on renaming files."
		public static int MsgServer_PurgeReport = ErrorOf(ErrorSubsystem.ES_SERVER, 54, ErrorSeverity.E_WARN, ErrorGeneric.EV_NONE, 0); //"This was report mode.  Use -y to remove files."
		public static int MsgServer_SnapReport = ErrorOf(ErrorSubsystem.ES_SERVER, 346, ErrorSeverity.E_WARN, ErrorGeneric.EV_NONE, 0); //"This was report mode (-n),  no files were snapped (copied)."
		public static int MsgServer_PurgeWarning = ErrorOf(ErrorSubsystem.ES_SERVER, 303, ErrorSeverity.E_WARN, ErrorGeneric.EV_NONE, 2); //"Warning: could not undo lazy copy link '%target%' -> '%source%"
		public static int MsgServer_PurgeOptGone = ErrorOf(ErrorSubsystem.ES_SERVER, 347, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Obliterate -z option deprecated - use 'p4 snap' instead"
		public static int MsgServer_PurgeBadOption = ErrorOf(ErrorSubsystem.ES_SERVER, 471, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"'%path%' has revision range (not compatible with -b)."
		public static int MsgServer_LogCommand = ErrorOf(ErrorSubsystem.ES_SERVER, 55, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"%text%"
		public static int MsgServer_LogEstimates = ErrorOf(ErrorSubsystem.ES_SERVER, 632, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 5); //
		public static int MsgServer_Unlicensed = ErrorOf(ErrorSubsystem.ES_SERVER, 56, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ADMIN, 0); //"Unlicensed server cannot start while over user/client quota."
		public static int MsgServer_TrackCommand = ErrorOf(ErrorSubsystem.ES_SERVER, 57, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%command%\n%text%"
		public static int MsgServer_NoValidLicense = ErrorOf(ErrorSubsystem.ES_SERVER, 58, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ADMIN, 0); //"Must shutdown unlicensed server to add license."
		public static int MsgServer_MaxLicensedFiles = ErrorOf(ErrorSubsystem.ES_SERVER, 463, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ADMIN, 1); //"Maximum licensed files (%files%) exceeded."
		public static int MsgServer_MaxUnLicensedFiles = ErrorOf(ErrorSubsystem.ES_SERVER, 464, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ADMIN, 1); //"Maximum users/clients AND maximum files (%files%) exceeded."
		public static int MsgServer_NoCentralLicense = ErrorOf(ErrorSubsystem.ES_SERVER, 472, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ADMIN, 0); //"Unlicensed server cannot perform remote authentication."
		public static int MsgServer_RemoteNotAllowed = ErrorOf(ErrorSubsystem.ES_SERVER, 664, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ADMIN, 0); //"This server requires service user authentication for remote server access. Please configure service user accounts for servers which connect to this one."
		public static int MsgServer_InsecureReplica = ErrorOf(ErrorSubsystem.ES_SERVER, 717, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ADMIN, 2); //"Replica access refused. Ensure that the serverid and service user are correctly configured on the replica. Server %serverid% may not be used by service user %serviceUser%."
		public static int MsgServer_NoAuthFileCount = ErrorOf(ErrorSubsystem.ES_SERVER, 476, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ADMIN, 0); //"Files limited license cannot perform remote authentication."
		public static int MsgServer_ClientBadHost = ErrorOf(ErrorSubsystem.ES_SERVER, 589, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ADMIN, 1); //"TCP connection not licensed from '%address%'."
		public static int MsgServer_NoAuthServiceOnly = ErrorOf(ErrorSubsystem.ES_SERVER, 590, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ADMIN, 0); //"Service limited license cannot perform remote authentication."
		public static int MsgServer_BadServicePack = ErrorOf(ErrorSubsystem.ES_SERVER, 320, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ADMIN, 1); //"On Windows XP the Perforce server requires at least \"
		public static int MsgServer_Startup = ErrorOf(ErrorSubsystem.ES_SERVER, 337, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 4); //"Perforce Server starting %date% pid %pid% %ver%[ %mode% mode]."
		public static int MsgServer_Shutdown = ErrorOf(ErrorSubsystem.ES_SERVER, 338, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"Perforce Server shutdown %date% pid %pid%."
		public static int MsgServer_Restarted = ErrorOf(ErrorSubsystem.ES_SERVER, 515, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"Perforce Server restarted %date% pid %pid%."
		public static int MsgServer_Restarting = ErrorOf(ErrorSubsystem.ES_SERVER, 516, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 4); //"Perforce Server restarting %date% pid %pid% %ver%[ %mode% mode]."
		public static int MsgServer_CreatingDb = ErrorOf(ErrorSubsystem.ES_SERVER, 340, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Perforce db files in '%root%' will be created if missing..."
		public static int MsgServer_Quiescing = ErrorOf(ErrorSubsystem.ES_SERVER, 648, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"Perforce Server quiescing %date% pid %pid%, %cnt% thread(s)."
		public static int MsgServer_QuiesceFailed = ErrorOf(ErrorSubsystem.ES_SERVER, 649, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"Perforce Server quiesce %date% pid %pid%, failed after 60 seconds."
		public static int MsgServer_ReDowngrade = ErrorOf(ErrorSubsystem.ES_SERVER, 650, ErrorSeverity.E_WARN, ErrorGeneric.EV_NONE, 2); //"Perforce Server %date% pid %pid%, downgrading restart to a shutdown."
		public static int MsgServer_CounterDelete = ErrorOf(ErrorSubsystem.ES_SERVER, 100, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Counter %counterName% deleted."
		public static int MsgServer_CounterSet = ErrorOf(ErrorSubsystem.ES_SERVER, 101, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Counter %counterName% set."
		public static int MsgServer_CounterGet = ErrorOf(ErrorSubsystem.ES_SERVER, 102, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"%counterValue%"
		public static int MsgServer_KeyDelete = ErrorOf(ErrorSubsystem.ES_SERVER, 626, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Key %counterName% deleted."
		public static int MsgServer_KeySet = ErrorOf(ErrorSubsystem.ES_SERVER, 627, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Key %counterName% set."
		public static int MsgServer_CounterNotNumeric = ErrorOf(ErrorSubsystem.ES_SERVER, 423, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Can't increment counter '%counterName%' - value is not numeric."
		public static int MsgServer_KeyNotNumeric = ErrorOf(ErrorSubsystem.ES_SERVER, 629, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Can't increment key '%keyName%' - value is not numeric."
		public static int MsgServer_DescribeFixed = ErrorOf(ErrorSubsystem.ES_SERVER, 103, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"Jobs fixed ...\n"
		public static int MsgServer_DescribeAffected = ErrorOf(ErrorSubsystem.ES_SERVER, 104, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"Affected files ...\n"
		public static int MsgServer_DescribeMovedFiles = ErrorOf(ErrorSubsystem.ES_SERVER, 377, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"\nMoved files ...\n"
		public static int MsgServer_DescribeDifferences = ErrorOf(ErrorSubsystem.ES_SERVER, 105, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"\nDifferences ..."
		public static int MsgServer_DescribeEmpty = ErrorOf(ErrorSubsystem.ES_SERVER, 106, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //""
		public static int MsgServer_DescribeShelved = ErrorOf(ErrorSubsystem.ES_SERVER, 409, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"Shelved files ...\n"
		public static int MsgServer_Diff2Differ = ErrorOf(ErrorSubsystem.ES_SERVER, 107, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"(... files differ ...)"
		public static int MsgServer_Diff2BadArgs = ErrorOf(ErrorSubsystem.ES_SERVER, 292, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"File argument(s) require filepath(s), see 'p4 help diff2'."
		public static int MsgServer_GrepIllegalContext = ErrorOf(ErrorSubsystem.ES_DM, 433, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NONE, 1); //"%context%: invalid context length argument"
		public static int MsgServer_GrepContextTooLarge = ErrorOf(ErrorSubsystem.ES_DM, 434, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NONE, 2); //"%context%: larger than maximum of %maxcontext%"
		public static int MsgServer_IndexOutput = ErrorOf(ErrorSubsystem.ES_SERVER, 108, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"%value% words added/deleted."
		public static int MsgServer_InfoUser = ErrorOf(ErrorSubsystem.ES_SERVER, 109, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"User name: %user%"
		public static int MsgServer_InfoBadUser = ErrorOf(ErrorSubsystem.ES_SERVER, 110, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"User name: %user% (illegal)"
		public static int MsgServer_InfoClient = ErrorOf(ErrorSubsystem.ES_SERVER, 111, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Client name: %client%"
		public static int MsgServer_InfoBadClient = ErrorOf(ErrorSubsystem.ES_SERVER, 112, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Client name: %client% (illegal)"
		public static int MsgServer_InfoStream = ErrorOf(ErrorSubsystem.ES_SERVER, 449, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Client stream: %stream%"
		public static int MsgServer_InfoHost = ErrorOf(ErrorSubsystem.ES_SERVER, 113, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Client host: %host%"
		public static int MsgServer_InfoDirectory = ErrorOf(ErrorSubsystem.ES_SERVER, 114, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Current directory: %dirName%"
		public static int MsgServer_InfoDiskSpace = ErrorOf(ErrorSubsystem.ES_SERVER, 514, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 6); //"%name% (type %fsType%) : %freeBytes% free, %usedBytes% used, %totalBytes% total (%pctUsed%%% full)"
		public static int MsgServer_InfoClientAddress = ErrorOf(ErrorSubsystem.ES_SERVER, 115, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Client address: %clientAddr%"
		public static int MsgServer_InfoPeerAddress = ErrorOf(ErrorSubsystem.ES_SERVER, 584, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Peer address: %peerAddr%"
		public static int MsgServer_InfoServerAddress = ErrorOf(ErrorSubsystem.ES_SERVER, 116, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Server address: %serverAddr%"
		public static int MsgServer_InfoServerEncryption = ErrorOf(ErrorSubsystem.ES_SERVER, 585, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Server encryption: %serverEncryption%"
		public static int MsgServer_InfoServerCertExpire = ErrorOf(ErrorSubsystem.ES_SERVER, 585, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Server cert expires: %serverCertExpire%"
		public static int MsgServer_InfoProxyAddress = ErrorOf(ErrorSubsystem.ES_SERVER, 499, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Proxy address: %clientAddr%"
		public static int MsgServer_InfoProxyEncryption = ErrorOf(ErrorSubsystem.ES_SERVER, 586, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Proxy encryption: %proxyEncryption%"
		public static int MsgServer_InfoProxyCertExpire = ErrorOf(ErrorSubsystem.ES_SERVER, 585, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Proxy cert expires: %proxyCertExpire%"
		public static int MsgServer_InfoServerRoot = ErrorOf(ErrorSubsystem.ES_SERVER, 117, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Server root: %serverRoot%"
		public static int MsgServer_InfoServerDate = ErrorOf(ErrorSubsystem.ES_SERVER, 118, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"Server date: %serverDate% %serverTimeZone%"
		public static int MsgServer_InfoServerVersion = ErrorOf(ErrorSubsystem.ES_SERVER, 119, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"Server version: %id% (%idDate%)"
		public static int MsgServer_InfoServerLicense = ErrorOf(ErrorSubsystem.ES_SERVER, 120, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Server license: %license%"
		public static int MsgServer_InfoServerLicenseIp = ErrorOf(ErrorSubsystem.ES_SERVER, 382, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Server license-ip: %licenseIp%"
		public static int MsgServer_InfoServerUptime = ErrorOf(ErrorSubsystem.ES_SERVER, 367, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Server uptime: %uptime%"
		public static int MsgServer_InfoUnknownClient = ErrorOf(ErrorSubsystem.ES_SERVER, 137, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"Client unknown."
		public static int MsgServer_InfoClientRoot = ErrorOf(ErrorSubsystem.ES_SERVER, 138, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Client root: %root%"
		public static int MsgServer_InfoProxyVersion = ErrorOf(ErrorSubsystem.ES_SERVER, 139, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"Proxy version: %id% (%idDate%)"
		public static int MsgServer_InfoAuthServer = ErrorOf(ErrorSubsystem.ES_SERVER, 140, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Authorization server: %authServer%"
		public static int MsgServer_InfoChangeServer = ErrorOf(ErrorSubsystem.ES_SERVER, 370, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Changelist server: %changeServer%"
		public static int MsgServer_InfoServerID = ErrorOf(ErrorSubsystem.ES_SERVER, 598, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"ServerID: %ServerID%"
		public static int MsgServer_InfoCaseHandling = ErrorOf(ErrorSubsystem.ES_SERVER, 426, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Case Handling: %caseHandling%"
		public static int MsgServer_InfoMinClient = ErrorOf(ErrorSubsystem.ES_SERVER, 431, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Minimum Client Level: %minClient%"
		public static int MsgServer_InfoPingTime = ErrorOf(ErrorSubsystem.ES_SERVER, 393, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%fileCount% messages in %time%"
		public static int MsgServer_InfoPingTimeB = ErrorOf(ErrorSubsystem.ES_SERVER, 394, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"%fileCount% messages of %fileSize% characters in %time%"
		public static int MsgServer_InfoPingCount = ErrorOf(ErrorSubsystem.ES_SERVER, 395, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%time% for %fileCount%  messages"
		public static int MsgServer_InfoPingCountB = ErrorOf(ErrorSubsystem.ES_SERVER, 396, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"%time% for %fileCount% messages of %fileSize% characters"
		public static int MsgServer_ErrorPingProtocol = ErrorOf(ErrorSubsystem.ES_SERVER, 397, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NONE, 0); //"ping remote buffers requires 9.2"
		public static int MsgServer_ErrorPingParam = ErrorOf(ErrorSubsystem.ES_SERVER, 417, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NONE, 0); //"Invalid ping parameter"
		public static int MsgServer_PasswordSave = ErrorOf(ErrorSubsystem.ES_SERVER, 121, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"Password updated."
		public static int MsgServer_PasswordDelete = ErrorOf(ErrorSubsystem.ES_SERVER, 122, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"Password deleted."
		public static int MsgServer_PasswordNoChange = ErrorOf(ErrorSubsystem.ES_SERVER, 123, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"Password not changed."
		public static int MsgServer_ShelveBegin = ErrorOf(ErrorSubsystem.ES_SERVER, 401, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Shelving files for change %change%."
		public static int MsgServer_NoDefaultShelve = ErrorOf(ErrorSubsystem.ES_SERVER, 402, ErrorSeverity.E_FAILED, ErrorGeneric.EV_EMPTY, 0); //"No files to shelve from the default changelist."
		public static int MsgServer_UnshelveNotOwner = ErrorOf(ErrorSubsystem.ES_SERVER, 404, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ILLEGAL, 1); //"Only user '%user%' can purge this shelved changelist."
		public static int MsgServer_ShelveAborted = ErrorOf(ErrorSubsystem.ES_SERVER, 405, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NOTYET, 1); //"Shelve aborted -- fix problems then use 'p4 shelve -c %change%'."
		public static int MsgServer_NoShelve = ErrorOf(ErrorSubsystem.ES_SERVER, 406, ErrorSeverity.E_FAILED, ErrorGeneric.EV_EMPTY, 0); //"No files to shelve."
		public static int MsgServer_NoShelveDelete = ErrorOf(ErrorSubsystem.ES_SERVER, 411, ErrorSeverity.E_FAILED, ErrorGeneric.EV_EMPTY, 0); //"No shelved files in changelist to delete."
		public static int MsgServer_ShelveComplete = ErrorOf(ErrorSubsystem.ES_SERVER, 412, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"%change% files shelved."
		public static int MsgServer_UnshelveFileChanged = ErrorOf(ErrorSubsystem.ES_SERVER, 407, ErrorSeverity.E_FAILED, ErrorGeneric.EV_EMPTY, 1); //"%depotFile% - warning: shelved file was modified during transfer!"
		public static int MsgServer_ShelveDelete = ErrorOf(ErrorSubsystem.ES_SERVER, 408, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"Shelved change %change% [partially deleted, still contains %count% file(s).|deleted.]"
		public static int MsgServer_ShelveMaxSize = ErrorOf(ErrorSubsystem.ES_SERVER, 413, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 2); //"%clientFile% size greater than shelve allows (max %maxFiles%)."
		public static int MsgServer_ShelveTriggersFailed = ErrorOf(ErrorSubsystem.ES_SERVER, 418, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NOTYET, 0); //"Shelve validation failed -- fix problems then try again."
		public static int MsgServer_ShelveXOpen = ErrorOf(ErrorSubsystem.ES_DM, 430, ErrorSeverity.E_INFO, ErrorGeneric.EV_USAGE, 1); //"%depotFile% - warning: shelve of +l file"
		public static int MsgServer_ChangesShelved = ErrorOf(ErrorSubsystem.ES_SERVER, 614, ErrorSeverity.E_INFO, ErrorGeneric.EV_USAGE, 1); //"File(s) shelved in change %change%"
		public static int MsgServer_SpecNotCorrect = ErrorOf(ErrorSubsystem.ES_SERVER, 124, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"Specification not corrected -- giving up."
		public static int MsgServer_ErrorInSpec = ErrorOf(ErrorSubsystem.ES_SERVER, 323, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ILLEGAL, 1); //"Error in %domain% specification."
		public static int MsgServer_SpecArchiveWarning = ErrorOf(ErrorSubsystem.ES_SERVER, 333, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Warning: couldn't archive to spec depot (%lbrFile%)"
		public static int MsgServer_SpecCheckTriggers = ErrorOf(ErrorSubsystem.ES_SERVER, 350, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"Error parsing form text; check form-out triggers?"
		public static int MsgServer_SubmitLocking = ErrorOf(ErrorSubsystem.ES_SERVER, 125, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Locking %unlockedCount% files ..."
		public static int MsgServer_SubmitComplete = ErrorOf(ErrorSubsystem.ES_SERVER, 126, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"%change% submitted."
		public static int MsgServer_SubmitRenamed = ErrorOf(ErrorSubsystem.ES_SERVER, 127, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%change% renamed %newChange% and submitted."
		public static int MsgServer_SubmitBegin = ErrorOf(ErrorSubsystem.ES_SERVER, 128, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Submitting change %change%."
		public static int MsgServer_PopulateComplete = ErrorOf(ErrorSubsystem.ES_SERVER, 591, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%fileCount% files branched[ (change %change%)]."
		public static int MsgServer_ResolveOptAuto = ErrorOf(ErrorSubsystem.ES_SERVER, 486, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"a"
		public static int MsgServer_ResolveOptHelp = ErrorOf(ErrorSubsystem.ES_SERVER, 487, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"?"
		public static int MsgServer_ResolveOptMerge = ErrorOf(ErrorSubsystem.ES_SERVER, 488, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"am"
		public static int MsgServer_ResolveOptSkip = ErrorOf(ErrorSubsystem.ES_SERVER, 489, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"s"
		public static int MsgServer_ResolveOptTheirs = ErrorOf(ErrorSubsystem.ES_SERVER, 490, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"at"
		public static int MsgServer_ResolveOptYours = ErrorOf(ErrorSubsystem.ES_SERVER, 491, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"ay"
		public static int MsgServer_ResolvePromptMerge = ErrorOf(ErrorSubsystem.ES_SERVER, 492, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"am: %resolveAction%"
		public static int MsgServer_ResolvePromptTheirs = ErrorOf(ErrorSubsystem.ES_SERVER, 493, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"at: %resolveAction%"
		public static int MsgServer_ResolvePromptType = ErrorOf(ErrorSubsystem.ES_SERVER, 494, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"%resolveType%:"
		public static int MsgServer_ResolvePromptYours = ErrorOf(ErrorSubsystem.ES_SERVER, 495, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"ay: %resolveAction%"
		public static int MsgServer_ResolveUserError = ErrorOf(ErrorSubsystem.ES_SERVER, 496, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"'%option%' is not an option."
		public static int MsgServer_ResolveUserPrompt = ErrorOf(ErrorSubsystem.ES_SERVER, 497, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Accept(a) Skip(s) Help(?) %option%: "
		public static int MsgServer_ResolveUserPrompt2 = ErrorOf(ErrorSubsystem.ES_SERVER, 517, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Accept(at/ay) Skip(s) Help(?) %option%: "
		public static int MsgServer_ResolvedFile = ErrorOf(ErrorSubsystem.ES_SERVER, 129, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"%toFile% - %how% %fromFile%"
		public static int MsgServer_ResolvedSkipped = ErrorOf(ErrorSubsystem.ES_SERVER, 130, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"%toFile% - resolve skipped."
		public static int MsgServer_ResolveTampered = ErrorOf(ErrorSubsystem.ES_SERVER, 452, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NONE, 1); //"%clientFile% tampered with before resolve - edit or revert."
		public static int MsgServer_JobRebuilt = ErrorOf(ErrorSubsystem.ES_SERVER, 131, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"%job% ..."
		public static int MsgServer_SearchResult = ErrorOf(ErrorSubsystem.ES_SERVER, 132, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"%word%"
		public static int MsgServer_DiffCmp = ErrorOf(ErrorSubsystem.ES_SERVER, 133, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"%path%"
		public static int MsgServer_DiffList = ErrorOf(ErrorSubsystem.ES_SERVER, 134, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%status% %path%"
		public static int MsgServer_DeltaLine1 = ErrorOf(ErrorSubsystem.ES_SERVER, 135, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%lower%: %data%"
		public static int MsgServer_DeltaLine2 = ErrorOf(ErrorSubsystem.ES_SERVER, 136, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"%lower%-%upper%: %data%"
		public static int MsgServer_MonitorDisabled = ErrorOf(ErrorSubsystem.ES_SERVER, 137, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ADMIN, 0); //"Monitor not currently enabled."
		public static int MsgServer_MonitorBadId = ErrorOf(ErrorSubsystem.ES_SERVER, 138, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Invalid session identifier: %id%"
		public static int MsgServer_MonitorNoLockinfo = ErrorOf(ErrorSubsystem.ES_SERVER, 677, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Lock information is not currently available. Configure the monitor.lsof or monitor value to enable collection and display of lock information."
		public static int MsgServer_TooManyCommands = ErrorOf(ErrorSubsystem.ES_SERVER, 637, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Request refused: this server is configured to run a maximum of %maxCommands% simultaneous commands. Please try again later when the load is lower."
		public static int MsgServer_ConfigureSet = ErrorOf(ErrorSubsystem.ES_SERVER, 437, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"For server '%serverName%', configuration variable '%variableName%' set to '%variableValue%'"
		public static int MsgServer_ConfigureUnSet = ErrorOf(ErrorSubsystem.ES_SERVER, 438, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"For server '%serverName%', configuration variable '%variableName%' removed."
		public static int MsgServer_NotThisConfigVar = ErrorOf(ErrorSubsystem.ES_SERVER, 439, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Configuration variable '%name%' may not be changed."
		public static int MsgServer_InvalidConfigValue = ErrorOf(ErrorSubsystem.ES_SERVER, 440, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 2); //"Configuration variable '%name%' may not be set to '%value%'."
		public static int MsgServer_ConfigureNone = ErrorOf(ErrorSubsystem.ES_SERVER, 466, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"No configurables have been set."
		public static int MsgServer_ConfigureServerNone = ErrorOf(ErrorSubsystem.ES_SERVER, 467, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"No configurables have been set for server '%serverName%'."
		public static int MsgServer_IstatInvalid = ErrorOf(ErrorSubsystem.ES_SERVER, 460, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Stream '%stream%' is invalid, use -f to force check."
		public static int MsgServer_UseAdmin = ErrorOf(ErrorSubsystem.ES_SERVER, 200, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: admin { checkpoint | journal | resetpassword | restart | stop | updatespecdepot }"
		public static int MsgServer_UseAdminCheckpoint = ErrorOf(ErrorSubsystem.ES_SERVER, 203, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: admin checkpoint [ -z | -Z ] [ prefix ] "
		public static int MsgServer_UseAdminJournal = ErrorOf(ErrorSubsystem.ES_SERVER, 204, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: admin journal [ -z ] [ prefix ] "
		public static int MsgServer_UseAdminSpecDepot = ErrorOf(ErrorSubsystem.ES_SERVER, 352, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: admin updatespecdepot [ -a | -s type ]"
		public static int MsgServer_UseAdminResetPassword = ErrorOf(ErrorSubsystem.ES_SERVER, 620, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: admin resetpassword -a | -u user"
		public static int MsgServer_UseAdminDBSigs = ErrorOf(ErrorSubsystem.ES_SERVER, 502, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: journaldbchecksums [ -s -b batchsize -c change -l level -u file -t includelist -T excludelist -v version -z ]"
		public static int MsgServer_UseAdminImport = ErrorOf(ErrorSubsystem.ES_SERVER, 360, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: admin import [ -l ] [ -b batchsize ]"
		public static int MsgServer_UseAnnotate = ErrorOf(ErrorSubsystem.ES_SERVER, 289, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: annotate [ -aciIqt -d<flags> ] files..."
		public static int MsgServer_UseArchive = ErrorOf(ErrorSubsystem.ES_SERVER, 453, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: archive -D depot [-n -h -p -q -t ] files..."
		public static int MsgServer_UseBranch = ErrorOf(ErrorSubsystem.ES_SERVER, 205, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: branch [ -d -f -i -S stream -P parent -o ] branchname"
		public static int MsgServer_UseBrancho = ErrorOf(ErrorSubsystem.ES_SERVER, 206, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: branch [ -S stream [ -P parent ] ] -o branchname"
		public static int MsgServer_UseBranchd = ErrorOf(ErrorSubsystem.ES_SERVER, 207, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: branch -d [ -f ] branchname"
		public static int MsgServer_UseBranchi = ErrorOf(ErrorSubsystem.ES_SERVER, 208, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: branch -i"
		public static int MsgServer_UseCachepurge = ErrorOf(ErrorSubsystem.ES_SERVER, 705, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: cachepurge [ -a | -f N | -m N | -s N ] [ -i N -n -R -S N -O -D files... ]"
		public static int MsgServer_UseChange = ErrorOf(ErrorSubsystem.ES_SERVER, 209, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: change [ -d -i -o -s -t<type> -U<user>] [ -f | -u ] [ [ -O ] changelist# ]"
		public static int MsgServer_UseChanged = ErrorOf(ErrorSubsystem.ES_SERVER, 210, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: change -d [ -f ] [ -O ] changelist#"
		public static int MsgServer_UseChangeo = ErrorOf(ErrorSubsystem.ES_SERVER, 211, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: change -o [ -s ] [ -f ] [ [ -O ] changelist# ]"
		public static int MsgServer_UseChangei = ErrorOf(ErrorSubsystem.ES_SERVER, 212, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: change -i [ -s ] [ -f | -u ]"
		public static int MsgServer_UseChanget = ErrorOf(ErrorSubsystem.ES_SERVER, 456, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: change -t restricted | public [ -U user ] [ -f | -u | -O ] changelist#"
		public static int MsgServer_UseChangeU = ErrorOf(ErrorSubsystem.ES_SERVER, 651, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: change -U user [ -t restricted | public ] [ -f ] changelist#"
		public static int MsgServer_UseChangeUt = ErrorOf(ErrorSubsystem.ES_SERVER, 652, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: change -U user -t restricted | public [ -f ] changelist#"
		public static int MsgServer_UseChanges = ErrorOf(ErrorSubsystem.ES_SERVER, 213, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: changes [-i -t -l -L -f -c client -m count -s status -u user] [files...]"
		public static int MsgServer_UseClean = ErrorOf(ErrorSubsystem.ES_SERVER, 674, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: clean [ -a -d -e -I -l -n ] [ files... ]"
		public static int MsgServer_UseClient = ErrorOf(ErrorSubsystem.ES_SERVER, 214, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: client [ -d -f -Fs -i -o -s ] [ -t template | -S stream ] [ -c change ] [ clientname ]"
		public static int MsgServer_UseCliento = ErrorOf(ErrorSubsystem.ES_SERVER, 215, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: client -o [ -t template ] clientname"
		public static int MsgServer_UseClientS = ErrorOf(ErrorSubsystem.ES_SERVER, 510, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: client -S stream [ [ -c change ] -o ] [ clientname ]"
		public static int MsgServer_UseClientd = ErrorOf(ErrorSubsystem.ES_SERVER, 216, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: client -d [ -f [ -Fs ] ] clientname"
		public static int MsgServer_UseClienti = ErrorOf(ErrorSubsystem.ES_SERVER, 217, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: client -i [ -f ]"
		public static int MsgServer_UseClients = ErrorOf(ErrorSubsystem.ES_SERVER, 504, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: client -s [ -f ] -t template | -S stream [ clientname ]"
		public static int MsgServer_UseCluster = ErrorOf(ErrorSubsystem.ES_SERVER, 666, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: cluster [ add-node <server id> | forward-off | master-stop | service-elect | to-standby]"
		public static int MsgServer_UseConfigure = ErrorOf(ErrorSubsystem.ES_SERVER, 436, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //
		public static int MsgServer_UseCopy = ErrorOf(ErrorSubsystem.ES_SERVER, 450, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: copy [ -c changelist# -f -F -m max -n -q -r -s from -v ] [ -b branch to... | -S stream [ -P parent ] [ file... ] | from to ]"
		public static int MsgServer_UseCopyb = ErrorOf(ErrorSubsystem.ES_SERVER, 451, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: copy [ -c changelist# -f -F -m max -n -q -r -s from -v ] -b branch [ to... ]"
		public static int MsgServer_UseCopyS = ErrorOf(ErrorSubsystem.ES_SERVER, 508, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: copy [ -c changelist# -f -F -m max -n -q -r -s from -v ] -S stream [ -P parent ] [ file... ]"
		public static int MsgServer_UseCounter = ErrorOf(ErrorSubsystem.ES_SERVER, 218, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: counter [ -f ] [ -d | -i | -m ] counter_name [ value ] [ ... ]"
		public static int MsgServer_UseCounteri = ErrorOf(ErrorSubsystem.ES_SERVER, 424, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: counter [ -f ] -i counter_name"
		public static int MsgServer_UseCounters = ErrorOf(ErrorSubsystem.ES_SERVER, 219, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: counters [ -e nameFilter -m max ]"
		public static int MsgServer_UseCstat = ErrorOf(ErrorSubsystem.ES_SERVER, 419, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: cstat [files...]"
		public static int MsgServer_UseDbpack = ErrorOf(ErrorSubsystem.ES_SERVER, 359, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: dbpack [ -c pages -l 0|1|2 ] { -a | dbtable ... }"
		public static int MsgServer_UseDbstat = ErrorOf(ErrorSubsystem.ES_SERVER, 344, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: dbstat [ -h ] { -a | dbtable ... }\n       dbstat -s"
		public static int MsgServer_UseDbverify = ErrorOf(ErrorSubsystem.ES_SERVER, 573, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: dbverify [ -t db.table ] [ -U ] [-v]"
		public static int MsgServer_UseDepot = ErrorOf(ErrorSubsystem.ES_SERVER, 220, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: depot [ -i -o ] [ -d [ -f ] ] depotname"
		public static int MsgServer_UseDepoto = ErrorOf(ErrorSubsystem.ES_SERVER, 221, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: depot -o depotname"
		public static int MsgServer_UseDepotd = ErrorOf(ErrorSubsystem.ES_SERVER, 222, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: depot -d depotname"
		public static int MsgServer_UseDepoti = ErrorOf(ErrorSubsystem.ES_SERVER, 223, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: depot -i"
		public static int MsgServer_UseDepots = ErrorOf(ErrorSubsystem.ES_SERVER, 224, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: depots"
		public static int MsgServer_UseDescribe = ErrorOf(ErrorSubsystem.ES_SERVER, 225, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: describe [-d<flags> -m max -s -S -f -O] changelist# ..."
		public static int MsgServer_UseDiff = ErrorOf(ErrorSubsystem.ES_SERVER, 226, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: diff [ -d<flags> -f -m max -Od -s<flag> -t ] [files...]"
		public static int MsgServer_UseDiff2 = ErrorOf(ErrorSubsystem.ES_SERVER, 227, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: diff2 [ -d<flags> -Od -q -t -u ] [ -b branchName ] [ -S stream ] [ -P parent ] file file2"
		public static int MsgServer_UseDiff2b = ErrorOf(ErrorSubsystem.ES_SERVER, 228, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: diff2 [ -d<flags> -Od -q -t -u ] -b branchName [ [ file ] file2 ]"
		public static int MsgServer_UseDiff2S = ErrorOf(ErrorSubsystem.ES_SERVER, 506, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: diff2 [ -d<flags> -Od -q -t -u ] -S stream [ -P parent ] [ [ file ] file2 ]"
		public static int MsgServer_UseDiff2n = ErrorOf(ErrorSubsystem.ES_SERVER, 229, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: diff2 [ -d<flags> -Od -q -t -u ] file file2"
		public static int MsgServer_UseDirs = ErrorOf(ErrorSubsystem.ES_SERVER, 230, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: dirs [-C -D -H] [-S stream] dirs..."
		public static int MsgServer_UseDiskspace = ErrorOf(ErrorSubsystem.ES_SERVER, 513, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: diskspace [ P4ROOT | P4JOURNAL | P4LOG | TEMP | depot ]"
		public static int MsgServer_UseBranches = ErrorOf(ErrorSubsystem.ES_SERVER, 534, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: branches [ -t ] [ -u user ] [ [-e|-E] query -m max ]"
		public static int MsgServer_UseLabels = ErrorOf(ErrorSubsystem.ES_SERVER, 535, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: labels [ -t ] [ -u user ] [ -U ] [ [-e|-E] query -m max ] [ -a | -s serverID ]"
		public static int MsgServer_UseDomainClients = ErrorOf(ErrorSubsystem.ES_SERVER, 481, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: clients [ -t ] [ -u user ] [ -U ] [ [-e|-E] query -m max ] [ -a | -s serverID ] [ -S stream ]"
		public static int MsgServer_UseDup = ErrorOf(ErrorSubsystem.ES_SERVER, 351, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: duplicate [ -n -q ] from[revRange] to"
		public static int MsgServer_UseExport = ErrorOf(ErrorSubsystem.ES_SERVER, 378, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: export [ -f -r -F <filter> -j <journal> -c <checkpoint> -l <lines> -J <prefix> -T <tableexcludelist> -P <filterpattern>]"
		public static int MsgServer_UseFilelog = ErrorOf(ErrorSubsystem.ES_SERVER, 232, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: filelog [ -c changelist# -h -i -l -L -t -m maxRevs -p -s ] files..."
		public static int MsgServer_UseFiles = ErrorOf(ErrorSubsystem.ES_SERVER, 233, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: files [-a -A -e -m max] [-U] files..."
		public static int MsgServer_UseFix = ErrorOf(ErrorSubsystem.ES_SERVER, 234, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: fix [ -d ] [ -s status ] -c changelist# jobName ..."
		public static int MsgServer_UseFixes = ErrorOf(ErrorSubsystem.ES_SERVER, 235, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: fixes [ -i -m max -c changelist# -j jobName ] [files...] "
		public static int MsgServer_UseFstat = ErrorOf(ErrorSubsystem.ES_SERVER, 236, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: fstat [ -F filter -T fields -m max -r ] [ -c | -e changelist# ] [ -Ox -Rx -Sx ] [-A pattern] [-U] file[rev]..."
		public static int MsgServer_UseGrep = ErrorOf(ErrorSubsystem.ES_SERVER, 427, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: grep [ -a -i -n -A after -B before -C context -t -s ] [ -v | -l | -L ] [ -F | -G ] -e pattern files..."
		public static int MsgServer_UseGroup = ErrorOf(ErrorSubsystem.ES_SERVER, 237, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: group [ -a -A -d -i -o ] groupname"
		public static int MsgServer_UseGroupo = ErrorOf(ErrorSubsystem.ES_SERVER, 238, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: group -o groupname"
		public static int MsgServer_UseGroupd = ErrorOf(ErrorSubsystem.ES_SERVER, 239, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: group [ -a ] -d groupname"
		public static int MsgServer_UseGroupi = ErrorOf(ErrorSubsystem.ES_SERVER, 240, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: group [ -a -A ] -i"
		public static int MsgServer_UseGroups = ErrorOf(ErrorSubsystem.ES_SERVER, 241, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: groups [ -m max ] [ [ [ -i [ -v ] ] user | group ] | [ -v [ group ] ]  | [ -g | -u | -o name ] ]"
		public static int MsgServer_UseHave = ErrorOf(ErrorSubsystem.ES_SERVER, 242, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: have [files...]"
		public static int MsgServer_UseHelp = ErrorOf(ErrorSubsystem.ES_SERVER, 243, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: help [command ...]"
		public static int MsgServer_UseIndex = ErrorOf(ErrorSubsystem.ES_SERVER, 244, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: index [ -a attrib ] [ -d ] name"
		public static int MsgServer_UseInfo = ErrorOf(ErrorSubsystem.ES_SERVER, 245, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: info [-s]"
		public static int MsgServer_UseInteg = ErrorOf(ErrorSubsystem.ES_SERVER, 246, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: integrate [ -c changelist# -D<flags> -f -h -m max -n -Obr -q -r -s from -v ] [ -b branch to... | from to ] [ -S stream [ -P parent ] files... ]"
		public static int MsgServer_UseIntegb = ErrorOf(ErrorSubsystem.ES_SERVER, 247, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: integrate [ -c changelist# -D<flags> -f -h -m max -n -Obr -q -r -s from -v ] -b branch [ to... ]"
		public static int MsgServer_UseIntegS = ErrorOf(ErrorSubsystem.ES_SERVER, 507, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: integrate [ -c changelist# -D<flags> -f -h -m max -n -Obr -q -r -s from -v ] -S stream [ -P parent ] [ files... ] "
		public static int MsgServer_UseInteged = ErrorOf(ErrorSubsystem.ES_SERVER, 248, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: integrated [ -r ] [ -b branch ] [ files... ]"
		public static int MsgServer_UseInterChanges = ErrorOf(ErrorSubsystem.ES_SERVER, 304, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: interchanges -f -l -t -r -u user -F [ -b branch to... | -S stream [ -P parent ] [ files... ] | from to ]"
		public static int MsgServer_UseInterChangesb = ErrorOf(ErrorSubsystem.ES_SERVER, 305, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: interchanges -f -l -t -r -u user [ -b branch to... ]"
		public static int MsgServer_UseInterChangesS = ErrorOf(ErrorSubsystem.ES_SERVER, 509, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: interchanges -f -l -t -r -u user -F -S stream [ -P parent ] [ files... ]"
		public static int MsgServer_UseIstat = ErrorOf(ErrorSubsystem.ES_SERVER, 459, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: istat [ -a -f -r ] stream"
		public static int MsgServer_UseJob = ErrorOf(ErrorSubsystem.ES_SERVER, 249, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: job [ -d -f -i -o ] [ jobName ]"
		public static int MsgServer_UseJobd = ErrorOf(ErrorSubsystem.ES_SERVER, 250, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: job -d jobName"
		public static int MsgServer_UseJobo = ErrorOf(ErrorSubsystem.ES_SERVER, 251, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: job -o [ jobName ]"
		public static int MsgServer_UseJobi = ErrorOf(ErrorSubsystem.ES_SERVER, 252, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: job -i [ -f ]"
		public static int MsgServer_UseJobs = ErrorOf(ErrorSubsystem.ES_SERVER, 253, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: jobs [-e query -i -l -m count -r] [files...]"
		public static int MsgServer_UseJobSpec = ErrorOf(ErrorSubsystem.ES_SERVER, 254, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: jobspec [ -i -o ]"
		public static int MsgServer_UseJournalWait = ErrorOf(ErrorSubsystem.ES_SERVER, 663, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: journalwait [ -i ]"
		public static int MsgServer_UseJournals = ErrorOf(ErrorSubsystem.ES_SERVER, 700, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: journals [-T field...] [-F filter] [-m max]"
		public static int MsgServer_UseKey = ErrorOf(ErrorSubsystem.ES_SERVER, 624, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: key [ -d | -i | -m ] key_name [ value ] [ ... ]"
		public static int MsgServer_UseKeyi = ErrorOf(ErrorSubsystem.ES_SERVER, 625, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: key -i key_name"
		public static int MsgServer_UseKeys = ErrorOf(ErrorSubsystem.ES_SERVER, 628, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: keys [ -e nameFilter -m max ]"
		public static int MsgServer_UseLabel = ErrorOf(ErrorSubsystem.ES_SERVER, 255, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: label [ -d -f -g -i -o -t template ] labelname"
		public static int MsgServer_UseLabelo = ErrorOf(ErrorSubsystem.ES_SERVER, 256, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: label -o [ -t template ] labelname"
		public static int MsgServer_UseLabeld = ErrorOf(ErrorSubsystem.ES_SERVER, 257, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: label -d [ -f -g ] labelname"
		public static int MsgServer_UseLabeli = ErrorOf(ErrorSubsystem.ES_SERVER, 258, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: label -i [ -f -g ]"
		public static int MsgServer_UseLabelSync = ErrorOf(ErrorSubsystem.ES_SERVER, 259, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: labelsync [-a -d -g -n -q] -l label [files...]"
		public static int MsgServer_UseLicense = ErrorOf(ErrorSubsystem.ES_SERVER, 343, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: license [ -i | -o | -u ]"
		public static int MsgServer_UseList = ErrorOf(ErrorSubsystem.ES_SERVER, 587, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: list [-l label [-d]] [-C] [-M] files..."
		public static int MsgServer_UseLock = ErrorOf(ErrorSubsystem.ES_SERVER, 260, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: lock [-c changelist#] [files...]"
		public static int MsgServer_UseLockstat = ErrorOf(ErrorSubsystem.ES_SERVER, 610, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: lockstat [-c client | -C]"
		public static int MsgServer_UseLogin = ErrorOf(ErrorSubsystem.ES_SERVER, 316, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: login [ -a -p ] [ -s ] [ -h host username ]"
		public static int MsgServer_UseLogout = ErrorOf(ErrorSubsystem.ES_SERVER, 317, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: logout [ -a ] [ username ]"
		public static int MsgServer_UseLogger = ErrorOf(ErrorSubsystem.ES_SERVER, 261, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: logger [ -c sequence# ] [ -t counter_name ]"
		public static int MsgServer_UseLogAppend = ErrorOf(ErrorSubsystem.ES_SERVER, 560, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: logappend -a args..."
		public static int MsgServer_UseLogParse = ErrorOf(ErrorSubsystem.ES_SERVER, 574, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: logparse [ -e ] [-T field...] [-F filter] [-s offset] [-m max] logfilename"
		public static int MsgServer_UseLogRotate = ErrorOf(ErrorSubsystem.ES_SERVER, 561, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: logrotate [ -l log ]"
		public static int MsgServer_UseLogSchema = ErrorOf(ErrorSubsystem.ES_SERVER, 575, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: logschema [-a | recordtype]"
		public static int MsgServer_UseLogstat = ErrorOf(ErrorSubsystem.ES_SERVER, 579, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: logstat [ -l log ]"
		public static int MsgServer_UseLogtail = ErrorOf(ErrorSubsystem.ES_SERVER, 381, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: logtail [ -b blocksize ] [ -s starting offset ] [ -m maxBlocks ] [ -l log ]"
		public static int MsgServer_UseMain = ErrorOf(ErrorSubsystem.ES_SERVER, 262, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: p4d -h for usage."
		public static int MsgServer_UseMerge = ErrorOf(ErrorSubsystem.ES_SERVER, 523, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: merge [ -c changelist# -F -m max -n -Ob -q -r -s from ] [ -b branch to... | -S stream [ -P parent ] [ file... ] | from to ]"
		public static int MsgServer_UseMergeb = ErrorOf(ErrorSubsystem.ES_SERVER, 524, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: merge [ -c changelist# -F -m max -n -Ob -q -r -s from ] -b branch [ to... ]"
		public static int MsgServer_UseMergeS = ErrorOf(ErrorSubsystem.ES_SERVER, 525, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: merge [ -c changelist# -F -m max -n -Ob -q -r -s from ] -S stream [ -P parent ] [ file... ]"
		public static int MsgServer_UseMonitor = ErrorOf(ErrorSubsystem.ES_SERVER, 297, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: monitor { show | terminate | clear | pause | resume }"
		public static int MsgServer_UseMonitorc = ErrorOf(ErrorSubsystem.ES_SERVER, 298, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: monitor terminate [arg]"
		public static int MsgServer_UseMonitorf = ErrorOf(ErrorSubsystem.ES_SERVER, 299, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: monitor clear [arg]"
		public static int MsgServer_UseMonitors = ErrorOf(ErrorSubsystem.ES_SERVER, 300, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: monitor show [ -a -l -e -L -s [ R | T | P | I ] ]"
		public static int MsgServer_UseMonitorP = ErrorOf(ErrorSubsystem.ES_SERVER, 511, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: monitor pause [arg]"
		public static int MsgServer_UseMonitorR = ErrorOf(ErrorSubsystem.ES_SERVER, 512, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: monitor resume [arg]"
		public static int MsgServer_UseOpen = ErrorOf(ErrorSubsystem.ES_SERVER, 263, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: add/edit/delete [-c changelist#] [ -d -f -I -k -n -v ] [-t type] files..."
		public static int MsgServer_UseOpen2 = ErrorOf(ErrorSubsystem.ES_SERVER, 398, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: add/delete [-c changelist#] [ -d -f -I -n -v ] [-t type] files..."
		public static int MsgServer_UseOpened = ErrorOf(ErrorSubsystem.ES_SERVER, 264, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: opened [ -a -m max ] [ -c changelist# -C client -u user -s | -x ] [ files... ]"
		public static int MsgServer_UseOpened2 = ErrorOf(ErrorSubsystem.ES_SERVER, 661, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: opened [ -a -m max -x ] [ files... ]"
		public static int MsgServer_UsePasswd = ErrorOf(ErrorSubsystem.ES_SERVER, 265, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: passwd [ -O oldPasswd -P newPasswd ] [ username ]"
		public static int MsgServer_UsePopulate = ErrorOf(ErrorSubsystem.ES_SERVER, 592, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: populate [ -d desc -f -m max -n -o -r -s from ] [ -b branch | -S stream [ -P parent ] | from to ]"
		public static int MsgServer_UsePopulateb = ErrorOf(ErrorSubsystem.ES_SERVER, 593, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: populate [ -d desc -f -m max -n -o -r -s from ] -b branch [ toFile ]"
		public static int MsgServer_UsePopulateS = ErrorOf(ErrorSubsystem.ES_SERVER, 594, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: populate [ -d desc -f -m max -n -o -r -s from ] -S stream [ -P parent ] [ toFile ]"
		public static int MsgServer_UsePrint = ErrorOf(ErrorSubsystem.ES_SERVER, 623, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: print [-a -A -k -o localFile -q -m max] [-U] files..."
		public static int MsgServer_UseProtect = ErrorOf(ErrorSubsystem.ES_SERVER, 266, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: protect [ -i | -o ]"
		public static int MsgServer_UseProtects = ErrorOf(ErrorSubsystem.ES_SERVER, 339, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: protects [ -a | -g group | -u user ] [ -h host ] [ -m ] [ file ... ]"
		public static int MsgServer_UsePull = ErrorOf(ErrorSubsystem.ES_SERVER, 441, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: pull [ -u | -l [ -s | -j ] | -d -f file -r rev ] [ -J prefix -P filterpattern -T tableexcludelist ] [ -i <N> ]"
		public static int MsgServer_UsePurge = ErrorOf(ErrorSubsystem.ES_SERVER, 267, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: obliterate [-y -A -b -a -h] files..."
		public static int MsgServer_UseRelease = ErrorOf(ErrorSubsystem.ES_SERVER, 268, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: revert [ -a -n -k -w -c changelist# ] files..."
		public static int MsgServer_UseRenameUser = ErrorOf(ErrorSubsystem.ES_SERVER, 701, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //
		public static int MsgServer_UseReconcile = ErrorOf(ErrorSubsystem.ES_SERVER, 582, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: reconcile [ -c changelist# ] [ -a -e -d -l -f -I -m -n -w ] [files...]"
		public static int MsgServer_UseStatus = ErrorOf(ErrorSubsystem.ES_SERVER, 596, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: status [ -c changelist# ] [ -A | [ -a -e -d ] ] [ -f -m -I ] [files...]"
		public static int MsgServer_UseReload = ErrorOf(ErrorSubsystem.ES_SERVER, 613, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: reload [ -f ] [ -c client ] | [ -l label ] | [ -s stream ] [ -p address | [ --input-file file [ -z ] ] ]"
		public static int MsgServer_UseReopen = ErrorOf(ErrorSubsystem.ES_SERVER, 269, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: reopen [-c changelist#] [-t type] files..."
		public static int MsgServer_UseResolve = ErrorOf(ErrorSubsystem.ES_SERVER, 270, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: resolve [ -af -am -as -at -ay -A<flags> -c changelist# -d<flags> -f -n -N -o -t -v ] [ files... ]"
		public static int MsgServer_UseResolved = ErrorOf(ErrorSubsystem.ES_SERVER, 271, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: resolved [ -o ] [files...]"
		public static int MsgServer_UseRestore = ErrorOf(ErrorSubsystem.ES_SERVER, 454, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: restore -D depot [-n] files..."
		public static int MsgServer_UseRetype = ErrorOf(ErrorSubsystem.ES_SERVER, 349, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: retype [ -l -n ] -t type files..."
		public static int MsgServer_UseReview = ErrorOf(ErrorSubsystem.ES_SERVER, 272, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: review [ -c start_changelist# ] [ -t counter_name ]"
		public static int MsgServer_UseReviews = ErrorOf(ErrorSubsystem.ES_SERVER, 273, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: reviews [ -C client ] [ -c changelist# ] [ files... ]"
		public static int MsgServer_UseSearch = ErrorOf(ErrorSubsystem.ES_SERVER, 274, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: search [ -m max ] words ..."
		public static int MsgServer_UseServer = ErrorOf(ErrorSubsystem.ES_SERVER, 562, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: server [ -i | -o | -d | -g ] [ serverID ]"
		public static int MsgServer_UseServerid = ErrorOf(ErrorSubsystem.ES_SERVER, 571, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: serverid [ serverID ]"
		public static int MsgServer_UseServero = ErrorOf(ErrorSubsystem.ES_SERVER, 564, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: server -o serverID"
		public static int MsgServer_UseServerd = ErrorOf(ErrorSubsystem.ES_SERVER, 565, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: server -d serverID"
		public static int MsgServer_UseServeri = ErrorOf(ErrorSubsystem.ES_SERVER, 566, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: server -i"
		public static int MsgServer_UseServers = ErrorOf(ErrorSubsystem.ES_SERVER, 563, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: servers"
		public static int MsgServer_UseSizes = ErrorOf(ErrorSubsystem.ES_SERVER, 341, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: sizes [ -a ] [ -s | -z ] [ -b blocksize ] [ -h | -H ] [ -m max ] [ -S | -U | -A ] files..."
		public static int MsgServer_UseShelve = ErrorOf(ErrorSubsystem.ES_SERVER, 399, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: shelve [ -a option -p ] [ -i [ -f | -r ] | [ -a option -p ] -r -c changelist | -c changelist [ -d ] [ -f ] [ file ... ] ] [ files ] "
		public static int MsgServer_UseShelvec = ErrorOf(ErrorSubsystem.ES_SERVER, 400, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: shelve -c changelist# [ -d [ -f ] [ file ... ] | [ -a option -p ] -r | [ -a option -p ] [ -f ] [ file ... ] ]"
		public static int MsgServer_UseShelvei = ErrorOf(ErrorSubsystem.ES_SERVER, 414, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: shelve -i [ -f | -r ] [ -a option -p ]"
		public static int MsgServer_UseShelver = ErrorOf(ErrorSubsystem.ES_SERVER, 415, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: shelve -r -c changelist# [ -a option -p ]"
		public static int MsgServer_UseShelveNoOpts = ErrorOf(ErrorSubsystem.ES_SERVER, 416, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: shelve [ files ]"
		public static int MsgServer_UseSnap = ErrorOf(ErrorSubsystem.ES_SERVER, 345, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: snap [ -n ] source target"
		public static int MsgServer_UseSpec = ErrorOf(ErrorSubsystem.ES_SERVER, 302, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: spec [ -d | -i | -o ] type"
		public static int MsgServer_UseStream = ErrorOf(ErrorSubsystem.ES_SERVER, 383, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: stream [ -d -i -o -P parent -t type -v ] [ -f ] [ streamname ]"
		public static int MsgServer_UseStreamc = ErrorOf(ErrorSubsystem.ES_SERVER, 540, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: stream [ -P parent ] -t type streamname"
		public static int MsgServer_UseStreamd = ErrorOf(ErrorSubsystem.ES_SERVER, 384, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: stream -d [ -f ] streamname"
		public static int MsgServer_UseStreami = ErrorOf(ErrorSubsystem.ES_SERVER, 385, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: stream -i [ -f ]"
		public static int MsgServer_UseStreamo = ErrorOf(ErrorSubsystem.ES_SERVER, 386, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: stream [ -P parent -t type ] -o streamname"
		public static int MsgServer_UseStreams = ErrorOf(ErrorSubsystem.ES_SERVER, 387, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: streams [ -U -F filter -T fields -m max ] [ streamPath... ]"
		public static int MsgServer_UseSubmit = ErrorOf(ErrorSubsystem.ES_SERVER, 275, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: submit [ -i -s -r -f option ] [ -c changelist# | -e shelvedChange# | -d description ] [file] "
		public static int MsgServer_UseSubmitc = ErrorOf(ErrorSubsystem.ES_SERVER, 276, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: submit [ -r -f option ] -c changelist#"
		public static int MsgServer_UseSubmitd = ErrorOf(ErrorSubsystem.ES_SERVER, 446, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: submit [ -r -f option ] -d description [ file ]\n"
		public static int MsgServer_UseSubmite = ErrorOf(ErrorSubsystem.ES_SERVER, 639, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: submit -e shelvedChange#"
		public static int MsgServer_UseSync = ErrorOf(ErrorSubsystem.ES_SERVER, 277, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: sync [ -f -k -n -N -p -q -s ] [-m max] [files...]"
		public static int MsgServer_UseSyncp = ErrorOf(ErrorSubsystem.ES_SERVER, 348, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: sync [ -n -N -p -q ] [-m max] [files...]"
		public static int MsgServer_UseSyncs = ErrorOf(ErrorSubsystem.ES_SERVER, 503, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: sync [ -n -N -q -s ] [-m max] [files...]"
		public static int MsgServer_UseTag = ErrorOf(ErrorSubsystem.ES_SERVER, 328, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: tag [-d -g -n -U] -l label files..."
		public static int MsgServer_UseTrait = ErrorOf(ErrorSubsystem.ES_SERVER, 330, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: attribute [-e -f -p] -n name [-v value] files..."
		public static int MsgServer_UseTransmit = ErrorOf(ErrorSubsystem.ES_SERVER, 714, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: transmit -t taskid"
		public static int MsgServer_UseTraiti = ErrorOf(ErrorSubsystem.ES_SERVER, 435, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: attribute -i [-e -f -p] -n name [file]"
		public static int MsgServer_UseTriggers = ErrorOf(ErrorSubsystem.ES_SERVER, 278, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: triggers [ -i | -o ]"
		public static int MsgServer_UseTypeMap = ErrorOf(ErrorSubsystem.ES_SERVER, 279, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: typemap [ -i | -o ]"
		public static int MsgServer_UseUnload = ErrorOf(ErrorSubsystem.ES_SERVER, 611, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: unload [ -f -L -z ] [ -c client | -l label | -s stream ] | [ -a | -al | -ac ] [ -d date | -u user ] [ -o output ]"
		public static int MsgServer_UseUnlock = ErrorOf(ErrorSubsystem.ES_SERVER, 280, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: unlock [ -f ] [-c | -s changelist# | -x ] [files...]"
		public static int MsgServer_UseUnshelve = ErrorOf(ErrorSubsystem.ES_SERVER, 403, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: unshelve -s changelist# [ -f -n ] [-c changelist#] [-b branch|-S stream] [file ...]"
		public static int MsgServer_UseUser = ErrorOf(ErrorSubsystem.ES_SERVER, 281, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: user [ -f -d -i -o ] [ username ]"
		public static int MsgServer_UseUsero = ErrorOf(ErrorSubsystem.ES_SERVER, 282, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: user -o username"
		public static int MsgServer_UseUserd = ErrorOf(ErrorSubsystem.ES_SERVER, 283, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: user -d [ -f ] username"
		public static int MsgServer_UseUseri = ErrorOf(ErrorSubsystem.ES_SERVER, 284, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: user -i [ -f ]"
		public static int MsgServer_UseUsers = ErrorOf(ErrorSubsystem.ES_SERVER, 285, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: users [ -l -a -r -c ] [ -m max ] [ user ... ]"
		public static int MsgServer_UseVerify = ErrorOf(ErrorSubsystem.ES_SERVER, 286, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: verify [ -m maxRevs ] [ -q -s ] [ -t | -u | -v | -z ] [ -X ] [ -U ] [ -b batch ] files..."
		public static int MsgServer_UseWhere = ErrorOf(ErrorSubsystem.ES_SERVER, 287, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: where [files...]"
		public static int MsgServer_UseProxyInfo = ErrorOf(ErrorSubsystem.ES_SERVER, 541, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: proxy"
		public static int MsgServer_UseProxy = ErrorOf(ErrorSubsystem.ES_SERVER, 288, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: p4p -h for usage."
		public static int MsgServer_UseMove = ErrorOf(ErrorSubsystem.ES_SERVER, 375, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: move [-c changelist#] [ -f ] [ -k ] [-t type] from to"
		public static int MsgServer_UsePing = ErrorOf(ErrorSubsystem.ES_SERVER, 391, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: ping [ -f -p ] [ -i iterations ] [ -t seconds ] [ -c messages] [ -s server_message_size ] [-r client_message_size]"
		public static int MsgServer_NotAsService = ErrorOf(ErrorSubsystem.ES_SERVER, 443, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Service user may not login to all hosts."
		public static int MsgServer_ServerTooOld = ErrorOf(ErrorSubsystem.ES_SERVER, 290, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 0); //"Server is too old for use with Proxy"
		public static int MsgServer_ProxyChain = ErrorOf(ErrorSubsystem.ES_SERVER, 291, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 0); //"Proxy servers may not be chained together"
		public static int MsgServer_ProxyDelivered = ErrorOf(ErrorSubsystem.ES_SERVER, 293, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"File %path% delivered from proxy server"
		public static int MsgServer_RmtAuthFailed = ErrorOf(ErrorSubsystem.ES_SERVER, 294, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 0); //"Remote authorization server access failed."
		public static int MsgServer_ServiceNotProvided = ErrorOf(ErrorSubsystem.ES_SERVER, 572, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Server does not provide this service."
		public static int MsgServer_ReplicaRestricted = ErrorOf(ErrorSubsystem.ES_SERVER, 420, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 0); //"Replica does not support this command."
		public static int MsgServer_RequiresJournaling = ErrorOf(ErrorSubsystem.ES_SERVER, 662, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 0); //"Replication requires that journaling be enabled."
		public static int MsgServer_ReplicaWrongClient = ErrorOf(ErrorSubsystem.ES_SERVER, 616, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 1); //"Client '%client%' is not restricted to this server."
		public static int MsgServer_ReplicaWrongLabel = ErrorOf(ErrorSubsystem.ES_SERVER, 659, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 1); //"Label '%label%' is not restricted to this server."
		public static int MsgServer_ChangeNotLocal = ErrorOf(ErrorSubsystem.ES_SERVER, 665, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Change %changeNum% belongs to a client not local to this server."
		public static int MsgServer_ReplicaWrongServer = ErrorOf(ErrorSubsystem.ES_SERVER, 658, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 4); //"%objectType% '%objectName%' is restricted to use on server '%serverID%', not '%ourServerID%'."
		public static int MsgServer_DomainIsLocal = ErrorOf(ErrorSubsystem.ES_SERVER, 673, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 2); //"%objectType% '%objectName%' is already bound to this server, transfer from remote server is not needed."
		public static int MsgServer_NotACommitServer = ErrorOf(ErrorSubsystem.ES_SERVER, 655, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 1); //"Edge Server submit from '%client%' is refused. This server has not been configured as a Commit Server, and will not accept such requests. To accept such requests, please use the 'p4 server' and 'p4 serverid' commands to configure the Commit Server behaviors."
		public static int MsgServer_ReplicaNoUpgrade = ErrorOf(ErrorSubsystem.ES_SERVER, 421, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 0); //"Replica can not upgrade automatically."
		public static int MsgServer_ReplicaBadOption = ErrorOf(ErrorSubsystem.ES_SERVER, 422, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 0); //"Unknown Replica Option."
		public static int MsgServer_UnknownReplicationMode = ErrorOf(ErrorSubsystem.ES_SERVER, 468, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 1); //"Unknown replication mode '%mode%'."
		public static int MsgServer_MissingReplicationMode = ErrorOf(ErrorSubsystem.ES_SERVER, 469, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 1); //"Missing replication mode: please specify %missingMode%."
		public static int MsgServer_P4TARGETWasSet = ErrorOf(ErrorSubsystem.ES_SERVER, 615, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 0); //"It appears that the P4TARGET configurable was set for this server, indicating it is a replica server of some type. If that was incorrect, issue the command 'p4d -cshow' to display configurable settings, and issue the command 'p4d \"
		public static int MsgServer_UnknownReplicationTarget = ErrorOf(ErrorSubsystem.ES_SERVER, 470, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 1); //"Unknown replication target '%target%'."
		public static int MsgServer_ReplicaXferFailed = ErrorOf(ErrorSubsystem.ES_SERVER, 474, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 1); //"Transfer of librarian file '%file%' failed."
		public static int MsgServer_BFNoOverwriteLocal = ErrorOf(ErrorSubsystem.ES_SERVER, 622, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 5); //"Replica name conflict: Globally-defined object %domainName% of type %domainType% would overwrite locally-defined object %localName% of type %localType%, which is bound to server %serverId%. Replication has been halted for this replica. To resume replication, the locally-defined object must be deleted (e.g., 'p4 client -d' to delete a Build Farm Client)."
		public static int MsgServer_BadPCache = ErrorOf(ErrorSubsystem.ES_SERVER, 295, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ADMIN, 0); //"Proxy Cache directory (set with $P4PCACHE or -r flag) invalid."
		public static int MsgServer_ProxyNoRemote = ErrorOf(ErrorSubsystem.ES_SERVER, 296, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ADMIN, 0); //"Proxy Does not support caching remote server access."
		public static int MsgServer_ProxyUpdateFail = ErrorOf(ErrorSubsystem.ES_SERVER, 301, ErrorSeverity.E_WARN, ErrorGeneric.EV_ADMIN, 1); //"Proxy could not update its cache.  File is %file%"
		public static int MsgServer_RemoteInvalidCmd = ErrorOf(ErrorSubsystem.ES_SERVER, 306, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"User 'remote' is not allowed direct access to commands."
		public static int MsgServer_InvalidNesting = ErrorOf(ErrorSubsystem.ES_SERVER, 528, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 2); //"Command %outerCommand% was unexpectedly interrupted by command %nestedCommand%"
		public static int MsgServer_ClientTooOld = ErrorOf(ErrorSubsystem.ES_SERVER, 428, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Client is too old to use this server.  %message%"
		public static int MsgServer_NoTicketSupport = ErrorOf(ErrorSubsystem.ES_SERVER, 331, ErrorSeverity.E_WARN, ErrorGeneric.EV_USAGE, 0); //"Must upgrade to 2004.2 p4 to access tickets."
		public static int MsgServer_CommandCancelled = ErrorOf(ErrorSubsystem.ES_SERVER, 332, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ADMIN, 0); //"Command terminated by 'p4 monitor terminate'."
		public static int MsgServer_AdminNoSpecDepot = ErrorOf(ErrorSubsystem.ES_SERVER, 353, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ADMIN, 0); //"Can't create forms - no 'spec' depot found."
		public static int MsgServer_AdminNoSuchSpec = ErrorOf(ErrorSubsystem.ES_SERVER, 578, ErrorSeverity.E_WARN, ErrorGeneric.EV_ADMIN, 1); //"No form specifications of type %specName% were found."
		public static int MsgServer_AdminPasswordNoSuchUser = ErrorOf(ErrorSubsystem.ES_SERVER, 618, ErrorSeverity.E_FAILED, ErrorGeneric.EV_UNKNOWN, 1); //"%user% - no such user, or user does not have a password."
		public static int MsgServer_AdminPasswordNoPasswords = ErrorOf(ErrorSubsystem.ES_SERVER, 619, ErrorSeverity.E_FAILED, ErrorGeneric.EV_EMPTY, 0); //"No users with passwords found."
		public static int MsgServer_ImportReport = ErrorOf(ErrorSubsystem.ES_SERVER, 361, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Imported %count% journal record(s)."
		public static int MsgServer_AdminNothingLocked = ErrorOf(ErrorSubsystem.ES_SERVER, 366, ErrorSeverity.E_INFO, ErrorGeneric.EV_ADMIN, 0); //"No tables locked."
		public static int MsgServer_AdminReplicaCkp = ErrorOf(ErrorSubsystem.ES_SERVER, 529, ErrorSeverity.E_INFO, ErrorGeneric.EV_ADMIN, 0); //"The 'pull' command will perform the checkpoint at the next rotation of the journal on the master."
		public static int MsgServer_NoUserLogs = ErrorOf(ErrorSubsystem.ES_SERVER, 638, ErrorSeverity.E_WARN, ErrorGeneric.EV_ADMIN, 0); //"No serverlog.file configurables specify logs which capture user log records."
		public static int MsgServer_AdminNothingLogged = ErrorOf(ErrorSubsystem.ES_SERVER, 373, ErrorSeverity.E_WARN, ErrorGeneric.EV_ADMIN, 0); //"No journal or log files found."
		public static int MsgServer_LogtailNoLog = ErrorOf(ErrorSubsystem.ES_SERVER, 389, ErrorSeverity.E_WARN, ErrorGeneric.EV_ADMIN, 0); //"Perforce server is not logging to an errorLog."
		public static int MsgServer_AdminSizeData = ErrorOf(ErrorSubsystem.ES_SERVER, 372, ErrorSeverity.E_INFO, ErrorGeneric.EV_ADMIN, 2); //"%name% %size% bytes"
		public static int MsgServer_Move091 = ErrorOf(ErrorSubsystem.ES_SERVER, 376, ErrorSeverity.E_FAILED, ErrorGeneric.EV_UPGRADE, 0); //"Only 2009.1 or later clients support 'p4 move'."
		public static int MsgServer_Move101 = ErrorOf(ErrorSubsystem.ES_SERVER, 425, ErrorSeverity.E_FAILED, ErrorGeneric.EV_UPGRADE, 0); //"Only 2010.1 or later clients support 'p4 move -f'."
		public static int MsgServer_MoveRejected = ErrorOf(ErrorSubsystem.ES_SERVER, 542, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ADMIN, 0); //"Operation 'move' disabled on this server."
		public static int MsgServer_CommandDisabled = ErrorOf(ErrorSubsystem.ES_SERVER, 600, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ADMIN, 1); //"Operation '%commandName%' disabled on this server."
		public static int MsgServer_ActionResolve111 = ErrorOf(ErrorSubsystem.ES_SERVER, 498, ErrorSeverity.E_WARN, ErrorGeneric.EV_UPGRADE, 2); //"%localFile% - upgrade to a 2011.1 or later client to perform an interactive %resolveType% resolve, or use resolve -a."
		public static int MsgServer_BadJournalNum = ErrorOf(ErrorSubsystem.ES_SERVER, 379, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ADMIN, 1); //"Journal %number% is not available"
		public static int MsgServer_BadCheckpointNum = ErrorOf(ErrorSubsystem.ES_SERVER, 380, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ADMIN, 1); //"Checkpoint %number% is not available"
		public static int MsgServer_JournalorCheckpointRequired = ErrorOf(ErrorSubsystem.ES_SERVER, 388, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ADMIN, 0); //"A journal or checkpoint number is required (-j or -c)"
		public static int MsgServer_CurJournalButNotJournaling = ErrorOf(ErrorSubsystem.ES_SERVER, 432, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ADMIN, 0); //"The current journal may not be exported because journaling is disabled."
		public static int MsgServer_PullNotReplica = ErrorOf(ErrorSubsystem.ES_SERVER, 442, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ADMIN, 0); //"Pull only allowed on replica servers."
		public static int MsgServer_PullCommandRunning = ErrorOf(ErrorSubsystem.ES_SERVER, 656, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"A pull command is already running in this server."
		public static int MsgServer_TransferCancelled = ErrorOf(ErrorSubsystem.ES_SERVER, 643, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"The file content transfer was cancelled."
		public static int MsgServer_NoSuchTransfer = ErrorOf(ErrorSubsystem.ES_SERVER, 644, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ADMIN, 2); //"File %lbrFile% revision %lbrRev% is not currently scheduled to be transferred."
		public static int MsgServer_PullOnDemand = ErrorOf(ErrorSubsystem.ES_SERVER, 645, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ADMIN, 0); //"This command is not used with an ondemand replica server."
		public static int MsgServer_TransferNotReplica = ErrorOf(ErrorSubsystem.ES_SERVER, 500, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ADMIN, 0); //"Verify -t only allowed on replica servers."
		public static int MsgServer_UsersCRNotReplica = ErrorOf(ErrorSubsystem.ES_SERVER, 536, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ADMIN, 0); //"Users -c and -r only allowed on replica servers."
		public static int MsgServer_UsersCRNotBoth = ErrorOf(ErrorSubsystem.ES_SERVER, 539, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ADMIN, 0); //"Users -c and -r may not be used together."
		public static int MsgServer_TZMismatch = ErrorOf(ErrorSubsystem.ES_SERVER, 538, ErrorSeverity.E_WARN, ErrorGeneric.EV_ADMIN, 0); //"Replica Timezone does not match master.  This will cause problems with keywords."
		public static int MsgServer_PullTransferPending = ErrorOf(ErrorSubsystem.ES_SERVER, 457, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 6); //"%file% %rev% %type% %state% %process% %timestamp%"
		public static int MsgServer_PullTransferSummary = ErrorOf(ErrorSubsystem.ES_SERVER, 519, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 4); //"File transfers: %transfersActive% active/%transfersTotal% total, bytes: %bytesActive% active/%bytesTotal% total."
		public static int MsgServer_PullTransferChange = ErrorOf(ErrorSubsystem.ES_SERVER, 716, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Oldest change with at least one pending file transfer: %change%."
		public static int MsgServer_PullJournalSummary = ErrorOf(ErrorSubsystem.ES_SERVER, 530, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"Current %server% journal state is:\tJournal %journal%,\tSequence %sequence%."
		public static int MsgServer_PullJournalDate = ErrorOf(ErrorSubsystem.ES_SERVER, 597, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"The statefile was last modified at:\t%lastModTime%."
		public static int MsgServer_ReplicaServerTime = ErrorOf(ErrorSubsystem.ES_SERVER, 653, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"The replica server time is currently:\t%serverDate% %serverTimeZone%"
		public static int MsgServer_CacheAlreadyPurged = ErrorOf(ErrorSubsystem.ES_SERVER, 706, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"Cached content of %file% %rev% has already been purged."
		public static int MsgServer_JournalCounterMismatch = ErrorOf(ErrorSubsystem.ES_SERVER, 531, ErrorSeverity.E_WARN, ErrorGeneric.EV_NONE, 2); //"Journal Counter Rotation Mismatch counter %counter% should be %journal%"
		public static int MsgServer_NeedFilePath = ErrorOf(ErrorSubsystem.ES_SERVER, 532, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Empty file path not allowed in '%filespec%'."
		public static int MsgServer_NoSuchField = ErrorOf(ErrorSubsystem.ES_SERVER, 444, ErrorSeverity.E_FAILED, ErrorGeneric.EV_UNKNOWN, 1); //"Field %field% doesn't exist."
		public static int MsgServer_EmptyTypeList = ErrorOf(ErrorSubsystem.ES_SERVER, 445, ErrorSeverity.E_FAILED, ErrorGeneric.EV_UNKNOWN, 0); //"The list of fields may not be empty."
		public static int MsgServer_NotStreamReady = ErrorOf(ErrorSubsystem.ES_SERVER, 447, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Client '%client%' requires an application that can fully support streams."
		public static int MsgServer_NotStreamOwner = ErrorOf(ErrorSubsystem.ES_SERVER, 473, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 2); //"Currently only user '%user%' can submit to stream '%stream%'."
		public static int MsgServer_VersionedStream = ErrorOf(ErrorSubsystem.ES_SERVER, 599, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Can't submit from a noncurrent stream client '%stream%'."
		public static int MsgServer_BadSortOption = ErrorOf(ErrorSubsystem.ES_SERVER, 461, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"%name% is not a valid sort attribute name."
		public static int MsgServer_TooManySortTraits = ErrorOf(ErrorSubsystem.ES_SERVER, 462, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Too many sort attributes (only 2 allowed)."
		public static int MsgServer_AttrNoPropEdge = ErrorOf(ErrorSubsystem.ES_SERVER, 601, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Cannot add or change propagating attributes on pending files from an edge server."
		public static int MsgServer_InvalidStartupCommand = ErrorOf(ErrorSubsystem.ES_SERVER, 448, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ADMIN, 1); //"Startup command '%cmd%' is unknown or invalid."
		public static int MsgServer_StartupCommandError = ErrorOf(ErrorSubsystem.ES_SERVER, 458, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ADMIN, 1); //"Startup command failed: %message%"
		public static int MsgServer_InvalidServerChain = ErrorOf(ErrorSubsystem.ES_SERVER, 505, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"%serverType% servers may not be chained."
		public static int MsgServer_CommunicationLoop = ErrorOf(ErrorSubsystem.ES_SERVER, 576, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Server %serverID% may not send a message to itself."
		public static int MsgServer_NoCustomSpec = ErrorOf(ErrorSubsystem.ES_SERVER, 475, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ADMIN, 1); //
		public static int MsgServer_OnlyOneFilter = ErrorOf(ErrorSubsystem.ES_SERVER, 533, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Specify either -e or -E, not both."
		public static int MsgServer_JournalFilterBad = ErrorOf(ErrorSubsystem.ES_SERVER, 647, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"-P filter patterns must take the form: [ic:|xc:|if:|xf:]//pattern"
		public static int MsgServer_CopyWrongDirection = ErrorOf(ErrorSubsystem.ES_SERVER, 520, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Stream %stream% needs 'merge' not 'copy' in this direction."
		public static int MsgServer_CopyDoNothing = ErrorOf(ErrorSubsystem.ES_SERVER, 521, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Stream %stream% not configured to 'copy' or 'merge' changes in this direction."
		public static int MsgServer_CopyNeedsMergeFirst = ErrorOf(ErrorSubsystem.ES_SERVER, 522, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Stream %stream% cannot 'copy' over outstanding 'merge' changes."
		public static int MsgServer_MergeWrongDirection = ErrorOf(ErrorSubsystem.ES_SERVER, 526, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Stream %stream% needs 'copy' not 'merge' in this direction."
		public static int MsgServer_NoReparentingTask = ErrorOf(ErrorSubsystem.ES_SERVER, 654, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Stream %stream% is a task stream and therefore cannot 'merge' or 'copy' to/from streams other than its parent."
		public static int MsgServer_UnloadDepotMissing = ErrorOf(ErrorSubsystem.ES_SERVER, 612, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"No unload depot has been defined for this server."
		public static int MsgServer_UnloadOtherUser = ErrorOf(ErrorSubsystem.ES_SERVER, 617, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Specify the '-f' flag in order to unload clients or labels owned by another user."
		public static int MsgServer_CantUnloadLocked = ErrorOf(ErrorSubsystem.ES_SERVER, 630, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 2); //"Specify the '-L' flag in order to unload locked %domainType% %domainName%."
		public static int MsgServer_BoundClientExists = ErrorOf(ErrorSubsystem.ES_SERVER, 580, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Client %client% already exists."
		public static int MsgServer_NewUserExists = ErrorOf(ErrorSubsystem.ES_SERVER, 702, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"User %user% already exists."
		public static int MsgServer_NewUserHasDomains = ErrorOf(ErrorSubsystem.ES_SERVER, 711, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"User %user% has already created workspaces, labels, or other spec objects in this server."
		public static int MsgServer_NewUserHasChanges = ErrorOf(ErrorSubsystem.ES_SERVER, 712, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"User %user% has already created changelists in this server."
		public static int MsgServer_DontRenameSelf = ErrorOf(ErrorSubsystem.ES_SERVER, 703, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"User %user% is the current user, and cannot be renamed."
		public static int MsgServer_UserRenamed = ErrorOf(ErrorSubsystem.ES_SERVER, 710, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"User %oldUser% renamed to %newUser%."
		public static int MsgServer_BoundClientServerID = ErrorOf(ErrorSubsystem.ES_SERVER, 581, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Bound client must be created on a server with a fixed identity."
		public static int MsgServer_ChangeNotSubmitted = ErrorOf(ErrorSubsystem.ES_SERVER, 657, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Change %changeNum% is not a submitted change."
		public static int MsgServer_NotInCluster = ErrorOf(ErrorSubsystem.ES_SERVER, 667, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Server is not a member of a cluster."
		public static int MsgServer_NotClusterReplica = ErrorOf(ErrorSubsystem.ES_SERVER, 668, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Server is not a depot-standby."
		public static int MsgServer_NotClusterMaster = ErrorOf(ErrorSubsystem.ES_SERVER, 669, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 2); //"Server '%server%' is not a depot-master (current journal owner is '%owner%')."
		public static int MsgServer_NotClusterService = ErrorOf(ErrorSubsystem.ES_SERVER, 707, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Server is not a service-node."
		public static int MsgServer_NotEdgeLocal = ErrorOf(ErrorSubsystem.ES_SERVER, 713, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Server is not a workspace-server."
		public static int MsgServer_ClusterCannotWriteJournal = ErrorOf(ErrorSubsystem.ES_SERVER, 670, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Journal writing is not enabled at this server."
		public static int MsgServer_ClusterNotAllowed = ErrorOf(ErrorSubsystem.ES_SERVER, 671, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Operation '%op%' is not supported for a cluster member."
		public static int MsgServer_CommandUnsupported = ErrorOf(ErrorSubsystem.ES_SERVER, 715, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Command '%op%' is not supported on this hardware platform."
		public static int MsgServer_TemporaryLabelInfo = ErrorOf(ErrorSubsystem.ES_SERVER, 588, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"Temporary label '%label%' updated %count% total file(s)."
		public static int MsgServer_NotDistributed = ErrorOf(ErrorSubsystem.ES_SERVER, 660, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"This command is only supported in a distributed configuration."
		public static int MsgServer_PortMissing = ErrorOf(ErrorSubsystem.ES_SERVER, 672, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"This network address '%addr%' does not include a port name or number."
		public static int MsgServer_TargetAccessFailed = ErrorOf(ErrorSubsystem.ES_SERVER, 708, ErrorSeverity.E_FAILED, ErrorGeneric.EV_COMM, 0); //"Replica access to P4TARGET server failed."
		public static int MsgServer_BadTriggerOutput = ErrorOf(ErrorSubsystem.ES_SERVER, 675, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ADMIN, 2); //"A server-side trigger ('%trigger%') produced indecipherable output (%type%)"
		public static int MsgServer_ReopenNotOwnerCL = ErrorOf(ErrorSubsystem.ES_SERVER, 676, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 4); //"%depotFile%%haveRev% already open on client '%client%' in %change% - not reopened."
		public static int MsgServer_UseAdminCopyin = ErrorOf(ErrorSubsystem.ES_SERVER, 201, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: admin copyin prefix"
		public static int MsgServer_UseAdminCopyout = ErrorOf(ErrorSubsystem.ES_SERVER, 202, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: admin copyout prefix"
		public static int MsgServer_UseTunables = ErrorOf(ErrorSubsystem.ES_SERVER, 371, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: tunables [ -a ]"
		public static int MsgServer_UseDomains = ErrorOf(ErrorSubsystem.ES_SERVER, 231, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: branches/labels [ -t ] [ -u user ] [ [-e|-E] query -m max ]"
		public static int MsgServer_PasswordTooShort = ErrorOf(ErrorSubsystem.ES_SERVER, 308, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ILLEGAL, 0); //"Password should be at least 8 characters in length."
		public static int MsgServer_SubmitShelvedHasTask = ErrorOf(ErrorSubsystem.ES_SERVER, 646, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NOTYET, 1); //"Client %client% is a task stream client --  cannot submit shelved change."
	}
}
