"""
This script makes sure that all Perforce users are in the limits group, so
that limits, specifically Max* settings in the group spec, can easily be
made to apply to all users. If used, this script owns and manages the
membership of the group named 'limits'.

This script's job is only to ensure that users are in the group.  It is expected
that the Perforce Admin will apply appropriate values to the Max* settings of
the group spec for the limits group.  Settings such values causes limits to be
applied.  Until limits are applied, membership in the limits group has no impact.

See 'p5 help group' for more information, and also see:

* https://portal.perforce.com/s/article/2521
* https://portal.perforce.com/s/article/2529

BE CAREFUL:  Setting the values requires judgement and experience. If Max* values
are set too low, users will be unduly impacted, and will see errors indicating
that they have exceeded limits such as MaxScanRows or MaxOpenFiles. Appropriate
values depend on various factors such as server hardware resources and Helix
Core date size; there are not "one size fits all" values.

For users that should not have limits applied, create a group no_limits, and add
users (perhaps certain trusted automation users) to that group.  Set the Max*
values for that group to the special value 'unlimited'.

"""

import sys, os, re

instance=sys.argv[1]

os.system("/p4/common/bin/p4login %s" % instance)
os.system("/p4/common/bin/p4master_run %s /p4/%s/bin/p4_%s group -o limits > %s_limits.txt" % (instance, instance, instance, instance))
os.system("/p4/common/bin/p4master_run %s /p4/%s/bin/p4_%s group -o no_limits > %s_no_limits.txt" % (instance, instance, instance, instance))
os.system("/p4/common/bin/p4master_run %s /p4/%s/bin/p4_%s users | iconv -c -f utf8 -t ascii//TRANSLIT//IGNORE > %s_users.txt" % (instance, instance, instance, instance))

with open("%s_users.txt" % instance, "r") as f:
    userlist = [re.sub(r"<.*", r"", u).strip() for u in f.readlines() if u.strip()]

nolimits_users = []
with open("%s_no_limits.txt" % instance, "r") as f:
    for line in f:
        if line.startswith("\t"):
            u = line.strip()
            if u:
                nolimits_users.append(u)

nolimits_set = set(nolimits_users)

with open("%s_limits.txt" % instance, "r") as f_in, \
     open("%s_newlimits.txt" % instance, "w") as f_out:

    for line in f_in:
        if line.strip() == "" or line.startswith("\t"):
            continue
        f_out.write(line)

    for user in userlist:
        if user not in nolimits_set:
            f_out.write("\t%s\n" % user)

os.system("/p4/common/bin/p4master_run %s /p4/%s/bin/p4_%s group -i < %s_newlimits.txt > /dev/null" % (instance, instance, instance, instance))

os.remove("%s_users.txt" % instance)
os.remove("%s_limits.txt" % instance)
os.remove("%s_no_limits.txt" % instance)
os.remove("%s_newlimits.txt" % instance)


