package com.perforce.hws.gf;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import static java.util.Collections.unmodifiableMap;

/**
 * Git Fusion config strings do not always operate nicely as parts of URIs, so
 * here are utilities to assist in the process.
 */
public interface GitFusionStringMethods {

    Map<Character, String> GF_CHARACTER_MAPPING = unmodifiableMap(new GfCharacterMap());

    class GfCharacterMap extends HashMap<Character, String> {
        public GfCharacterMap() {
            put('/', "_0xS_");
            put(':', "_0xC_");
        }
    }

    default String encodeGF(String src) {
        return encodeGF(src, GF_CHARACTER_MAPPING.keySet());
    }

    default String encodeGF(String src, Set<Character> illegalChars) {
        return src.chars()
                .mapToObj(i -> encodeGFChar(i, illegalChars))
                .collect(Collectors.joining());
    }

    default String encodeGFChar(int i, Set<Character> illegalChars) {
        char ch = (char) i;
        if (illegalChars.contains(ch)) {
            return GF_CHARACTER_MAPPING.get(ch);
        } else {
            return String.valueOf(ch);
        }
    }

    default String decodeGF(String src) {
        return decodeGF(src, GF_CHARACTER_MAPPING);
    }

    default String decodeGF(String src, Map<Character, String> mapping) {
        for (Map.Entry<Character, String> e : mapping.entrySet()) {
            src = src.replace(e.getValue(), String.valueOf(e.getKey()));
        }
        return src;
    }
}
